/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc3;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.impl.DSIEmptyResultSet;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.dsi.dataengine.utilities.ExecutionResults;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.jdbc3.S3ForwardResultSet;
import com.vertica.jdbc.jdbc3.S3ParameterMetaData;
import com.vertica.jdbc.jdbc3.S3ResultSetMetaData;
import com.vertica.jdbc.jdbc3.S3UpdatableForwardResultSet;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class S3CallableStatement
extends SCallableStatement {
    public S3CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC3;
    }

    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        SForwardResultSet sForwardResultSet = null;
        sForwardResultSet = this.createsUpdatableResults() ? new S3UpdatableForwardResultSet(this, (IResultSet)executionResult.getResult(), this.m_logger) : new S3ForwardResultSet(this, (IResultSet)executionResult.getResult(), this.m_logger);
        sForwardResultSet.setFetchSize(this.getFetchSize());
        return sForwardResultSet;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return new S3ForwardResultSet(this, new DSIEmptyResultSet(), this.m_logger);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                ExecutionResults executionResults = this.getQueryExecutor().getResults();
                ArrayList<ExecutionResult> arrayList = executionResults.getResults();
                if (arrayList.isEmpty()) {
                    return null;
                }
                if (1 != arrayList.size()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_METADATA, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                ExecutionResult executionResult = (ExecutionResult)arrayList.get(0);
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    ArrayList<? extends IColumn> arrayList2 = iResultSet.getSelectColumns();
                    if (null == arrayList2) {
                        return null;
                    }
                    S3ResultSetMetaData s3ResultSetMetaData = new S3ResultSetMetaData(arrayList2, this.getLogger(), this.getWarningListener());
                    this.setResultSetMetadata(s3ResultSetMetaData);
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S3ParameterMetaData s3ParameterMetaData = new S3ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(s3ParameterMetaData);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

