/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.project;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorStatePersistor;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.project.DecoratedProjectView;

public class ProjectNavigatorView
extends DecoratedProjectView {
    private static final Log log = Log.getLog(ProjectNavigatorView.class);
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.projectNavigator";
    private IMemento memento;

    public void saveState(IMemento memento) {
        if (DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.restore.state.depth") > 0) {
            new NavigatorStatePersistor().saveState(this.getNavigatorViewer().getExpandedElements(), memento);
        }
    }

    private void restoreState() {
        int maxDepth = DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.restore.state.depth");
        if (maxDepth > 0) {
            new NavigatorStatePersistor().restoreState(this.getNavigatorViewer(), this.getRootNode(), maxDepth, this.memento);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        super.init(site, memento);
    }

    @Override
    public DBNNode getRootNode() {
        return this.getModel().getRoot();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        UIUtils.setHelp((Control)parent, (String)"view-project-navigator");
        UIExecutionQueue.queueExec(this::restoreState);
        this.getNavigatorTree().setLabelDecorator(this.labelDecorator);
    }

    @Override
    public void configureView() {
        DBPProject project = NavigatorUtils.getSelectedProject();
        if (project != null) {
            UIUtils.showPreferencesFor((Shell)this.getSite().getShell(), (Object)project.getEclipseProject(), (String[])new String[]{"org.jkiss.dbeaver.preferences.projectSettings"});
        } else {
            ActionUtils.runCommand((String)"org.eclipse.ui.window.preferences", (IServiceLocator)UIUtils.getActiveWorkbenchWindow());
        }
    }
}

