/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IMemento;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;

public class NavigatorStatePersistor {
    private static final Log log = Log.getLog(NavigatorStatePersistor.class);
    private static final String KEY_PREFIX = "element";

    public void saveState(Object[] expandedElements, IMemento memento) {
        int i = 0;
        while (i < expandedElements.length) {
            memento.putString(KEY_PREFIX + i, this.createNodeIdentifier((DBNNode)expandedElements[i]));
            ++i;
        }
    }

    public void restoreState(TreeViewer navigatorViewer, DBNNode rootNode, int maxDepth, IMemento memento) {
        if (memento == null || ArrayUtils.isEmpty((Object[])memento.getAttributeKeys())) {
            return;
        }
        final DBRRunnableWithProgress runnable = monitor -> {
            try {
                if (memento != null) {
                    monitor.beginTask("Expan navigator nodes", memento.getAttributeKeys().length);
                    int i = 0;
                    while (i < memento.getAttributeKeys().length) {
                        if (monitor.isCanceled()) break;
                        String nodeIdentifier = memento.getString(KEY_PREFIX + i);
                        monitor.subTask("Expan node " + nodeIdentifier);
                        DBNNode node = this.findNode(nodeIdentifier, rootNode, 1, maxDepth, monitor);
                        if (node != null && !node.isDisposed()) {
                            UIUtils.syncExec(() -> navigatorViewer.setExpandedState((Object)node, true));
                        }
                        ++i;
                    }
                    monitor.done();
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        };
        AbstractJob expandJob = new AbstractJob("Expand navigator nodes"){
            {
                super($anonymous0);
                this.setSystem(false);
                this.setUser(true);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    runnable.run(monitor);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e);
                }
                catch (InterruptedException interruptedException) {}
                return Status.OK_STATUS;
            }
        };
        UIUtils.asyncExec(() -> ((AbstractJob)expandJob).schedule());
    }

    private DBNNode findNode(String nodeIdentifier, DBNNode rootNode, int currentDepth, int maxDepth, DBRProgressMonitor monitor) throws DBException {
        if (currentDepth <= maxDepth) {
            DBNNode[] childNodes;
            this.initializeNode(rootNode, monitor);
            if (nodeIdentifier.equals(this.createNodeIdentifier(rootNode))) {
                return rootNode;
            }
            if (currentDepth < maxDepth && (childNodes = rootNode.getChildren(monitor)) != null) {
                DBNNode[] dBNNodeArray = childNodes;
                int n = childNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNNode newRootNode = dBNNodeArray[n2];
                    if (nodeIdentifier.contains(this.createNodeIdentifier(newRootNode))) {
                        return this.findNode(nodeIdentifier, newRootNode, currentDepth + 1, maxDepth, monitor);
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private void initializeNode(DBNNode node, DBRProgressMonitor monitor) throws DBException {
        DBPDataSourceContainer dsContainer;
        if (node instanceof DBNDataSource && !(dsContainer = ((DBNDataSource)node).getDataSourceContainer()).isConnected()) {
            dsContainer.connect(monitor, true, false);
        }
        node.getChildren(monitor);
    }

    private String createNodeIdentifier(DBNNode node) {
        StringBuilder identifier = new StringBuilder();
        DBNNode currentNode = node;
        while (currentNode != null) {
            identifier.append(currentNode.getNodeName()).append("/");
            currentNode = currentNode.getParentNode();
        }
        return identifier.toString();
    }
}

