/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.vaccess.DialogCache;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ResourceListDetailsPane;
import com.ibm.as400.vaccess.ResourceListPane;
import com.ibm.as400.vaccess.ResourceListPropertiesPane;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.ResourcePropertiesPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class ResourceListPopupMenuAdapter
extends MouseAdapter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String ACTION_PROPERTIES_ = ResourceLoader.getText("ACTION_PROPERTIES");
    private static final String ACTION_LIST_PROPERTIES_ = ResourceLoader.getText("ACTION_LIST_PROPERTIES");
    private DialogCache dialogCache_ = new DialogCache();
    private ErrorEventSupport errorEventSupport_;
    private ResourceProperties resourceProperties_;
    private ResourceList resourceList_;
    private Object target_;

    public ResourceListPopupMenuAdapter(Object object, ResourceList resourceList, ResourceProperties resourceProperties, ErrorEventSupport errorEventSupport) {
        this.target_ = object;
        this.resourceList_ = resourceList;
        this.resourceProperties_ = resourceProperties;
        this.errorEventSupport_ = errorEventSupport;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getPoint());
        }
    }

    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.resourceProperties_ = resourceProperties;
    }

    public void setResourceList(ResourceList resourceList) {
        this.resourceList_ = resourceList;
    }

    private void showPopupMenu(Component component, Point point) {
        JMenuItem jMenuItem;
        Resource resource = null;
        if (this.target_ instanceof ResourceListPane) {
            resource = ((ResourceListPane)this.target_).getResourceAtPoint(point);
        } else if (this.target_ instanceof ResourceListDetailsPane) {
            resource = ((ResourceListDetailsPane)this.target_).getResourceAtPoint(point);
        } else {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        boolean bl = false;
        if (resource != null) {
            jMenuItem = new JMenuItem(ACTION_PROPERTIES_);
            final Resource resource2 = resource;
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialog jDialog = ResourceListPopupMenuAdapter.this.dialogCache_.resolveDialog(resource2);
                    if (jDialog == null) {
                        jDialog = new ResourcePropertiesPane(resource2, ResourceListPopupMenuAdapter.this.resourceProperties_, ResourceListPopupMenuAdapter.this.errorEventSupport_);
                        ResourceListPopupMenuAdapter.this.dialogCache_.addDialog(resource2, jDialog);
                        jDialog.show();
                    }
                }
            });
            jPopupMenu.add(jMenuItem);
            bl = true;
        }
        if (this.resourceList_ != null) {
            jMenuItem = new JMenuItem(ACTION_LIST_PROPERTIES_);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialog jDialog = ResourceListPopupMenuAdapter.this.dialogCache_.resolveDialog(ResourceListPopupMenuAdapter.this.resourceList_);
                    if (jDialog == null) {
                        jDialog = new ResourceListPropertiesPane(ResourceListPopupMenuAdapter.this.resourceList_, ResourceListPopupMenuAdapter.this.errorEventSupport_);
                        ResourceListPopupMenuAdapter.this.dialogCache_.addDialog(ResourceListPopupMenuAdapter.this.resourceList_, jDialog);
                        jDialog.show();
                    }
                }
            });
            if (bl) {
                jPopupMenu.addSeparator();
            }
            jPopupMenu.add(jMenuItem);
            bl = true;
        }
        if (bl) {
            jPopupMenu.show(component, point.x, point.y);
        }
    }
}

