/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.CoverLetterReader;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;

public class PTFCoverLetter {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private AS400 system_;
    private String nlv_;
    private String path_;
    private int preInstructions_;
    private int postInstructions_;
    private int ccsid_;
    public static final int SPECIAL_INSTRUCTIONS_NO = 0;
    public static final int SPECIAL_INSTRUCTIONS_YES = 1;
    public static final int SPECIAL_INSTRUCTIONS_IMMEDIATE = 2;
    public static final int SPECIAL_INSTRUCTIONS_IPL = 3;
    public static final int SPECIAL_INSTRUCTIONS_UNKNOWN = 9;

    PTFCoverLetter(AS400 aS400, String string, String string2, int n, int n2) {
        this.system_ = aS400;
        this.nlv_ = string;
        this.path_ = string2;
        this.preInstructions_ = n;
        this.postInstructions_ = n2;
        Enumeration enumeration = ConversionMaps.localeNlvMap_.keys();
        int n3 = -1;
        while (enumeration.hasMoreElements() && n3 == -1) {
            Object k = enumeration.nextElement();
            Object v = ConversionMaps.localeNlvMap_.get(k);
            if (!v.equals(this.nlv_)) continue;
            Enumeration enumeration2 = ConversionMaps.localeCcsidMap_.keys();
            while (enumeration2.hasMoreElements() && n3 == -1) {
                Object k2 = enumeration2.nextElement();
                Object v2 = ConversionMaps.localeCcsidMap_.get(k2);
                if (!k2.equals(k)) continue;
                n3 = Integer.parseInt((String)v2);
            }
        }
        if (n3 == -1) {
            n3 = this.system_.getCcsid();
        }
        this.ccsid_ = n3;
    }

    public Reader getContents() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return new CoverLetterReader(this.system_, this.path_, this.ccsid_);
    }

    public String getNLV() {
        return this.nlv_;
    }

    public String getPath() {
        return this.path_;
    }

    public int getPostSpecialInstructions() {
        return this.postInstructions_;
    }

    public int getPreSpecialInstructions() {
        return this.preInstructions_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String toString() {
        return this.path_;
    }
}

