/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import java.io.Closeable;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbConfig;
import org.lightcouch.CouchDbProperties;

public class CouchDbClient
extends CouchDbClientBase
implements Closeable {
    public CouchDbClient() {
    }

    public CouchDbClient(String configFileName) {
        super(new CouchDbConfig(configFileName));
    }

    public CouchDbClient(String dbName, boolean createDbIfNotExist, String protocol, String host, int port, String username, String password) {
        super(new CouchDbConfig(new CouchDbProperties(dbName, createDbIfNotExist, protocol, host, port, username, password)));
    }

    public CouchDbClient(CouchDbProperties properties) {
        super(new CouchDbConfig(properties));
    }

    @Override
    HttpClient createHttpClient(CouchDbProperties props) {
        try {
            Registry<ConnectionSocketFactory> registry = this.createRegistry(props);
            PoolingHttpClientConnectionManager ccm = this.createConnectionManager(props, registry);
            HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)ccm).setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(Consts.UTF_8).build()).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(props.getSocketTimeout()).setConnectTimeout(props.getConnectionTimeout()).build());
            if (props.getProxyHost() != null) {
                clientBuilder.setProxy(new HttpHost(props.getProxyHost(), props.getProxyPort()));
            }
            if (props.getUsername() != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(props.getHost(), props.getPort()), (Credentials)new UsernamePasswordCredentials(props.getUsername(), props.getPassword()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                props.clearPassword();
            }
            this.registerInterceptors(clientBuilder);
            return clientBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error Creating HTTPClient: ", e);
        }
    }

    @Override
    HttpContext createContext() {
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.host, (AuthScheme)new BasicScheme());
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        return context;
    }

    private PoolingHttpClientConnectionManager createConnectionManager(CouchDbProperties props, Registry<ConnectionSocketFactory> registry) {
        PoolingHttpClientConnectionManager ccm = new PoolingHttpClientConnectionManager(registry);
        if (props.getMaxConnections() != 0) {
            ccm.setMaxTotal(props.getMaxConnections());
            ccm.setDefaultMaxPerRoute(props.getMaxConnections());
        }
        return ccm;
    }

    private Registry<ConnectionSocketFactory> createRegistry(CouchDbProperties props) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        RegistryBuilder registry = RegistryBuilder.create();
        if ("https".equals(props.getProtocol())) {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            return registry.register("https", (Object)new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)new NoopHostnameVerifier())).build();
        }
        return registry.register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
    }

    private void registerInterceptors(HttpClientBuilder clientBuilder) {
        clientBuilder.addInterceptorFirst(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws IOException {
                if (CouchDbClientBase.log.isInfoEnabled()) {
                    RequestLine req = request.getRequestLine();
                    CouchDbClientBase.log.info((Object)("> " + req.getMethod() + " " + URLDecoder.decode(req.getUri(), "UTF-8")));
                }
            }
        });
        clientBuilder.addInterceptorFirst(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws IOException {
                if (CouchDbClientBase.log.isInfoEnabled()) {
                    CouchDbClientBase.log.info((Object)("< Status: " + response.getStatusLine().getStatusCode()));
                }
                CouchDbClient.this.validate(response);
            }
        });
    }

    @Override
    public void shutdown() {
        HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }
}

