/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleConnectionBuilder;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleShardingKeyImpl;

@DefaultLogger(value="oracle.jdbc.pool")
@Supports(value={Feature.CONN_POOL})
public abstract class OracleConnectionBuilderImpl
implements OracleConnectionBuilder {
    protected String user = null;
    protected String password = null;
    protected String serviceName = null;
    protected String instanceName = null;
    protected OracleShardingKey shardingKey = null;
    protected OracleShardingKey superShardingKey = null;

    @Override
    public abstract OracleConnection build() throws SQLException;

    @Override
    public OracleConnectionBuilderImpl password(String string) {
        this.password = string;
        return this;
    }

    @Override
    public OracleConnectionBuilderImpl user(String string) {
        this.user = string;
        return this;
    }

    public OracleConnectionBuilderImpl serviceName(String string) {
        this.serviceName = string;
        return this;
    }

    public OracleConnectionBuilderImpl instanceName(String string) {
        this.instanceName = string;
        return this;
    }

    @Override
    public OracleConnectionBuilderImpl shardingKey(OracleShardingKey oracleShardingKey) {
        this.shardingKey = oracleShardingKey;
        return this;
    }

    @Override
    public OracleConnectionBuilderImpl superShardingKey(OracleShardingKey oracleShardingKey) {
        this.superShardingKey = oracleShardingKey;
        if (oracleShardingKey != null) {
            ((OracleShardingKeyImpl)oracleShardingKey).markSuperShardingKey(true);
        }
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public OracleShardingKeyImpl getShardingKey() {
        return (OracleShardingKeyImpl)this.shardingKey;
    }

    public OracleShardingKeyImpl getSuperShardingKey() {
        return (OracleShardingKeyImpl)this.superShardingKey;
    }
}

