/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicenseFormat;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMProductRelease;
import org.jkiss.lm.LMSerializable;
import org.jkiss.lm.LMStatusDetails;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class LMLicense
implements LMSerializable {
    private static final Logger log = Logger.getLogger("LMLicense");
    private static final long DAY_MS = 86400000L;
    public static final long FLAG_NONE = 0L;
    public static final long FLAG_TEST = 1L;
    public static final long FLAG_CANCELED = 2L;
    public static final long FLAG_RESELLER = 4L;
    public static final long FLAG_SUBSCRIPTION = 8L;
    public static final long FLAG_LIMITED = 16L;
    public static final long FLAG_LIMITED_VERSION = 32L;
    public static final long FLAG_SERVER_LICENSE = 64L;
    public static final long FLAG_UNLIMITED_USERS = 256L;
    public static final long FLAG_UNLIMITED_TIME = 512L;
    public static final long FLAG_UNLIMITED_SERVERS = 1024L;
    public static final byte UPDATE_HASH_FORMAT_SIMPLE = 1;
    private byte[] encoded;
    private final String licenseId;
    private final LMLicenseType licenseType;
    private final Date licenseIssueTime;
    private final Date licenseStartTime;
    private final Date licenseEndTime;
    private long flags;
    private final String productId;
    private final String productVersion;
    private final String ownerId;
    private final String ownerCompany;
    private final String ownerName;
    private String ownerEmail;
    private byte yearsNumber;
    private byte reserved1;
    private short usersNumber;
    private LMLicenseFormat licenseFormat;
    private LMStatusDetails remoteStatus;

    public LMLicense(@NotNull byte[] encryptedData, @NotNull Key key) throws LMException {
        this.encoded = encryptedData;
        byte[] data = LMEncryption.decrypt(encryptedData, key);
        int offset = 0;
        this.licenseFormat = LMLicenseFormat.STANDARD;
        try {
            this.licenseFormat = LMLicenseFormat.valueOf(data[offset]);
        }
        catch (Exception exception) {
            log.warning("Unsupported license format: " + data[offset]);
        }
        ++offset;
        if (data.length != this.licenseFormat.getEncryptedLength()) {
            throw new LMException("Bad " + this.licenseFormat + " license length (" + data.length + ")");
        }
        this.licenseId = new String(data, offset, 16).trim();
        this.licenseType = LMLicenseType.valueOf(data[offset += 16]);
        this.licenseIssueTime = LMUtils.getDateFromBytes(data, ++offset);
        this.licenseStartTime = LMUtils.getDateFromBytes(data, offset += 8);
        this.licenseEndTime = LMUtils.getDateFromBytes(data, offset += 8);
        this.flags = LMUtils.bytesToLong(data, offset += 8);
        this.productId = new String(data, offset += 8, 16).trim();
        this.productVersion = new String(data, offset += 16, 8).trim();
        this.ownerId = new String(data, offset += 8, 16).trim();
        this.ownerCompany = new String(data, offset += 16, 64).trim();
        offset += 64;
        if (this.licenseFormat == LMLicenseFormat.STANDARD) {
            this.ownerName = new String(data, offset, 64).trim();
            offset += 64;
        } else {
            this.ownerName = new String(data, offset, 32).trim();
            this.ownerEmail = new String(data, offset += 32, 48).trim();
            offset += 48;
            this.yearsNumber = data[offset++];
            if (this.yearsNumber <= 0) {
                this.yearsNumber = 1;
            }
            this.reserved1 = data[offset++];
            this.usersNumber = LMUtils.bytesToShort(data, offset);
            if (this.usersNumber <= 0) {
                this.usersNumber = 1;
            }
            offset += 2;
        }
    }

    public LMLicense(@NotNull String licenseId, @NotNull LMLicenseType licenseType, Date licenseIssueTime, Date licenseStartTime, Date licenseEndTime, long flags, String productId, String productVersion, String ownerId, String ownerCompany, String ownerName, String ownerEmail) {
        this.licenseFormat = LMLicenseFormat.EXTENDED;
        this.licenseId = licenseId;
        this.licenseType = licenseType;
        this.licenseIssueTime = licenseIssueTime;
        this.licenseStartTime = licenseStartTime;
        this.licenseEndTime = licenseEndTime;
        this.flags = flags;
        this.productId = productId;
        this.productVersion = productVersion;
        this.ownerId = ownerId;
        this.ownerCompany = ownerCompany;
        this.ownerName = ownerName;
        this.ownerEmail = ownerEmail;
        this.yearsNumber = 1;
        this.reserved1 = 0;
        this.usersNumber = 1;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    @Override
    @NotNull
    public LMLicenseFormat getFormat() {
        return this.licenseFormat;
    }

    public void setLicenseFormat(LMLicenseFormat licenseFormat) {
        this.licenseFormat = licenseFormat;
    }

    @NotNull
    public String getLicenseId() {
        return this.licenseId;
    }

    @NotNull
    public LMLicenseType getLicenseType() {
        return this.licenseType;
    }

    @NotNull
    public Date getLicenseIssueTime() {
        return this.licenseIssueTime;
    }

    @NotNull
    public Date getLicenseStartTime() {
        return this.licenseStartTime;
    }

    @Nullable
    public Date getLicenseEndTime() {
        if (this.licenseEndTime == null && this.licenseType == LMLicenseType.ACADEMIC) {
            return new Date(this.licenseStartTime.getTime() + 31536000000L);
        }
        return this.licenseEndTime;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    @NotNull
    public String getProductId() {
        return this.productId;
    }

    @NotNull
    public String getProductVersion() {
        return this.productVersion;
    }

    @NotNull
    public String getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerCompany() {
        return this.ownerCompany;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    @NotNull
    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public byte getYearsNumber() {
        return this.yearsNumber;
    }

    public void setYearsNumber(byte yearsNumber) {
        this.yearsNumber = yearsNumber;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public short getUsersNumber() {
        return this.usersNumber;
    }

    public void setUsersNumber(short usersNumber) {
        this.usersNumber = usersNumber;
    }

    public String getOwnerFull() {
        String licensedTo = this.ownerName;
        if (!CommonUtils.isEmpty((String)this.ownerCompany)) {
            licensedTo = String.valueOf(this.ownerCompany) + " / " + licensedTo;
        }
        return licensedTo;
    }

    @Override
    @NotNull
    public byte[] getData() {
        byte[] data = new byte[this.licenseFormat.getEncryptedLength()];
        int offset = 0;
        data[offset] = this.licenseFormat.getId();
        LMUtils.copyStringBytes(data, ++offset, this.licenseId, 16);
        offset += 16;
        data[offset++] = this.licenseType.getId();
        LMUtils.copyDateBytes(data, offset, this.licenseIssueTime);
        LMUtils.copyDateBytes(data, offset += 8, this.licenseStartTime);
        LMUtils.copyDateBytes(data, offset += 8, this.licenseEndTime);
        System.arraycopy(LMUtils.longToBytes(this.flags), 0, data, offset += 8, 8);
        LMUtils.copyStringBytes(data, offset += 8, this.productId, 16);
        LMUtils.copyStringBytes(data, offset += 16, this.productVersion, 8);
        LMUtils.copyStringBytes(data, offset += 8, this.ownerId, 16);
        LMUtils.copyStringBytes(data, offset += 16, this.ownerCompany, 64);
        offset += 64;
        switch (this.licenseFormat) {
            case STANDARD: {
                LMUtils.copyStringBytes(data, offset, this.ownerName, 64);
                offset += 64;
                break;
            }
            case EXTENDED: {
                LMUtils.copyStringBytes(data, offset, this.ownerName, 32);
                LMUtils.copyStringBytes(data, offset += 32, this.ownerEmail, 48);
                offset += 48;
                data[offset++] = this.yearsNumber;
                data[offset++] = this.reserved1;
                System.arraycopy(LMUtils.shortToBytes(this.usersNumber), 0, data, offset, 2);
                offset += 2;
                break;
            }
        }
        return data;
    }

    public String getDataHash() {
        byte[] data = this.getData();
        return this.makeMD5Digest(data);
    }

    public String getUpdateRequestHash() throws LMException {
        byte[] data = new byte[25];
        LMUtils.copyStringBytes(data, 0, this.licenseId, 16);
        data[16] = this.licenseType.getId();
        long timestampSeconds = (this.licenseIssueTime.getTime() + 999L) / 1000L * 1000L;
        LMUtils.copyDateBytes(data, 17, new Date(timestampSeconds));
        return "1:" + this.makeMD5Digest(data);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private String makeMD5Digest(byte[] data) {
        try {
            md5hash = MessageDigest.getInstance("MD5").digest(data);
            return CommonUtils.toHexString((byte[])md5hash).toLowerCase(Locale.ENGLISH).trim();
        }
        catch (NoSuchAlgorithmException v0) {
            LMLicense.log.severe("No MD5 digest. Use simple sum.");
            sum = 0L;
            var7_4 = data;
            var6_5 = data.length;
            var5_6 = 0;
            ** while (var5_6 < var6_5)
        }
lbl-1000:
        // 1 sources

        {
            b = var7_4[var5_6];
            sum += (long)b;
            ++var5_6;
            continue;
        }
lbl15:
        // 1 sources

        return Long.toHexString(sum);
    }

    public String toString() {
        return "licenseId=" + this.licenseId + "\nlicenseType=" + (Object)((Object)this.licenseType) + "\nlicenseIssueTime=" + this.licenseIssueTime + "\nlicenseStartTime=" + this.licenseStartTime + "\nlicenseEndTime=" + this.licenseEndTime + "\nflags=" + this.flags + "\nproductId=" + this.productId + "\nproductVersion=" + this.productVersion + "\nownerId=" + this.ownerId + "\nownerCompany=" + this.ownerCompany + "\nownerName=" + this.ownerName + "\nownerEmail=" + this.ownerEmail + "\nyearsNumber=" + this.yearsNumber + "\nusersNumber=" + this.usersNumber;
    }

    public boolean isSubscription() {
        return (this.flags & 8L) == 8L;
    }

    public boolean isValidForProduct(LMProduct product) {
        return this.productId.equals(product.getId()) || ArrayUtils.contains((Object[])product.getUmbrellaProducts(), (Object)this.productId);
    }

    public boolean isValidFor(LMProduct product, LMProductRelease productRelease, boolean checkExpired) {
        if (!this.isValidForProduct(product)) {
            return false;
        }
        if (this.isSubscription()) {
            return true;
        }
        if ((this.flags & 0x20L) == 32L && !CommonUtils.equalObjects((Object)this.getProductVersion(), (Object)product.getVersion())) {
            return false;
        }
        if (this.getLicenseType() == LMLicenseType.ULTIMATE) {
            return true;
        }
        if (checkExpired && this.isExpired()) {
            return false;
        }
        return !this.isOutOfSupport(product, productRelease);
    }

    public boolean isExpired() {
        Date curDate = new Date();
        Date licenseEndTime = this.getLicenseEndTime();
        switch (this.getLicenseType()) {
            case TRIAL: 
            case ACADEMIC: {
                if (licenseEndTime != null) break;
                licenseEndTime = new Date(this.licenseStartTime.getTime() + 31536000000L);
            }
        }
        return licenseEndTime != null && licenseEndTime.compareTo(curDate) < 0;
    }

    private boolean isOutOfSupport(LMProduct product, LMProductRelease productRelease) {
        if (this.getLicenseType() == LMLicenseType.TRIAL) {
            return this.isExpired();
        }
        Date releaseDate = productRelease == null ? product.getReleaseDate() : productRelease.getReleaseDate();
        Date licenseEndTime = this.getSupportEndDate();
        return licenseEndTime.compareTo(releaseDate) < 0;
    }

    public LMStatusDetails getLicenseStatus(LMProduct product) {
        if (!this.isValidForProduct(product)) {
            return new LMStatusDetails("Wrong product", "You can't use this license with product '" + product.getName() + "'", false);
        }
        if (this.isSubscription()) {
            if (this.remoteStatus != null) {
                return this.remoteStatus;
            }
            return new LMStatusDetails("Subscription", "Valid subscription", true);
        }
        if ((this.flags & 0x20L) == 32L && !CommonUtils.equalObjects((Object)this.getProductVersion(), (Object)product.getVersion())) {
            return new LMStatusDetails("Only version " + this.getProductVersion() + " supported", "Your license is limited to the version " + product.getName() + " " + this.getProductVersion() + " and can't be used with other produce versions", false);
        }
        if (this.getLicenseType() == LMLicenseType.ULTIMATE) {
            return new LMStatusDetails("Ultimate license", "Ultimate license", true);
        }
        if (this.isExpired()) {
            return new LMStatusDetails("Expired (" + LMUtils.HR_DATE_FORMAT.format(this.getExpireDate()) + ")", "Your license has been expired at " + LMUtils.HR_DATE_FORMAT.format(this.getExpireDate()), false);
        }
        if (this.isOutOfSupport(product, null)) {
            return new LMStatusDetails("Not valid for " + product.getVersion(), "Your license is not valid for " + product.getName() + " " + product.getVersion() + ".\n" + "Product release date (" + LMUtils.HR_DATE_FORMAT.format(product.getReleaseDate()) + ") is later than the license end-of-support date (" + LMUtils.HR_DATE_FORMAT.format(this.getSupportEndDate()) + ").\n" + "You can use earlier versions or upgrade your license.", false);
        }
        if (!this.isValidFor(product, null, false)) {
            return new LMStatusDetails("Invalid license", "Thos license is not applicable", false);
        }
        return new LMStatusDetails("Valid", "Valid license", true);
    }

    public Date getExpireDate() {
        Date licenseEndTime = this.getLicenseEndTime();
        switch (this.getLicenseType()) {
            case TRIAL: 
            case ACADEMIC: {
                if (licenseEndTime != null) break;
                licenseEndTime = new Date(this.licenseStartTime.getTime() + 31536000000L);
            }
        }
        return licenseEndTime;
    }

    @NotNull
    public Date getSupportEndDate() {
        if (this.licenseEndTime != null) {
            return this.licenseEndTime;
        }
        Calendar cl = Calendar.getInstance();
        if (this.licenseStartTime != null) {
            cl.setTime(this.licenseStartTime);
        } else {
            cl.setTime(this.licenseIssueTime);
        }
        byte yearsNumber = this.getYearsNumber();
        if (yearsNumber <= 0) {
            yearsNumber = 1;
        }
        cl.add(1, yearsNumber);
        return cl.getTime();
    }

    public String getLicenseTypeFull() {
        if (this.isSubscription()) {
            return "Subscription";
        }
        return this.licenseType.getDisplayName();
    }

    public LMStatusDetails getRemoteStatus() {
        return this.remoteStatus;
    }

    public void setRemoteStatus(LMStatusDetails remoteStatus) {
        this.remoteStatus = remoteStatus;
    }
}

