/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.part;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.VQBIcon;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.model.VQBJoinType;
import com.dbeaver.ee.vqb.ui.part.QueryJoinEditPolicy;
import java.util.List;
import net.sf.jsqlparser.statement.select.Join;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.jkiss.dbeaver.erd.ui.figures.RoundedLineBorder;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.policy.AssociationBendEditPolicy;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class QueryJoinPart
extends AssociationPart {
    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new AssociationBendEditPolicy());
        if (this.isEditEnabled()) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new QueryJoinEditPolicy());
        }
    }

    protected void setConnectionStyles(PolylineConnection conn) {
        conn.setLineWidth(2);
        ConnectionLocator joinLabelLocator = new ConnectionLocator((Connection)conn, 4);
        Label iconLabel = new Label(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
        conn.add((IFigure)iconLabel, (Object)joinLabelLocator);
        RoundedLineBorder iconBorder = new RoundedLineBorder(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.lines.foreground"), 2, 5);
        iconBorder.setMargin(3);
        iconLabel.setBorder((Border)iconBorder);
        iconLabel.setOpaque(true);
    }

    private DBIcon getJoinIcon() {
        Join join = (Join)this.getAssociation().getUserData();
        if (join != null) {
            return VQBJoinType.getByJoin(join).getIcon();
        }
        return VQBIcon.JOIN_INNER;
    }

    protected void setConnectionToolTip(PolylineConnection conn) {
        Join join = (Join)this.getAssociation().getUserData();
        if (join != null) {
            Label toolTip = new Label(join.toString());
            toolTip.setBorder((Border)new MarginBorder(3));
            toolTip.setIcon(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
            toolTip.setTextPlacement(8);
            conn.setToolTip((IFigure)toolTip);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            VQBEditorPart editorPart = VQBUtils.getQueryBuilderEditor((EditPart)this);
            editorPart.getPresentation().getQueryPanel().editElement("joins", this.getAssociation().getUserData());
        } else {
            super.performRequest(request);
        }
    }

    public void updateJoinType() {
        List children = this.getFigure().getChildren();
        if (children.size() == 1 && children.get(0) instanceof Label) {
            Label iconLabel = (Label)children.get(0);
            iconLabel.setIcon(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
        }
    }
}

