/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.builder;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;

public class VQBQueryInfo {
    private static final Log log = Log.getLog(VQBQueryInfo.class);
    private final DBCExecutionContext executionContext;
    private final SQLQuery query;
    private final Select parsedQuery;
    private List<Expression> excludedWhereConditions = new ArrayList<Expression>();

    public VQBQueryInfo(DBCExecutionContext executionContext, SQLQuery query, Select parsedQuery) {
        this.executionContext = executionContext;
        this.query = query;
        this.parsedQuery = parsedQuery;
    }

    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public SQLQuery getQuery() {
        return this.query;
    }

    public Select getParsedQuery() {
        return this.parsedQuery;
    }

    public PlainSelect getPlainSelect() {
        if (this.parsedQuery != null && this.parsedQuery.getSelectBody() instanceof PlainSelect) {
            return (PlainSelect)this.parsedQuery.getSelectBody();
        }
        return null;
    }

    public boolean isConditionExcluded(Expression expression) {
        return this.excludedWhereConditions.contains(expression);
    }

    public void excludeWhereCondition(Expression expression) {
        this.excludedWhereConditions.add(expression);
    }

    public void refreshStatement(boolean reformat) {
        if (this.parsedQuery != null) {
            String sqlText = this.parsedQuery.toString();
            if (reformat && this.query.getDataSource() != null) {
                sqlText = SQLFormatUtils.formatSQL((DBPDataSource)this.query.getDataSource(), (String)sqlText);
            }
            this.query.setText(sqlText);
        }
    }
}

