/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb;

import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.model.ERDJoin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import org.eclipse.gef.EditPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDContainer;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.ui.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class VQBUtils {
    public static VQBEditorPart getQueryBuilderEditor(EditPart editPart) {
        ERDGraphicalViewer viewer = (ERDGraphicalViewer)editPart.getViewer();
        return (VQBEditorPart)viewer.getEditor();
    }

    public static VQBQueryInfo getQueryInfo(EditPart editPart) {
        return VQBUtils.getQueryBuilderEditor(editPart).getQueryInfo();
    }

    public static EntityDiagram getDiagram(EditPart editPart) {
        ERDGraphicalViewer viewer = (ERDGraphicalViewer)editPart.getViewer();
        return viewer.getEditor().getDiagram();
    }

    public static Expression unwrapExpression(Expression expr) {
        return expr;
    }

    public static void collectNestedConditions(VQBQueryInfo queryInfo, List<Expression> nestedConditions, Expression parentExpr, Expression expr) {
        if ((expr = VQBUtils.unwrapExpression(expr)) instanceof BinaryExpression && expr.getClass() == parentExpr.getClass()) {
            VQBUtils.collectNestedConditions(queryInfo, nestedConditions, expr, ((BinaryExpression)expr).getLeftExpression());
            VQBUtils.collectNestedConditions(queryInfo, nestedConditions, expr, ((BinaryExpression)expr).getRightExpression());
        } else if (!queryInfo.isConditionExcluded(expr)) {
            nestedConditions.add(expr);
        }
    }

    public static boolean isCompoundExpression(Expression expr) {
        return expr instanceof AndExpression || expr instanceof OrExpression || expr instanceof Parenthesis;
    }

    public static Table getTableFromEntity(ERDEntity erdEntity) {
        FromItem fromItem = (FromItem)erdEntity.getUserData();
        return fromItem instanceof Table ? (Table)fromItem : null;
    }

    @NotNull
    public static List<Join> getQueryJoins(PlainSelect plainSelect) {
        ArrayList joins = plainSelect.getJoins();
        if (joins == null) {
            joins = new ArrayList();
            plainSelect.setJoins(joins);
        }
        return joins;
    }

    public static boolean isEntityJoin(Join join, ERDEntity entity) {
        return join.getRightItem() instanceof Table && VQBUtils.equalTables((Table)join.getRightItem(), entity);
    }

    public static boolean equalTables(Table table, ERDEntity erdEntity) {
        if (table == null || erdEntity == null) {
            return table == null && erdEntity == null;
        }
        DBPDataSource dataSource = ((DBSEntity)erdEntity.getObject()).getDataSource();
        String tableName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)table.getName());
        if (table.getAlias() != null && !CommonUtils.isEmpty((String)erdEntity.getAlias())) {
            return CommonUtils.equalObjects((Object)tableName, (Object)erdEntity.getName()) && CommonUtils.equalObjects((Object)table.getAlias().getName(), (Object)erdEntity.getAlias());
        }
        DBSEntity entity = (DBSEntity)erdEntity.getObject();
        DBSCatalog catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)entity);
        DBSSchema schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)entity);
        if (catalog != null && table.getDatabase() != null && !CommonUtils.isEmpty((String)table.getDatabase().getDatabaseName()) && !CommonUtils.equalObjects((Object)catalog.getName(), (Object)DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)table.getDatabase().getDatabaseName()))) {
            return false;
        }
        if (schema != null && table.getSchemaName() != null && !CommonUtils.equalObjects((Object)schema.getName(), (Object)table.getSchemaName())) {
            return false;
        }
        String a1 = table.getAlias() == null ? null : table.getAlias().getName();
        String a2 = erdEntity.getAlias();
        return CommonUtils.equalObjects((Object)tableName, (Object)entity.getName()) && a1 == null && a2 == null || CommonUtils.equalObjects((Object)tableName, (Object)a2) || CommonUtils.equalObjects((Object)entity.getName(), (Object)a1);
    }

    public static boolean equalTables(Table t1, Table t2) {
        String a2;
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        if (t1.getAlias() != null && t2.getAlias() != null) {
            return CommonUtils.equalObjects((Object)t1.getAlias().getName(), (Object)t2.getAlias().getName());
        }
        if (!CommonUtils.equalObjects((Object)(t1.getDatabase() == null ? null : t1.getDatabase().getDatabaseName()), t2.getDatabase() == null ? null : t2.getDatabase().getDatabaseName())) {
            return false;
        }
        if (!CommonUtils.equalObjects((Object)t1.getSchemaName(), (Object)t2.getSchemaName())) {
            return false;
        }
        String a1 = t1.getAlias() == null ? null : t1.getAlias().getName();
        String string = a2 = t2.getAlias() == null ? null : t2.getAlias().getName();
        return CommonUtils.equalObjects((Object)t1.getName(), (Object)t2.getName()) || CommonUtils.equalObjects((Object)t1.getName(), (Object)a2) || CommonUtils.equalObjects((Object)t2.getName(), (Object)a1);
    }

    public static List<SelectItem> getOrCreateSelectItems(PlainSelect plainSelect) {
        ArrayList selectItems = plainSelect.getSelectItems();
        if (selectItems == null) {
            selectItems = new ArrayList();
            plainSelect.setSelectItems(selectItems);
        }
        return selectItems;
    }

    public static void handleEntityChange(ERDContainer diagram, VQBQueryInfo queryInfo, ERDEntity entity, boolean remove) {
        PlainSelect plainSelect = queryInfo.getPlainSelect();
        if (plainSelect != null) {
            if (!remove) {
                List<SelectItem> selectItems;
                boolean isMainTable;
                boolean bl = isMainTable = plainSelect.getFromItem() instanceof Table && VQBUtils.equalTables((Table)plainSelect.getFromItem(), entity);
                if (isMainTable && (selectItems = VQBUtils.getOrCreateSelectItems(plainSelect)).isEmpty()) {
                    selectItems.add((SelectItem)new AllColumns());
                }
                if (!isMainTable && CommonUtils.isEmpty((Collection)entity.getReferences())) {
                    List<Join> joins = VQBUtils.getQueryJoins(plainSelect);
                    Join simpleJoin = new Join();
                    Table tableFromEntity = VQBUtils.getTableFromEntity(entity);
                    simpleJoin.setRightItem((FromItem)tableFromEntity);
                    int indexToInsertInJoinList = -1;
                    if (joins.size() > 1) {
                        int i = 0;
                        while (i <= joins.size() - 1) {
                            Join listJoin = joins.get(i);
                            Expression onExpression = listJoin.getOnExpression();
                            if (onExpression != null) {
                                Expression leftExpression;
                                Table leftTable = null;
                                if (onExpression instanceof EqualsTo && (leftExpression = ((EqualsTo)onExpression).getLeftExpression()) instanceof Column) {
                                    leftTable = ((Column)leftExpression).getTable();
                                }
                                if (leftTable != null && VQBUtils.equalTables(leftTable, tableFromEntity)) {
                                    indexToInsertInJoinList = i;
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    if (indexToInsertInJoinList != -1) {
                        joins.add(indexToInsertInJoinList, simpleJoin);
                    } else {
                        joins.add(simpleJoin);
                    }
                }
            } else {
                VQBUtils.removeTableReferences(diagram, plainSelect, entity);
            }
        }
    }

    public static void updateTableAlias(VQBQueryInfo queryInfo, final Table changingTable, final Alias alias) {
        queryInfo.getParsedQuery().getSelectBody().accept((SelectVisitor)new SelectVisitorAdapter(){

            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getFromItem() != null) {
                    plainSelect.getFromItem().accept((FromItemVisitor)new FromItemVisitorAdapter(){

                        public void visit(Table table) {
                            if (table != changingTable && VQBUtils.equalTables(table, changingTable)) {
                                table.setAlias(alias);
                            }
                        }
                    });
                }
                if (plainSelect.getJoins() != null) {
                    for (Join join : plainSelect.getJoins()) {
                        if (join.getOnExpression() == null) continue;
                        VQBUtils.updateTableAlias(join.getOnExpression(), changingTable, alias);
                    }
                }
                if (plainSelect.getSelectItems() != null) {
                    for (SelectItem item : plainSelect.getSelectItems()) {
                        if (!(item instanceof SelectExpressionItem)) continue;
                        VQBUtils.updateTableAlias(((SelectExpressionItem)item).getExpression(), changingTable, alias);
                    }
                }
                if (plainSelect.getWhere() != null) {
                    VQBUtils.updateTableAlias(plainSelect.getWhere(), changingTable, alias);
                }
                if (plainSelect.getHaving() != null) {
                    VQBUtils.updateTableAlias(plainSelect.getHaving(), changingTable, alias);
                }
                if (plainSelect.getGroupBy() != null) {
                    for (SelectItem item : CommonUtils.safeList((List)plainSelect.getGroupBy().getGroupByExpressions())) {
                        VQBUtils.updateTableAlias((Expression)item, changingTable, alias);
                    }
                }
                if (plainSelect.getOrderByElements() != null) {
                    for (SelectItem item : plainSelect.getOrderByElements()) {
                        if (item.getExpression() == null) continue;
                        VQBUtils.updateTableAlias(item.getExpression(), changingTable, alias);
                    }
                }
            }
        });
        changingTable.setAlias(alias);
    }

    public static void updateTableAlias(Expression expression, final Table changedTable, Alias alias) {
        expression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visit(Column column) {
                if (column.getTable() == null || column.getTable() != changedTable && VQBUtils.equalTables(column.getTable(), changedTable)) {
                    column.setTable(changedTable);
                }
            }
        });
    }

    public static void removeTableReferences(ERDContainer diagram, PlainSelect plainSelect, ERDEntity entity) {
        List orderByElements;
        List groupByRefs;
        Iterator iter;
        List joins = plainSelect.getJoins();
        if (joins != null) {
            iter = joins.iterator();
            while (iter.hasNext()) {
                Join join = (Join)iter.next();
                if (VQBUtils.isEntityJoin(join, entity)) {
                    iter.remove();
                    continue;
                }
                join.setOnExpression(VQBUtils.removeTableReferences(join.getOnExpression(), entity));
            }
        }
        if (plainSelect.getFromItem() instanceof Table && VQBUtils.equalTables((Table)plainSelect.getFromItem(), entity)) {
            if (CommonUtils.isEmpty((Collection)joins)) {
                plainSelect.setFromItem(null);
            } else {
                Join firstJoin = (Join)joins.remove(0);
                plainSelect.setFromItem(firstJoin.getRightItem());
                for (ERDEntity e : diagram.getEntities()) {
                    if (e.getUserData() != firstJoin.getRightItem()) continue;
                    e.setPrimary(true);
                    e.firePropertyChange("NAME", null, (Object)e.getName());
                }
            }
        }
        if (plainSelect.getSelectItems() != null) {
            iter = plainSelect.getSelectItems().iterator();
            while (iter.hasNext()) {
                SelectItem item = (SelectItem)iter.next();
                if (!(item instanceof SelectExpressionItem)) continue;
                Expression res = VQBUtils.removeTableReferences(((SelectExpressionItem)item).getExpression(), entity);
                if (res == null) {
                    iter.remove();
                    continue;
                }
                ((SelectExpressionItem)item).setExpression(res);
            }
            if (CommonUtils.isEmpty((Collection)plainSelect.getSelectItems()) && plainSelect.getFromItem() != null) {
                plainSelect.addSelectItems(new SelectItem[]{new AllColumns()});
            }
            if (plainSelect.getFromItem() == null && plainSelect.getSelectItems().size() == 1 && plainSelect.getSelectItems().get(0) instanceof AllColumns) {
                plainSelect.setSelectItems(null);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.setWhere(VQBUtils.removeTableReferences(plainSelect.getWhere(), entity));
        }
        if (plainSelect.getHaving() != null) {
            plainSelect.setHaving(VQBUtils.removeTableReferences(plainSelect.getHaving(), entity));
        }
        if (plainSelect.getGroupBy() != null && (groupByRefs = plainSelect.getGroupBy().getGroupByExpressions()) != null) {
            int i = 0;
            while (i < groupByRefs.size()) {
                Expression expr = VQBUtils.removeTableReferences((Expression)groupByRefs.get(i), entity);
                if (expr == null) {
                    groupByRefs.remove(i);
                    continue;
                }
                groupByRefs.set(i, expr);
                ++i;
            }
        }
        if ((orderByElements = plainSelect.getOrderByElements()) != null) {
            int i = 0;
            while (i < orderByElements.size()) {
                OrderByElement obe = (OrderByElement)orderByElements.get(i);
                Expression expr = VQBUtils.removeTableReferences(obe.getExpression(), entity);
                if (expr == null) {
                    orderByElements.remove(i);
                    continue;
                }
                obe.setExpression(expr);
                ++i;
            }
        }
    }

    public static Expression removeTableReferences(Expression expr, ERDEntity entity) {
        ComparisonOperator cmp;
        if (expr instanceof ComparisonOperator && ((cmp = (ComparisonOperator)expr).getLeftExpression() instanceof Column && VQBUtils.equalTables(((Column)cmp.getLeftExpression()).getTable(), entity) || cmp.getRightExpression() instanceof Column && VQBUtils.equalTables(((Column)cmp.getRightExpression()).getTable(), entity))) {
            return null;
        }
        if (expr instanceof BinaryExpression) {
            Expression leftFiltered = VQBUtils.removeTableReferences(((BinaryExpression)expr).getLeftExpression(), entity);
            Expression rightFiltered = VQBUtils.removeTableReferences(((BinaryExpression)expr).getRightExpression(), entity);
            if (leftFiltered == null && rightFiltered == null) {
                return null;
            }
            if (leftFiltered == null) {
                return rightFiltered;
            }
            if (rightFiltered == null) {
                return leftFiltered;
            }
        }
        if (expr instanceof Column) {
            boolean isAliasAlways = VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.add.aliases.always");
            Column column = (Column)expr;
            if (VQBUtils.equalTables(column.getTable(), entity) || !isAliasAlways && column.getTable() == null && VQBUtils.entityHasColumn(entity, column)) {
                return null;
            }
        }
        return expr;
    }

    private static boolean entityHasColumn(ERDEntity entity, Column column) {
        List attributes = entity.getAttributes();
        String columnName = column.getColumnName();
        if (columnName != null) {
            for (ERDEntityAttribute attr : attributes) {
                if (!attr.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Join findEntityJoin(EntityDiagram diagram, PlainSelect plainSelect, ERDEntity rightEntity, ERDEntity leftEntity) {
        if (plainSelect.getJoins() == null) {
            return null;
        }
        for (Join join : plainSelect.getJoins()) {
            boolean matchesRightEntity;
            if (!(join.getRightItem() instanceof Table)) continue;
            boolean bl = matchesRightEntity = rightEntity != null && VQBUtils.equalTables((Table)join.getRightItem(), rightEntity);
            if (!matchesRightEntity && (leftEntity == null || !VQBUtils.equalTables((Table)join.getRightItem(), leftEntity))) continue;
            if (join.getOnExpression() == null) {
                return join;
            }
            if (!(matchesRightEntity ? VQBUtils.containsTableReferences(join.getOnExpression(), leftEntity) : VQBUtils.containsTableReferences(join.getOnExpression(), rightEntity))) continue;
            return join;
        }
        return null;
    }

    public static boolean containsTableReferences(Expression expr, ERDEntity entity) {
        ComparisonOperator cmp;
        return expr instanceof ComparisonOperator ? (cmp = (ComparisonOperator)expr).getLeftExpression() instanceof Column && VQBUtils.equalTables(((Column)cmp.getLeftExpression()).getTable(), entity) || cmp.getRightExpression() instanceof Column && VQBUtils.equalTables(((Column)cmp.getRightExpression()).getTable(), entity) : expr instanceof BinaryExpression && (VQBUtils.containsTableReferences(((BinaryExpression)expr).getLeftExpression(), entity) || VQBUtils.containsTableReferences(((BinaryExpression)expr).getRightExpression(), entity));
    }

    public static ERDJoin findERDJoin(EntityDiagram diagram, Join join) {
        for (ERDEntity entity : diagram.getEntities()) {
            for (ERDAssociation a : CommonUtils.safeList((List)entity.getAssociations())) {
                if (a.getUserData() != join || !(a instanceof ERDJoin)) continue;
                return (ERDJoin)a;
            }
            for (ERDAssociation r : CommonUtils.safeList((List)entity.getReferences())) {
                if (r.getUserData() != join || !(r instanceof ERDJoin)) continue;
                return (ERDJoin)r;
            }
        }
        return null;
    }

    public static List<String> getAttributeNames(EntityDiagram diagram, boolean addStars) {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (ERDEntity entity : diagram.getEntities()) {
            String entityAlias;
            String string = entityAlias = !CommonUtils.isEmpty((String)entity.getAlias()) ? entity.getAlias() : DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)entity.getObject()));
            if (addStars) {
                attrNames.add(String.valueOf(entityAlias) + ".*");
            }
            for (ERDEntityAttribute attr : entity.getAttributes()) {
                attrNames.add(String.valueOf(entityAlias) + "." + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)attr.getObject())));
            }
        }
        return attrNames;
    }

    public static Statement createEmptySelectStatement() {
        Select select = new Select();
        select.setSelectBody((SelectBody)new PlainSelect());
        Select statement = select;
        return statement;
    }

    public static void replaceCompoundWithSingle(PlainSelect plainSelect, final BinaryExpression compound, final Expression replaceWith) {
        if (plainSelect.getWhere() == compound) {
            plainSelect.setWhere(replaceWith);
        } else {
            plainSelect.getWhere().accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                public void visitBinaryExpression(BinaryExpression value) {
                    if (value.getRightExpression() == compound) {
                        value.setRightExpression(replaceWith);
                    } else if (value.getLeftExpression() == compound) {
                        value.setLeftExpression(replaceWith);
                    } else {
                        super.visitBinaryExpression(value);
                    }
                }
            });
        }
    }

    public static Expression makeColumnExpression(ERDEntity entity, ERDEntityAttribute attribute) {
        Column column = new Column(DBUtils.getQuotedIdentifier((DBPNamedObject)attribute));
        Table table = new Table(DBUtils.getQuotedIdentifier((DBPNamedObject)entity));
        if (!CommonUtils.isEmpty((String)entity.getAlias())) {
            table.setAlias(new Alias(entity.getAlias()));
        }
        if (((DBSEntity)entity.getObject()).getParentObject() instanceof DBSSchema) {
            table.setSchemaName(DBUtils.getQuotedIdentifier((DBSObject)((DBSEntity)entity.getObject()).getParentObject()));
        }
        column.setTable(table);
        return column;
    }

    public static String generateEntityAlias(ERDDiagram diagram, List<ERDEntity> otherEntities, DBSEntity entity, SQLSyntaxManager syntaxManager) {
        String entityAlias = SQLUtils.generateEntityAlias((DBSEntity)entity, s -> VQBUtils.aliasExist(diagram, otherEntities, s));
        DBPIdentifierCase keywordCase = syntaxManager.getKeywordCase();
        return keywordCase.transform(entityAlias);
    }

    public static boolean aliasExist(ERDDiagram diagram, List<ERDEntity> otherEntities, String alias) {
        for (ERDEntity entity : diagram.getEntities()) {
            if (!alias.equalsIgnoreCase(entity.getAlias()) && !alias.equalsIgnoreCase(entity.getName())) continue;
            return true;
        }
        for (ERDEntity entity : otherEntities) {
            if (!alias.equalsIgnoreCase(entity.getAlias()) && !alias.equalsIgnoreCase(entity.getName())) continue;
            return true;
        }
        return false;
    }

    public static void removeExpressionFromGrouping(PlainSelect pSelect, SelectExpressionItem selectExpressionItem, GroupByElement groupBy) {
        Expression expression = selectExpressionItem.getExpression();
        List groupByExpressions = groupBy.getGroupByExpressions();
        List selectItems = pSelect.getSelectItems();
        List<Object> newGroupingList = new ArrayList();
        boolean tableWithAlis = true;
        if (expression instanceof Column && ((Column)expression).getTable() == null) {
            Column column = (Column)expression;
            tableWithAlis = false;
            newGroupingList = groupByExpressions.stream().filter(expr -> !column.getColumnName().equals(((Column)expr).getColumnName())).collect(Collectors.toList());
        }
        if (expression instanceof Function) {
            Function function = (Function)expression;
            List expressions = function.getParameters().getExpressions();
            expression = (Expression)expressions.get(0);
        }
        Expression finalExpression = expression;
        if (tableWithAlis) {
            newGroupingList = groupByExpressions.stream().filter(expr -> !finalExpression.toString().equals(expr.toString())).collect(Collectors.toList());
        }
        if (!CommonUtils.isEmpty(newGroupingList)) {
            VQBUtils.addDefaultAggregateFunction(selectExpressionItem);
            groupBy.setGroupByExpressions(newGroupingList);
        } else {
            pSelect.setGroupByElement(null);
            List<SelectItem> newSelectItems = VQBUtils.replaceAllFunctionsInPlainSelect(selectItems);
            pSelect.setSelectItems(newSelectItems);
        }
    }

    public static void addDefaultAggregateFunction(SelectExpressionItem selectExpressionItem) {
        Expression expression = selectExpressionItem.getExpression();
        Function function = new Function();
        function.setName("COUNT");
        ExpressionList exprList = new ExpressionList();
        exprList.setExpressions(Collections.singletonList(expression));
        function.setParameters(exprList);
        selectExpressionItem.setExpression((Expression)function);
    }

    private static List<SelectItem> replaceAllFunctionsInPlainSelect(List<SelectItem> selectItems) {
        ArrayList<SelectItem> newSelectItemsList = new ArrayList<SelectItem>();
        for (SelectItem sItem : selectItems) {
            if (!(sItem instanceof SelectExpressionItem)) continue;
            Expression selectExpression = ((SelectExpressionItem)sItem).getExpression();
            if (selectExpression instanceof Function) {
                Function selectFunction = (Function)selectExpression;
                if (selectFunction.isAllColumns()) continue;
                Expression functionExpression = (Expression)selectFunction.getParameters().getExpressions().get(0);
                SelectExpressionItem newSelectExpressionItem = new SelectExpressionItem(functionExpression);
                newSelectItemsList.add((SelectItem)newSelectExpressionItem);
                continue;
            }
            newSelectItemsList.add(sItem);
        }
        return newSelectItemsList;
    }
}

