/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.analytics.AnalyticsParams;
import com.couchbase.client.java.analytics.ParameterizedAnalyticsQuery;
import com.couchbase.client.java.analytics.SimpleAnalyticsQuery;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import java.io.Serializable;

@InterfaceStability.Committed
@InterfaceAudience.Public
public abstract class AnalyticsQuery
implements Serializable {
    private static final long serialVersionUID = 3758113456237959730L;

    public abstract String statement();

    public abstract AnalyticsParams params();

    public abstract JsonObject query();

    public static SimpleAnalyticsQuery simple(String statement) {
        return AnalyticsQuery.simple(statement, null);
    }

    public static SimpleAnalyticsQuery simple(String statement, AnalyticsParams params) {
        return new SimpleAnalyticsQuery(statement, params);
    }

    public static ParameterizedAnalyticsQuery parameterized(String statement, JsonArray positionalParams) {
        return new ParameterizedAnalyticsQuery(statement, positionalParams, null, null);
    }

    public static ParameterizedAnalyticsQuery parameterized(String statement, JsonArray positionalParams, AnalyticsParams params) {
        return new ParameterizedAnalyticsQuery(statement, positionalParams, null, params);
    }

    public static ParameterizedAnalyticsQuery parameterized(String statement, JsonObject namedParams) {
        return new ParameterizedAnalyticsQuery(statement, null, namedParams, null);
    }

    public static ParameterizedAnalyticsQuery parameterized(String statement, JsonObject namedParams, AnalyticsParams params) {
        return new ParameterizedAnalyticsQuery(statement, null, namedParams, params);
    }
}

