/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class DynamoDbEndpointDiscoveryCacheLoader
implements EndpointDiscoveryCacheLoader {
    private final DynamoDbClient client;

    private DynamoDbEndpointDiscoveryCacheLoader(DynamoDbClient client) {
        this.client = client;
    }

    public static DynamoDbEndpointDiscoveryCacheLoader create(DynamoDbClient client) {
        return new DynamoDbEndpointDiscoveryCacheLoader(client);
    }

    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest endpointDiscoveryRequest) {
        return CompletableFuture.supplyAsync(() -> {
            DescribeEndpointsResponse response = this.client.describeEndpoints((DescribeEndpointsRequest)((Object)((Object)DescribeEndpointsRequest.builder().build())));
            List<Endpoint> endpoints = response.endpoints();
            Validate.notEmpty(endpoints, (String)"Endpoints returned by service for endpoint discovery must not be empty.", (Object[])new Object[0]);
            Endpoint endpoint = endpoints.get(0);
            return EndpointDiscoveryEndpoint.builder().endpoint(this.toUri(endpoint.address(), endpointDiscoveryRequest.defaultEndpoint())).expirationTime(Instant.now().plus((long)endpoint.cachePeriodInMinutes(), ChronoUnit.MINUTES)).build();
        });
    }
}

