/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sso.SsoAsyncClient;
import software.amazon.awssdk.services.sso.model.ListAccountRolesRequest;
import software.amazon.awssdk.services.sso.model.ListAccountRolesResponse;
import software.amazon.awssdk.services.sso.model.RoleInfo;

public class ListAccountRolesPublisher
implements SdkPublisher<ListAccountRolesResponse> {
    private final SsoAsyncClient client;
    private final ListAccountRolesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountRolesPublisher(SsoAsyncClient client, ListAccountRolesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountRolesPublisher(SsoAsyncClient client, ListAccountRolesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountRolesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountRolesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RoleInfo> roleList() {
        Function<ListAccountRolesResponse, Iterator> getIterator = response -> {
            if (response != null && response.roleList() != null) {
                return response.roleList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountRolesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountRolesResponseFetcher
    implements AsyncPageFetcher<ListAccountRolesResponse> {
        private ListAccountRolesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountRolesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountRolesResponse> nextPage(ListAccountRolesResponse previousPage) {
            if (previousPage == null) {
                return ListAccountRolesPublisher.this.client.listAccountRoles(ListAccountRolesPublisher.this.firstRequest);
            }
            return ListAccountRolesPublisher.this.client.listAccountRoles((ListAccountRolesRequest)((Object)ListAccountRolesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

