/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.ui.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.netezza.ui.Main;
import org.netezza.ui.UIConstants;
import org.netezza.ui.cli.CLIMain;

public abstract class Command
implements UIConstants {
    protected static final int LENGTH = 25;
    protected static final int SEPARATOR_LENGTH = 80;
    public static final int HELP_ITEM_LENGTH = 15;
    public static final int HELP_DESC_LENGTH = 35;
    protected BufferedReader commandLineReader;
    private List parameters = new ArrayList();
    private final String NAME;

    public Command(String name) {
        this.NAME = name == null || name.trim().length() == 0 ? "" : name.toUpperCase();
        this.commandLineReader = new BufferedReader(new InputStreamReader(System.in));
    }

    protected void println(Object[] list) {
        this.print(list);
        this.nextLine();
    }

    protected void print(Object[] list) {
        for (int i = 0; i < list.length; ++i) {
            this.print(list[i].toString() + (i == list.length - 1 ? "" : ","));
        }
    }

    protected void print(String value) {
        CLIMain.print(value);
    }

    protected void println(String value) {
        CLIMain.println(value);
    }

    public void addParameter(String parameter) {
        this.parameters.add(parameter);
    }

    public void execute() {
        this.nextLine();
        this.println(this.NAME);
        this.nextLine();
        this.start();
        this.nextLine();
    }

    protected void printHeader(String header) {
        this.nextLine();
        this.println(header.toUpperCase() + ":");
        this.nextLine();
    }

    protected String getOption(int i) {
        if (i >= this.parameters.size()) {
            return null;
        }
        return (String)this.parameters.get(i);
    }

    public void prompt(String prompt) {
        this.print(prompt + ">");
    }

    public void prompt() {
        this.prompt("");
    }

    public void nextLine() {
        CLIMain.nextLine();
    }

    public void printError(String error) {
        CLIMain.printError(error);
    }

    public String ask(String question, String[] possibleAnswers) {
        BufferedReader bufferedReader = this.commandLineReader;
        synchronized (bufferedReader) {
            String answer = null;
            block5: while (true) {
                int i;
                this.print(">>> " + question + "  (");
                for (i = 0; i < possibleAnswers.length; ++i) {
                    this.print(possibleAnswers[i] + (i == possibleAnswers.length - 1 ? "" : "|"));
                }
                this.print(")  ");
                try {
                    answer = this.commandLineReader.readLine().trim();
                }
                catch (IOException e) {
                    Main.exit(e.getMessage());
                }
                i = 0;
                while (true) {
                    if (i >= possibleAnswers.length) continue block5;
                    if (possibleAnswers[i].equalsIgnoreCase(answer)) {
                        return answer;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String header) {
        BufferedReader bufferedReader = this.commandLineReader;
        synchronized (bufferedReader) {
            this.prompt(header);
            try {
                int readValue;
                StringBuilder value = new StringBuilder();
                while ((readValue = this.commandLineReader.read()) != 10) {
                    if (readValue == 65485) {
                        Main.exit();
                    }
                    value.append((char)readValue);
                }
                return value.toString().trim();
            }
            catch (IOException e) {
                Main.exit();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        BufferedReader bufferedReader = this.commandLineReader;
        synchronized (bufferedReader) {
            PasswordThread thread = new PasswordThread();
            thread.start();
            String password = this.getValue("Password");
            thread.stop = true;
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return password;
        }
    }

    protected void printSuccess(String message) {
        CLIMain.printSuccess(message);
    }

    protected int numberOfParameters() {
        return this.parameters.size();
    }

    public abstract void help();

    protected abstract void start();

    protected class PasswordThread
    extends Thread {
        boolean stop;

        protected PasswordThread() {
        }

        @Override
        public void run() {
            System.out.print(" ");
            while (!this.stop) {
                System.out.print("\b ");
            }
            System.out.print("\b");
        }
    }
}

