/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.ui.cli;

import java.sql.SQLException;
import org.netezza.Driver;
import org.netezza.ui.Main;
import org.netezza.ui.UIConstants;
import org.netezza.ui.cli.Command;
import org.netezza.ui.cli.ConfigureDsnCommand;
import org.netezza.ui.cli.HelpCommand;
import org.netezza.ui.cli.TestConnectionCommand;

public class CLIMain
implements UIConstants {
    public void start(String[] args) throws SQLException {
        String _command = args[0];
        Command command = this.getCommand(_command);
        if (command == null) {
            System.out.println("Invalid command '" + _command + "'.");
            new HelpCommand().help();
            Main.exit();
        }
        for (int i = 1; i < args.length; ++i) {
            command.addParameter(args[i]);
        }
        command.execute();
    }

    public static void print(String message) {
        System.out.print(message == null ? "" : message);
    }

    public static void println(String message) {
        System.out.println(message == null ? "" : message);
    }

    public static void printError(String error) {
        CLIMain.nextLine();
        CLIMain.println("Error:" + (error == null ? "" : error));
        CLIMain.nextLine();
    }

    public static void printSuccess(String message) {
        CLIMain.println("Success:" + message == null ? "" : message);
    }

    public static void nextLine() {
        System.out.println();
    }

    private Command getCommand(String commandName) {
        if (commandName.equals("--test") || commandName.equals("-t")) {
            return new TestConnectionCommand();
        }
        if (commandName.equals("--conf") || commandName.equals("-c")) {
            return new ConfigureDsnCommand();
        }
        if (commandName.equals("--help")) {
            return new HelpCommand();
        }
        if (commandName.equals("--version") || commandName.equals("-v")) {
            return new VersionCommand();
        }
        return null;
    }

    static class VersionCommand
    extends Command {
        public VersionCommand() {
            super("");
        }

        @Override
        public void help() {
            this.println("DESCRIPTION:\n\tDisplays the version of the JDBC driver.\n\nUSAGE: \n\t[-v | --version]\n\n");
        }

        @Override
        protected void start() {
            this.println(Driver.getVersion());
        }
    }
}

