/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql.query;

import java.util.ArrayList;
import org.netezza.error.NzSQLException;
import org.netezza.internal.NzPreparedQuery;
import org.netezza.internal.NzQuery;
import org.netezza.internal.ParseException;
import org.netezza.sql.NzConnection;
import org.netezza.sql.query.parser.CallableQueryParser;

public class NzCallableQuery
extends NzPreparedQuery {
    protected final StringBuilder callableQueryString;
    protected int indexOfFirstOpenBrace;
    protected int indexOfLastCloseBrace;
    private boolean isCallableQuery;
    protected final Param param;
    protected NzConnection connection;

    public NzCallableQuery(NzConnection connection, String query) {
        super(query);
        this.connection = connection;
        this.callableQueryString = new StringBuilder();
        this.param = new Param();
        this.indexOfFirstOpenBrace = query.indexOf(123);
        this.indexOfLastCloseBrace = query.lastIndexOf(125);
    }

    @Override
    public NzQuery parse() throws ParseException {
        String method = "parse";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.query == null) {
            ParseException ex = new ParseException("Query can not be NULL");
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        if (!this.parsed) {
            this.connection.LOGGER.info(this.getClass(), method, "Parsing procedure call.....");
            CallableQueryParser callableQueryParser = new CallableQueryParser(this.connection, this);
            ParseResult result = callableQueryParser.validate();
            switch (result) {
                case INVALID_PROCEDURE: {
                    ParseException ex = new ParseException("Invalid procedure call syntax");
                    this.connection.LOGGER.fatal(this.getClass(), method, ex);
                    throw ex;
                }
                case NOT_A_PROCEDURE: {
                    NzQuery query = super.parse();
                    for (int i = 1; i <= this.params.length; ++i) {
                        this.param.inParam.inParamIndex.add(i);
                    }
                    return query;
                }
                case PROCEDURE_CALL: {
                    callableQueryParser.parse();
                    this.type = NzQuery.QueryType.OTHER;
                    this.isCallableQuery = true;
                }
            }
            this.parsed = true;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
        return this;
    }

    @Override
    public String toNativeString() throws NzSQLException {
        String method = "toNativeString";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.param.outParam.resParamIndex.size() < 1 && this.param.outParam.outParamIndex.size() < 1) {
            return super.toNativeString();
        }
        StringBuilder buffer = new StringBuilder();
        int length = this.nativeQueryTokens.size();
        int paramIdx = this.param.outParam.resParamIndex.size() < 1 ? 1 : 2;
        int i = 0;
        while (i < length) {
            buffer.append((String)this.nativeQueryTokens.get(i));
            if (paramIdx <= this.numberOfParams && !this.param.outParam.outParamIndex.contains(paramIdx)) {
                if (this.params[paramIdx - 1] != null) {
                    buffer.append(this.params[paramIdx - 1]);
                } else {
                    NzSQLException ex = new NzSQLException("netezza.prep.param", "HY010", 11410, new Integer(i + 2));
                    this.connection.LOGGER.fatal(this.getClass(), method, ex);
                    throw ex;
                }
            }
            ++i;
            ++paramIdx;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
        return buffer.toString();
    }

    public boolean isCallableQuery() {
        return this.isCallableQuery;
    }

    public StringBuilder getCallableQueryString() {
        return this.callableQueryString;
    }

    public int getIndexOfFirstOpenBrace() {
        return this.indexOfFirstOpenBrace;
    }

    public int getIndexOfLastCloseBrace() {
        return this.indexOfLastCloseBrace;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean shouldAddZero() {
        return this.shouldAddZero;
    }

    public void update(StringBuilder token, StringBuilder cToken) {
        if (token.length() > 0) {
            this.nativeQueryTokens.add(token.toString());
            this.callableQueryString.append((CharSequence)cToken);
        }
    }

    public Param getParam() {
        return this.param;
    }

    static /* synthetic */ String[] access$102(NzCallableQuery x0, String[] x1) {
        x0.params = x1;
        return x1;
    }

    public static enum ParseResult {
        NOT_A_PROCEDURE,
        INVALID_PROCEDURE,
        PROCEDURE_CALL;

    }

    public class OutParam {
        private ArrayList<Integer> resParamIndex = new ArrayList();
        private ArrayList<Integer> outParamIndex = new ArrayList();
        private int numberOfResParams;

        OutParam() {
        }

        public void update(int paramIndex) {
            this.resParamIndex.add(paramIndex);
            ++this.numberOfResParams;
        }

        public ArrayList<Integer> getOutParamIndex() {
            return this.outParamIndex;
        }

        public int getNumberOfResParams() {
            return this.numberOfResParams;
        }

        public ArrayList<Integer> getResParamIndex() {
            return this.resParamIndex;
        }
    }

    public class InParam {
        private ArrayList<Integer> inParamIndex = new ArrayList();

        InParam() {
        }

        public ArrayList<Integer> getInParamIndex() {
            return this.inParamIndex;
        }
    }

    public class Param {
        private final OutParam outParam;
        private final InParam inParam;

        public Param() {
            this.outParam = new OutParam();
            this.inParam = new InParam();
        }

        public OutParam getOutParam() {
            return this.outParam;
        }

        public InParam getInParam() {
            return this.inParam;
        }

        public void update(int paramIndex) {
            NzCallableQuery.this.numberOfParams = paramIndex;
            NzCallableQuery.access$102(NzCallableQuery.this, new String[NzCallableQuery.this.numberOfParams]);
        }
    }
}

