/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.logging;

import java.io.File;
import java.sql.Timestamp;
import org.netezza.logging.LogLevel;
import org.netezza.logging.Logger;

abstract class BaseLogger
implements Logger {
    protected final LogLevel level;
    protected String fileName;
    private static String defaultLogDirPath = null;

    protected BaseLogger(LogLevel level, String logDirPath) {
        this.level = level == null ? LogLevel.getDefault() : level;
        this.generateFileName(logDirPath);
        this.init();
    }

    protected void generateFileName(String logDirPath) {
        if (logDirPath == null || logDirPath.trim().length() == 0) {
            logDirPath = defaultLogDirPath;
        } else {
            File file = new File(logDirPath);
            if (file.exists()) {
                logDirPath = file.isDirectory() ? file.getAbsolutePath() : defaultLogDirPath;
            } else {
                try {
                    logDirPath = file.mkdir() ? file.getAbsolutePath() : defaultLogDirPath;
                }
                catch (Exception e) {
                    logDirPath = defaultLogDirPath;
                }
            }
        }
        String ts = new Timestamp(System.currentTimeMillis()).toString();
        ts = ts.replaceAll(":", "-").replaceAll(" ", "_");
        String name = "nzjdbc_" + ts + "." + this.getExtension();
        this.fileName = logDirPath + FILE_SEPARATOR + name;
    }

    protected String timeStamp() {
        String timeString = new Timestamp(System.currentTimeMillis()).toString();
        return timeString.substring(0, timeString.lastIndexOf(46));
    }

    protected String getParameterString(Object ... params) {
        if (params != null && params.length > 0) {
            if (params == null || params.length == 0) {
                return "[]";
            }
            StringBuffer buffer = new StringBuffer("[ ");
            for (int i = 0; i < params.length; ++i) {
                buffer.append(params[i] + " ");
            }
            buffer.append("]");
            return buffer.toString();
        }
        return "";
    }

    protected abstract String getExtension();

    static {
        defaultLogDirPath = OS.startsWith("windows") ? "c:" : "/tmp";
    }
}

