/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import org.netezza.error.NzSQLException;
import org.netezza.internal.EscapeFunction;
import org.netezza.internal.ParseException;

public abstract class NzQuery {
    public NzQuery next;
    protected static final char HYPHEN = '-';
    protected static final char FORWARD_SLASH = '/';
    protected static final char NEXT_LINE = '\n';
    protected static final char ASTERIX = '*';
    protected static final char SINGLE_QUOTE = '\'';
    protected static final char DOUBLE_QUOTE = '\"';
    protected static final char BACKWARD_SLASH = '\\';
    protected static final char PARAMETER_MARKER = '?';
    protected static final int ERROR = -1;
    protected static final int COMPLETE = -2;
    private boolean escapeProcessing = true;
    private boolean analyzeFlg = false;
    public static final NzQuery COMMIT_QUERY = new NzQuery(){
        final String COMMIT = "COMMIT";

        @Override
        public QueryType getQueryType() {
            return QueryType.OTHER;
        }

        @Override
        public boolean isParsed() {
            return true;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return "COMMIT";
        }

        @Override
        public String toString() {
            return "COMMIT";
        }
    };
    public static final NzQuery ROLLBACK_QUERY = new NzQuery(){
        final String ROLLBACK = "ROLLBACK";

        @Override
        public QueryType getQueryType() {
            return QueryType.OTHER;
        }

        @Override
        public boolean isParsed() {
            return true;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return "ROLLBACK";
        }

        @Override
        public String toString() {
            return "ROLLBACK";
        }
    };
    public static final NzQuery SET_DATESTYLE_QUERY = new NzQuery(){
        final String SQL = "set datestyle to 'ISO';";

        @Override
        public QueryType getQueryType() {
            return QueryType.OTHER;
        }

        @Override
        public boolean isParsed() {
            return true;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return "set datestyle to 'ISO';";
        }

        @Override
        public String toString() {
            return "set datestyle to 'ISO';";
        }
    };
    public static final NzQuery SET_ENCODING_QUERY = new NzQuery(){
        final String SQL = "set nz_encoding to 'utf8';";

        @Override
        public QueryType getQueryType() {
            return QueryType.OTHER;
        }

        @Override
        public boolean isParsed() {
            return true;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return "set nz_encoding to 'utf8';";
        }

        @Override
        public String toString() {
            return "set nz_encoding to 'utf8';";
        }
    };
    public static final NzQuery VERSION_QUERY = new NzQuery(){
        final String SQL = "select version();";

        @Override
        public QueryType getQueryType() {
            return QueryType.SELECT;
        }

        @Override
        public boolean isParsed() {
            return true;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return "select version();";
        }

        @Override
        public String toString() {
            return "select version();";
        }
    };
    public static final NzQuery GET_TRANSACTION_ISOLATION_QUERY = new NzQuery(){
        final String SQL = "show transaction isolation level;";

        @Override
        public QueryType getQueryType() {
            return QueryType.SELECT;
        }

        @Override
        public boolean isParsed() {
            return true;
        }

        @Override
        public NzQuery parse() throws ParseException {
            return this;
        }

        @Override
        public String toNativeString() {
            return "show transaction isolation level;";
        }

        @Override
        public String toString() {
            return "show transaction isolation level;";
        }
    };

    public void setAnalyzeFlg(boolean flag) {
        this.analyzeFlg = flag;
    }

    public boolean getAnalyzeFlg() {
        return this.analyzeFlg;
    }

    public abstract NzQuery parse() throws ParseException;

    public abstract String toString();

    public abstract QueryType getQueryType();

    public abstract boolean isParsed();

    public abstract String toNativeString() throws NzSQLException;

    protected final SQLException syntaxError() {
        return new SQLException("Syntax Error.");
    }

    public final int parseEscapeSequence(String escapeSequence, StringBuilder builder) throws ParseException {
        if (escapeSequence == null) {
            return -2;
        }
        if ((escapeSequence = escapeSequence.trim()).charAt(0) != '{' || escapeSequence.charAt(escapeSequence.length() - 1) != '}') {
            return -1;
        }
        int length = (escapeSequence = escapeSequence.substring(1, escapeSequence.length() - 1).trim()).length();
        if (length == 0) {
            return -2;
        }
        char c = '\u0000';
        int index = 0;
        StringBuilder typeBuffer = new StringBuilder();
        boolean started = false;
        boolean end = false;
        block14: while (!end) {
            if (index >= length) {
                return -1;
            }
            c = escapeSequence.charAt(index++);
            switch (c) {
                case ' ': {
                    if (!started) continue block14;
                    end = true;
                    continue block14;
                }
            }
            typeBuffer.append(c);
            started = true;
        }
        String type = typeBuffer.toString();
        if (type.equalsIgnoreCase("fn")) {
            StringBuilder functionBuilder = new StringBuilder();
            while (true) {
                if (index >= length) {
                    return -1;
                }
                if ((c = escapeSequence.charAt(index++)) == '(') break;
                functionBuilder.append(c);
            }
            String functionName = functionBuilder.toString().trim();
            ArrayList<String> arguments = new ArrayList<String>();
            StringBuffer argument = new StringBuffer();
            int bracketCounter = 1;
            block16: while (bracketCounter != 0) {
                if (index >= length) {
                    return -1;
                }
                c = escapeSequence.charAt(index++);
                switch (c) {
                    case '{': {
                        StringBuffer argbuffer = new StringBuffer();
                        argbuffer.append(c);
                        char quoteInEscape = '\u0000';
                        int curlyBraceCounter = 1;
                        do {
                            if (index >= length) {
                                return -1;
                            }
                            c = escapeSequence.charAt(index++);
                            if (quoteInEscape == '\u0000') {
                                switch (c) {
                                    case '{': {
                                        curlyBraceCounter = (byte)(curlyBraceCounter + 1);
                                        break;
                                    }
                                    case '}': {
                                        curlyBraceCounter = (byte)(curlyBraceCounter - 1);
                                        break;
                                    }
                                    case '\"': 
                                    case '\'': {
                                        quoteInEscape = c;
                                    }
                                }
                            } else if (c == quoteInEscape) {
                                quoteInEscape = '\u0000';
                            }
                            argbuffer.append(c);
                        } while (curlyBraceCounter != 0);
                        argument.append(argbuffer);
                        continue block16;
                    }
                    case '(': {
                        ++bracketCounter;
                        argument.append(c);
                        continue block16;
                    }
                    case ')': {
                        if (--bracketCounter == 0) continue block16;
                        argument.append(c);
                        continue block16;
                    }
                    case ',': {
                        StringBuilder parsedArgument = new StringBuilder();
                        int res = this.parseArgument(argument.toString(), parsedArgument);
                        if (res == -1) {
                            return -1;
                        }
                        if (parsedArgument.length() != 0) {
                            arguments.add(parsedArgument.toString());
                        }
                        argument.setLength(0);
                        continue block16;
                    }
                }
                argument.append(c);
            }
            StringBuilder parsedArgument = new StringBuilder();
            int res = this.parseArgument(argument.toString(), parsedArgument);
            if (res == -1) {
                return -1;
            }
            if (parsedArgument.length() != 0) {
                arguments.add(parsedArgument.toString());
            }
            if (index < length) {
                return -1;
            }
            builder.append(this.invokeFunction(functionName, arguments));
        } else if (type.equalsIgnoreCase("d") || type.equalsIgnoreCase("t") || type.equalsIgnoreCase("ts")) {
            StringBuffer dateTimeBuffer = new StringBuffer();
            end = false;
            boolean ok = false;
            while (!end) {
                if (index >= length) {
                    return -1;
                }
                c = escapeSequence.charAt(index++);
                if (!ok) {
                    ok = true;
                    if (c != '\'') {
                        return -1;
                    }
                } else if (c == '\'') {
                    end = true;
                }
                dateTimeBuffer.append(c);
            }
            if (index < length) {
                return -1;
            }
            builder.append(dateTimeBuffer);
        } else if (type.equalsIgnoreCase("oj") || type.equalsIgnoreCase("interval")) {
            while (index < length) {
                builder.append(escapeSequence.charAt(index++));
            }
        } else if (!type.equalsIgnoreCase("?") && !type.equalsIgnoreCase("call")) {
            return -1;
        }
        return -2;
    }

    public static boolean containsLimitClause(String query) {
        String local_sql = query.toUpperCase();
        int index = local_sql.lastIndexOf("LIMIT");
        if (index > 0 && local_sql.length() > (index += 5) && Character.isSpace(local_sql.charAt(index)) && (local_sql = local_sql.substring(index).trim()).length() > 0) {
            if (local_sql.charAt(0) == '?') {
                ++index;
            } else if (local_sql.length() >= 3 && local_sql.substring(0, 3).equals("ALL")) {
                index += 3;
            } else {
                for (index = 0; index < local_sql.length() && Character.isDigit(local_sql.charAt(index)); ++index) {
                }
            }
            while (index < local_sql.length() && Character.isSpace(local_sql.charAt(index))) {
                ++index;
            }
            if ((local_sql = local_sql.substring(index)).length() >= 8 && local_sql.substring(0, 6).equalsIgnoreCase("OFFSET") || local_sql.length() > 1 && local_sql.charAt(0) == ',') {
                for (index = local_sql.charAt(0) == ',' ? 1 : 6; index < local_sql.length() && Character.isSpace(local_sql.charAt(index)); ++index) {
                }
                if (index < local_sql.length() && local_sql.charAt(index) == '?') {
                    ++index;
                } else {
                    while (index < local_sql.length() && Character.isDigit(local_sql.charAt(index))) {
                        ++index;
                    }
                }
                local_sql = local_sql.substring(index);
            }
            if (local_sql.length() == 0 || local_sql.length() == 1 && local_sql.charAt(0) == ';') {
                return true;
            }
        }
        return false;
    }

    private int parseArgument(String argument, StringBuilder output) throws ParseException {
        if (argument == null || argument.trim().length() == 0) {
            return -2;
        }
        argument = argument.trim();
        int length = argument.length();
        int index = 0;
        char c = '\u0000';
        char quote = '\u0000';
        block7: do {
            c = argument.charAt(index++);
            if (quote == '\u0000') {
                block0 : switch (c) {
                    case '\"': 
                    case '\'': {
                        quote = c;
                        output.append(c);
                        while (index < length) {
                            c = argument.charAt(index++);
                            output.append(c);
                            if (c != quote) continue;
                            break block0;
                        }
                        continue block7;
                    }
                    case '{': {
                        if (output.length() != 0) {
                            return -1;
                        }
                        if (argument.charAt(length - 1) != '}') {
                            return -1;
                        }
                        StringBuilder escapeBuilder = new StringBuilder();
                        int val = this.parseEscapeSequence(argument.toString(), escapeBuilder);
                        switch (val) {
                            case -2: {
                                output.append((CharSequence)escapeBuilder);
                                return -2;
                            }
                        }
                        return -1;
                    }
                    default: {
                        output.append(c);
                    }
                }
                continue;
            }
            output.append(c);
            if (c == quote) break;
        } while (index < length);
        if (index < length) {
            return -1;
        }
        return -2;
    }

    private String invokeFunction(String name, ArrayList<String> arguments) throws ParseException {
        try {
            EscapeFunction function = EscapeFunction.valueOf(name.toUpperCase());
            if (function == null) {
                throw new Exception("undefined scalar function");
            }
            return function.invoke(arguments);
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            buf.append(name).append('(');
            for (int i = 0; i < arguments.size(); ++i) {
                buf.append(arguments.get(i));
                if (i == arguments.size() - 1) continue;
                buf.append(',');
            }
            buf.append(')');
            return buf.toString();
        }
    }

    protected boolean isInteger(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public final boolean isEscapeProcessing() {
        return this.escapeProcessing;
    }

    public final void setEscapeProcessing(boolean escapeProcessing) {
        this.escapeProcessing = escapeProcessing;
    }

    public static enum QueryType {
        SELECT,
        SELECT_LIMIT,
        INSERT,
        UPDATE,
        DELETE,
        BATCH,
        OTHER,
        SET,
        WITH;


        public static QueryType getType(String type) {
            try {
                return QueryType.valueOf(type);
            }
            catch (Exception e) {
                return OTHER;
            }
        }
    }
}

