/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableCheckConstraintColumn;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableCheckConstraintType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.utils.CommonUtils;

public class DB2TableCheckConstraint
extends JDBCTableConstraint<DB2Table>
implements DB2SourceObject {
    private String owner;
    private DB2OwnerType ownerType;
    private Timestamp createTime;
    private String qualifier;
    private DB2TableCheckConstraintType type;
    private String fumcPath;
    private String text;
    private Integer precentValid;
    private String collationSchema;
    private String collationName;
    private String collationSchemaOrderBy;
    private String collationNameOrderBy;
    private List<DB2TableCheckConstraintColumn> columns;

    public DB2TableCheckConstraint(DBRProgressMonitor monitor, DB2Table table, ResultSet dbResult) throws DBException {
        super((JDBCTable)table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTNAME"), null, DBSEntityConstraintType.CHECK, true);
        DB2DataSource db2DataSource = (DB2DataSource)table.getDataSource();
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.qualifier = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"QUALIFIER");
        this.type = (DB2TableCheckConstraintType)CommonUtils.valueOf(DB2TableCheckConstraintType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE"));
        this.fumcPath = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNC_PATH");
        this.text = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TEXT");
        this.precentValid = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PERCENTVALID");
        this.collationSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLLATIONSCHEMA");
        this.collationName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATIONNAME");
        this.collationSchemaOrderBy = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATIONSCHEMA_ORDERBY");
        this.collationNameOrderBy = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATIONNAME_ORDERBY");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getTable().getContainer(), this.getTable(), this});
    }

    @Override
    @NotNull
    public DB2DataSource getDataSource() {
        return (DB2DataSource)this.getTable().getDataSource();
    }

    public List<? extends DBSEntityAttributeRef> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.columns;
    }

    public void setColumns(List<DB2TableCheckConstraintColumn> columns) {
        this.columns = columns;
    }

    @Override
    public DB2Schema getSchema() {
        return this.getTable().getSchema();
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return DBSObjectState.UNKNOWN;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return SQLFormatUtils.formatSQL((DBPDataSource)this.getDataSource(), (String)this.text);
    }

    @Property(viewable=true, editable=false, order=2)
    public DB2Table getTable() {
        return (DB2Table)super.getTable();
    }

    @Property(hidden=true)
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return super.getConstraintType();
    }

    @Property(viewable=true, editable=false, order=3)
    public DB2TableCheckConstraintType getType() {
        return this.type;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=false, editable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, editable=false)
    public String getQualifier() {
        return this.qualifier;
    }

    @Property(viewable=false, editable=false)
    public String getFumcPath() {
        return this.fumcPath;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Integer getPrecentValid() {
        return this.precentValid;
    }

    @Property(viewable=false, editable=false, category="Collation")
    public String getCollationSchema() {
        return this.collationSchema;
    }

    @Property(viewable=false, editable=false, category="Collation")
    public String getCollationName() {
        return this.collationName;
    }

    @Property(viewable=false, editable=false, category="Collation")
    public String getCollationSchemaOrderBy() {
        return this.collationSchemaOrderBy;
    }

    @Property(viewable=false, editable=false, category="Collation")
    public String getCollationNameOrderBy() {
        return this.collationNameOrderBy;
    }
}

