/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class DB2UniqueKeyManager
extends SQLConstraintManager<DB2TableUniqueKey, DB2Table> {
    private static final String SQL_DROP_PK = "ALTER TABLE %s DROP PRIMARY KEY ";
    private static final String SQL_DROP_UK = "ALTER TABLE %s DROP UNIQUE %s";

    public boolean canEditObject(DB2TableUniqueKey object) {
        return false;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DB2TableUniqueKey> getObjectsCache(DB2TableUniqueKey object) {
        return ((DB2Table)object.getParentObject()).getSchema().getConstraintCache();
    }

    public DB2TableUniqueKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object table, Object from, Map<String, Object> options) {
        return new DB2TableUniqueKey((DB2Table)table, DBSEntityConstraintType.UNIQUE_KEY);
    }

    public String getDropConstraintPattern(DB2TableUniqueKey constraint) {
        String tablename = constraint.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL);
        if (constraint.getConstraintType().equals(DBSEntityConstraintType.PRIMARY_KEY)) {
            return String.format(SQL_DROP_PK, tablename);
        }
        return String.format(SQL_DROP_UK, tablename, constraint.getName());
    }
}

