/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.DB2Constants;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterHexString;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class DB2SQLDialect
extends JDBCSQLDialect {
    public static final String[] EXEC_KEYWORDS = new String[]{"call"};
    private static final String[][] DB2_BEGIN_END_BLOCK = new String[0][];

    public DB2SQLDialect() {
        super("DB2 LUW", "db2_luw");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        String[] stringArray = DB2Constants.ADVANCED_KEYWORDS;
        int n = DB2Constants.ADVANCED_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String kw = stringArray[n2];
            this.addSQLKeyword(kw);
            ++n2;
        }
        this.turnFunctionIntoKeyword("TRUNCATE");
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @Nullable
    public String getDualTableName() {
        return "SYSIBM.SYSDUMMY1";
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return BinaryFormatterHexString.INSTANCE;
    }

    public String[][] getBlockBoundStrings() {
        return DB2_BEGIN_END_BLOCK;
    }

    public String getScriptDelimiterRedefiner() {
        return "DELIMITER";
    }
}

