/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.eclipse.jface.viewers.EditingSupport;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;

abstract class VQBPanelQueryExpression<ITEM>
extends VQBPanelQueryElements<ITEM> {
    public final Object[] EMPTY_CHILDREN = new Object[0];

    protected VQBPanelQueryExpression(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected TreeContentProvider makeContentProvider() {
        return new ExpressionTreeContentProvider();
    }

    @Override
    protected void loadElements() {
        SelectBody selectBody = this.getQueryInfo().getParsedQuery().getSelectBody();
        if (selectBody instanceof PlainSelect) {
            this.elementViewer.setInput((Object)selectBody);
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
        this.elementViewer.expandAll();
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, ITEM> columnsController) {
        columnsController.addColumn("Expression", "Compound Expression", 16384, true, true, element -> {
            Expression expr = this.getItemExpression(element);
            boolean isNot = false;
            if (expr instanceof NotExpression) {
                isNot = true;
                expr = ((NotExpression)expr).getExpression();
            }
            if (VQBUtils.isCompoundExpression(expr)) {
                if (expr instanceof Parenthesis) {
                    return "( ... )";
                }
                if (expr instanceof BinaryExpression) {
                    String stringExpression = ((BinaryExpression)expr).getStringExpression();
                    return String.valueOf(isNot ? "NOT " : "") + stringExpression;
                }
            }
            return expr.toString();
        }, this.makeExpressionEditSupport());
    }

    protected EditingSupport makeExpressionEditSupport() {
        return null;
    }

    protected Expression getItemExpression(Object element) {
        if (element instanceof Expression) {
            return (Expression)element;
        }
        return this.getExpression(element);
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return DBIcon.TREE_FUNCTION;
    }

    protected abstract List<ITEM> extractRootItems(PlainSelect var1);

    protected abstract Expression getExpression(ITEM var1);

    protected class ExpressionTreeContentProvider
    extends TreeContentProvider {
        protected ExpressionTreeContentProvider() {
        }

        public Object getParent(Object element) {
            return super.getParent(element);
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof PlainSelect) {
                List exprList = VQBPanelQueryExpression.this.extractRootItems((PlainSelect)inputElement);
                if (exprList == null) {
                    return VQBPanelQueryExpression.this.EMPTY_CHILDREN;
                }
                return exprList.toArray();
            }
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            Expression expression = VQBPanelQueryExpression.this.getItemExpression(parentElement);
            if (expression instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)expression;
                ArrayList<Expression> nestedConditions = new ArrayList<Expression>();
                VQBQueryInfo queryInfo = VQBPanelQueryExpression.this.getQueryInfo();
                VQBUtils.collectNestedConditions(queryInfo, nestedConditions, (Expression)binaryExpression, binaryExpression.getLeftExpression());
                VQBUtils.collectNestedConditions(queryInfo, nestedConditions, (Expression)binaryExpression, binaryExpression.getRightExpression());
                return nestedConditions.toArray();
            }
            if (expression instanceof Parenthesis) {
                return new Object[]{((Parenthesis)expression).getExpression()};
            }
            return VQBPanelQueryExpression.this.EMPTY_CHILDREN;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof PlainSelect) {
                return true;
            }
            Expression expression = VQBPanelQueryExpression.this.getItemExpression(element);
            return element instanceof Expression && VQBUtils.isCompoundExpression(expression);
        }
    }
}

