/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.informix.model;

import com.dbeaver.db.informix.model.InformixConstraint;
import com.dbeaver.db.informix.model.InformixDataSource;
import com.dbeaver.db.informix.model.InformixProcedure;
import com.dbeaver.db.informix.model.InformixTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.informix.InformixUtils;
import org.jkiss.dbeaver.ext.informix.model.InformixMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class InformixMetaModelExt
extends InformixMetaModel {
    private static final Log log = Log.getLog(InformixMetaModelExt.class);

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new InformixDataSource(monitor, container, (GenericMetaModel)this);
    }

    public boolean isSchemasOptional() {
        return false;
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog catalog) throws DBException {
        String sql = "SELECT UNIQUE owner FROM " + (catalog.getName() != null ? String.valueOf(catalog.getName()) + ":" : "") + "informix.systables WHERE tabtype != ''";
        ArrayList<GenericSchema> schemaList = new ArrayList<GenericSchema>();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(sql);){
                    while (dbResult.next()) {
                        String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (int)1);
                        GenericSchema schema = new GenericSchema(dataSource, catalog, CommonUtils.notEmpty((String)name));
                        schemaList.add(schema);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)dataSource);
        }
        return schemaList;
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return super.createTableImpl(container, tableName, tableType, dbResult);
        }
        return new InformixTable(container, tableName, tableType, dbResult);
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException, DBException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT tab.tabname AS TABLE_NAME, constr.constrname AS PK_NAME, constr.constrtype, chk.checktext,\n  c1.colname as COLUMN_NAME, c1.colno as KEY_SEQ\n  from sysconstraints constr\n  join systables tab on tab.tabid = constr.tabid\n  left outer join syschecks chk on chk.constrid = constr.constrid and chk.type = 'T'\n  left outer join sysindexes i on i.idxname = constr.idxname\n  left outer join syscolumns c1 on c1.tabid = tab.tabid AND c1.colno IN (part1, part2, part3, part4, part5, part6, part7, part8, \n    part9, part10, part11, part12, part13, part14, part15, part16)\n  WHERE constr.constrtype IN ('P', 'U', 'C')  AND tab.owner =?" + (forParent != null ? " AND tab.tabname=?" : ""));
        if (forParent != null) {
            dbStat.setString(1, forParent.getSchema().getName());
            dbStat.setString(2, forParent.getName());
        } else {
            dbStat.setString(1, owner.getName());
        }
        return dbStat;
    }

    public DBSEntityConstraintType getUniqueConstraintType(JDBCResultSet dbResult) throws DBException, SQLException {
        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"constrtype");
        if (type != null) {
            if ("P".equals(type)) {
                return DBSEntityConstraintType.PRIMARY_KEY;
            }
            if ("C".equals(type)) {
                return DBSEntityConstraintType.CHECK;
            }
            return DBSEntityConstraintType.UNIQUE_KEY;
        }
        return super.getUniqueConstraintType(dbResult);
    }

    public GenericUniqueKey createConstraintImpl(GenericTableBase table, String constraintName, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        String expression = "";
        if (dbResult != null) {
            expression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"checktext");
        }
        return new InformixConstraint(table, constraintName, constraintType, persisted, CommonUtils.notEmpty((String)expression).trim());
    }

    public boolean supportsCheckConstraints() {
        return true;
    }

    public void loadProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        GenericDataSource dataSource = container.getDataSource();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read Informix procedures");){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT PROCNAME, PROCID, SPECIFICNAME, ISPROC, PARAMTYPES FROM SYSPROCEDURES WHERE OWNER = ?");){
                    dbStat.setString(1, container.getName());
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.nextRow()) {
                            DBSProcedureType routineType = DBSProcedureType.PROCEDURE;
                            try {
                                String isProc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ISPROC");
                                if ("f".equalsIgnoreCase(isProc)) {
                                    routineType = DBSProcedureType.FUNCTION;
                                }
                            }
                            catch (IllegalArgumentException e) {
                                log.warn((Object)e);
                            }
                            InformixProcedure procedure = new InformixProcedure((GenericStructContainer)container, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PROCID"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROCNAME"), routineType);
                            container.addProcedure((GenericProcedure)procedure);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)dataSource);
        }
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure procedure) throws DBException {
        InformixProcedure informixProcedure = (InformixProcedure)procedure;
        String sqlProcedure = String.format("select b.data from sysprocbody b join sysprocedures p on b.procid=p.procid where datakey='T' and p.procid = '%s'order by b.procid, b.seqno", informixProcedure.getId());
        return InformixUtils.listToString((List)InformixUtils.getSource((DBRProgressMonitor)monitor, (String)sqlProcedure, (String)informixProcedure.getName(), (GenericDataSource)((GenericDataSource)informixProcedure.getDataSource())), null);
    }
}

