/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.InfluxUtils;
import com.dbeaver.ee.influxdb.exec.InfluxExecutionContext;
import com.dbeaver.ee.influxdb.model.InfluxDataSourceInfo;
import com.dbeaver.ee.influxdb.model.InfluxDataType;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import com.dbeaver.ee.influxdb.model.InfluxSQLDialect;
import com.dbeaver.ee.influxdb.model.InfluxStructureAssistant;
import com.dbeaver.ee.influxdb.model.InfluxUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.AbstractSimpleDataSource;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.utils.CommonUtils;

public class InfluxDataSource
extends AbstractSimpleDataSource<InfluxExecutionContext>
implements DBPDataTypeProvider,
DBPTermProvider,
IAdaptable {
    private List<InfluxDatabase> databases;
    private InfluxDataSourceInfo info;
    private final List<InfluxDataType> dataTypes = new ArrayList<InfluxDataType>();
    private final UserCache userCache = new UserCache();

    public InfluxDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBCException {
        super(container);
        InfluxDataType.TypeName[] typeNameArray = InfluxDataType.TypeName.values();
        int n = typeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            InfluxDataType.TypeName typeName = typeNameArray[n2];
            this.dataTypes.add(new InfluxDataType(this, typeName));
            ++n2;
        }
        this.executionContext = new InfluxExecutionContext(this, "Main Influx Connection", this.getContainer().getActualConnectionConfiguration().getDatabaseName());
        ((InfluxExecutionContext)this.executionContext).connect(monitor);
    }

    public String getDefaultDatabaseName() {
        return ((InfluxExecutionContext)this.executionContext).getDefaultDatabase();
    }

    public SQLDialect getSQLDialect() {
        return InfluxSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new InfluxDataSourceInfo(this);
        this.databases = new ArrayList<InfluxDatabase>();
        InfluxDB influxDB = ((InfluxExecutionContext)this.getDefaultContext(monitor, true)).getInfluxDB();
        String defaultDatabaseName = this.getDefaultDatabaseName();
        QueryResult dbListResult = influxDB.query(new Query("SHOW DATABASES", CommonUtils.isEmpty((String)defaultDatabaseName) ? null : defaultDatabaseName));
        for (QueryResult.Result result : dbListResult.getResults()) {
            List values = ((QueryResult.Series)result.getSeries().get(0)).getValues();
            for (List dbObj : values) {
                Object dbName = dbObj.get(0);
                this.databases.add(new InfluxDatabase(this, CommonUtils.toString(dbName)));
            }
        }
        this.databases.sort(DBUtils.nameComparator());
    }

    @NotNull
    public InfluxExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        InfluxExecutionContext context = new InfluxExecutionContext(this, purpose, initFrom instanceof InfluxExecutionContext ? ((InfluxExecutionContext)initFrom).getDefaultDatabase() : this.getContainer().getActualConnectionConfiguration().getDatabaseName());
        context.connect(monitor);
        return context;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new InfluxStructureAssistant(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        String term = null;
        if ("database".equals(objectType)) {
            term = "Database";
        } else if ("measurement".equals(objectType)) {
            term = "Measurement";
        }
        if (term != null && multiple) {
            term = String.valueOf(term) + "s";
        }
        return term;
    }

    @Association
    public List<InfluxDatabase> getDatabases() {
        return this.databases;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.databases;
    }

    public InfluxDatabase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (InfluxDatabase)DBUtils.findObject(this.databases, (String)childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return InfluxDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        for (InfluxDataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType.getDataKind();
        }
        return DBPDataKind.OBJECT;
    }

    public InfluxDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.getLocalDataType(typeFullName);
    }

    public List<InfluxDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public InfluxDataType getLocalDataType(String typeName) {
        for (InfluxDataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType;
        }
        return null;
    }

    public InfluxDataType getLocalDataType(int typeID) {
        for (InfluxDataType dataType : this.dataTypes) {
            if (dataType.getTypeID() != typeID) continue;
            return dataType;
        }
        return null;
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return InfluxDataType.TypeName.STRING.getTypeName();
    }

    @Association
    public List<InfluxUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, this);
    }

    class UserCache
    extends AbstractObjectCache<InfluxDataSource, InfluxUser> {
        UserCache() {
        }

        @NotNull
        public List<InfluxUser> getAllObjects(@NotNull DBRProgressMonitor monitor, @NotNull InfluxDataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<InfluxUser> users = new ArrayList<InfluxUser>();
                InfluxDB influxDB = ((InfluxExecutionContext)dataSource.getDefaultContext(monitor, true)).getInfluxDB();
                QueryResult dbListResult = influxDB.query(new Query("SHOW USERS", null));
                for (QueryResult.Result result : dbListResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List row : CommonUtils.safeList((List)series.getValues())) {
                            String name = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, row, "user"));
                            boolean isAdmin = CommonUtils.toBoolean((Object)InfluxUtils.getResultValue(series, row, "admin"));
                            users.add(new InfluxUser(dataSource, name, isAdmin));
                        }
                    }
                }
                users.sort(DBUtils.nameComparator());
                this.setCache(users);
            }
            return this.getCachedObjects();
        }

        public InfluxUser getObject(@NotNull DBRProgressMonitor monitor, @NotNull InfluxDataSource dataSource, @NotNull String name) throws DBException {
            return (InfluxUser)DBUtils.findObject(this.getAllObjects(monitor, dataSource), (String)name);
        }
    }
}

