/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.utils.IOUtils;

public class StaticTLSUtils {
    private static final Log log = Log.getLog(StaticTLSUtils.class);

    public static File getStaticCertFile(DBRProgressMonitor monitor, Class<?> bundleClass, String localCacheFolder, String remoteURL) {
        File caCertFile;
        URL url;
        File caCertFolder = new File(DBWorkbench.getPlatform().getWorkspace().getMetadataFolder(), localCacheFolder);
        if (!caCertFolder.exists() && !caCertFolder.mkdirs()) {
            log.warn((Object)("Can't create local cache folder '" + caCertFolder.getAbsolutePath() + "'"));
            return null;
        }
        try {
            url = new URL(remoteURL);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Invalid remote TLS URL", (Throwable)e);
            return null;
        }
        String remoteFileName = url.getFile();
        int divPos = remoteFileName.lastIndexOf("/");
        if (divPos != -1) {
            remoteFileName = remoteFileName.substring(divPos + 1);
        }
        if (!(caCertFile = new File(caCertFolder, remoteFileName)).exists()) {
            try {
                WebUtils.downloadRemoteFile((DBRProgressMonitor)monitor, (String)"Download remote TLS certificate", (String)remoteURL, (File)caCertFile, null);
            }
            catch (Exception e) {
                log.warn((Object)"Error downloading remote TLS certificate", (Throwable)e);
            }
        }
        if (!caCertFile.exists()) {
            try {
                Throwable e = null;
                Object var10_14 = null;
                try (FileOutputStream certStream = new FileOutputStream(caCertFile);){
                    IOUtils.copyStream((InputStream)bundleClass.getClassLoader().getResourceAsStream("tls/" + remoteFileName), (OutputStream)certStream);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error extracting SSL CA certificate", (Throwable)e);
                return null;
            }
        }
        return caCertFile;
    }
}

