/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.dbeaver.db.ycql.CasUtils;
import com.dbeaver.db.ycql.model.CasTableBase;
import com.dbeaver.db.ycql.model.CasTypedObject;
import com.dbeaver.db.ycql.model.CasUserType;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class CasTableColumn
implements DBSTableColumn,
CasTypedObject,
DBSTypedObjectEx {
    private static final Log log = Log.getLog(CasTableColumn.class);
    private final CasTableBase table;
    private final ColumnMetadata metadata;
    private int position;

    public CasTableColumn(CasTableBase table, ColumnMetadata metadata, int position) {
        this.table = table;
        this.metadata = metadata;
        this.position = position;
    }

    public ColumnMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, editable=true, order=2)
    public int getOrdinalPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public DataType getCasDataType() {
        return this.metadata.getType();
    }

    public int getTypeID() {
        return CasUtils.getTypeNameID(this.metadata.getType());
    }

    public DBPDataKind getDataKind() {
        return CasUtils.getDataKind(this.metadata.getType());
    }

    @Property(viewable=true, editable=true, order=3)
    public String getTypeName() {
        return this.metadata.getType().getName().toString();
    }

    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public boolean isRequired() {
        List tablePK = this.metadata.getParent().getPrimaryKey();
        if (!CommonUtils.isEmpty((Collection)tablePK) && tablePK.contains(this.metadata)) {
            return true;
        }
        DBPDataKind dataKind = this.getDataKind();
        return dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.BOOLEAN;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @NotNull
    public CasTableBase getParentObject() {
        return this.table;
    }

    public String getDefaultValue() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Integer getScale() {
        return 0;
    }

    public Integer getPrecision() {
        return 0;
    }

    public long getMaxLength() {
        return 0L;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @Nullable
    public CasUserType getDataType() {
        try {
            return this.table.getKeyspace().getUserType((DBRProgressMonitor)new VoidProgressMonitor(), this.metadata.getType());
        }
        catch (DBException e) {
            log.error((Object)"Error reading user types", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.metadata.toString();
    }
}

