/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.data;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.dbeaver.db.ycql.data.CasAbstractValue;
import com.dbeaver.db.ycql.data.CasListValue;
import com.dbeaver.db.ycql.data.CasMapValue;
import com.dbeaver.db.ycql.data.CasSetValue;
import com.dbeaver.db.ycql.data.CasUDTValue;
import com.dbeaver.db.ycql.exec.CasResultSet;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasExecutionContext;
import com.dbeaver.db.ycql.model.CasTupleType;
import com.dbeaver.db.ycql.model.CasTupleTypeAttribute;
import com.dbeaver.ee.model.content.DBContentByteBuffer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class CasTupleValue
extends CasAbstractValue
implements DBDComposite,
DBDValueCloneable {
    private static final Log log = Log.getLog(CasTupleValue.class);
    @Nullable
    private TupleValue rawValue;
    @Nullable
    private CasTupleType tupleType;

    public CasTupleValue(@NotNull CasExecutionContext executionContext, @NotNull String keyspace, @Nullable TupleValue value) throws DBCException {
        super(executionContext, keyspace);
        this.rawValue = value;
        this.tupleType = value == null ? null : ((CasDataSource)executionContext.getDataSource()).getCachedTupleType(value.getType());
    }

    public CasTupleValue(CasTupleValue value) {
        super(value);
        this.rawValue = value.rawValue;
        this.tupleType = value.tupleType;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new CasTupleValue(this);
    }

    public TupleValue getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        this.rawValue = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.rawValue.toString();
    }

    public CasTupleType getDataType() {
        return this.tupleType;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.tupleType == null) {
            return new DBSAttributeBase[0];
        }
        try {
            List<CasTupleTypeAttribute> attrs = this.tupleType.getAttributes((DBRProgressMonitor)new VoidProgressMonitor());
            if (attrs == null) {
                return new DBSAttributeBase[0];
            }
            DBSAttributeBase[] result = new DBSAttributeBase[attrs.size()];
            attrs.toArray(result);
            return result;
        }
        catch (DBException e) {
            log.error((Object)e);
            return new DBSAttributeBase[0];
        }
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        if (this.rawValue == null) {
            return null;
        }
        int index = attribute.getOrdinalPosition() - 1;
        DataType type = ((CasTupleTypeAttribute)attribute).getCasDataType();
        switch (type.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return this.rawValue.getString(index);
            }
            case TINYINT: {
                return this.rawValue.getByte(index);
            }
            case SMALLINT: {
                return this.rawValue.getShort(index);
            }
            case INT: {
                return this.rawValue.getInt(index);
            }
            case BIGINT: {
                return this.rawValue.getLong(index);
            }
            case COUNTER: {
                return this.rawValue.getLong(index);
            }
            case VARINT: {
                return this.rawValue.getVarint(index);
            }
            case DECIMAL: {
                return this.rawValue.getDecimal(index);
            }
            case FLOAT: {
                return Float.valueOf(this.rawValue.getFloat(index));
            }
            case DOUBLE: {
                return this.rawValue.getDouble(index);
            }
            case BOOLEAN: {
                return this.rawValue.getBool(index);
            }
            case DATE: {
                return this.rawValue.getDate(index);
            }
            case TIME: {
                return this.rawValue.getTime(index);
            }
            case TIMESTAMP: {
                return this.rawValue.getTimestamp(index);
            }
            case UUID: 
            case TIMEUUID: {
                return this.rawValue.getUUID(index);
            }
            case INET: {
                return this.rawValue.getInet(index);
            }
            case MAP: {
                return new CasMapValue(this.executionContext, this.keyspace, this.rawValue.getMap(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0)), CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(1))), type);
            }
            case LIST: {
                return new CasListValue((DBRProgressMonitor)new VoidProgressMonitor(), this.executionContext, this.keyspace, this.rawValue.getList(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0))), type);
            }
            case SET: {
                return new CasSetValue(this.executionContext, this.keyspace, this.rawValue.getSet(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0))), type);
            }
            case TUPLE: {
                return new CasTupleValue(this.executionContext, this.keyspace, this.rawValue.getTupleValue(index));
            }
            case UDT: {
                return new CasUDTValue(this.executionContext, this.keyspace, this.rawValue.getUDTValue(index));
            }
        }
        return new DBContentByteBuffer((DBCExecutionContext)this.executionContext, this.rawValue.getBytes(index));
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) throws DBCException {
        if (this.rawValue == null) {
            this.rawValue = this.tupleType.getMetadata().newValue();
        }
        int index = attribute.getOrdinalPosition() - 1;
        if (value == null) {
            this.rawValue.setToNull(index);
            return;
        }
        DataType type = ((CasTupleTypeAttribute)attribute).getCasDataType();
        switch (type.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                this.rawValue.setString(index, (String)value);
                break;
            }
            case TINYINT: {
                this.rawValue.setByte(index, ((Byte)value).byteValue());
                break;
            }
            case SMALLINT: {
                this.rawValue.setShort(index, ((Short)value).shortValue());
                break;
            }
            case INT: {
                this.rawValue.setInt(index, ((Integer)value).intValue());
                break;
            }
            case BIGINT: {
                this.rawValue.setLong(index, ((Long)value).longValue());
                break;
            }
            case COUNTER: {
                this.rawValue.setLong(index, ((Long)value).longValue());
                break;
            }
            case VARINT: {
                this.rawValue.setVarint(index, (BigInteger)value);
                break;
            }
            case DECIMAL: {
                this.rawValue.setDecimal(index, (BigDecimal)value);
                break;
            }
            case FLOAT: {
                this.rawValue.setFloat(index, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.rawValue.setDouble(index, ((Double)value).doubleValue());
                break;
            }
            case BOOLEAN: {
                this.rawValue.setBool(index, ((Boolean)value).booleanValue());
                break;
            }
            case DATE: {
                this.rawValue.setDate(index, (LocalDate)value);
                break;
            }
            case TIME: {
                this.rawValue.setTime(index, ((Long)value).longValue());
                break;
            }
            case TIMESTAMP: {
                this.rawValue.setTimestamp(index, (Date)value);
                break;
            }
            case UUID: 
            case TIMEUUID: {
                this.rawValue.setUUID(index, (UUID)value);
                break;
            }
            case INET: {
                this.rawValue.setInet(index, (InetAddress)value);
                break;
            }
            case MAP: {
                this.rawValue.setMap(index, (Map)value);
                break;
            }
            case LIST: {
                this.rawValue.setList(index, (List)value);
                break;
            }
            case SET: {
                this.rawValue.setSet(index, (Set)value);
            }
            case TUPLE: {
                this.rawValue.setTupleValue(index, (TupleValue)value);
                break;
            }
            case UDT: {
                this.rawValue.setUDTValue(index, (UDTValue)value);
                break;
            }
            default: {
                this.rawValue.setBytes(index, (ByteBuffer)value);
            }
        }
    }
}

