/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.triggers;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.OnReloadReferenceListener;

public class AutoNumberManager {
    private static final Map<Column, AtomicInteger> register = new HashMap<Column, AtomicInteger>();

    static synchronized void clear() {
        register.clear();
    }

    static synchronized int getNext(Column cl) {
        ColumnImpl ci = (ColumnImpl)cl;
        AtomicInteger next = register.get(ci);
        if (next == null) {
            next = new AtomicInteger((Integer)ci.getAutoNumberGenerator().getLast());
            register.put((Column)ci, next);
        }
        return next.incrementAndGet();
    }

    public static synchronized void reset(Column cl, int newVal) {
        register.put(cl, new AtomicInteger(newVal));
    }

    public static synchronized void bump(Column cl, int newVal) {
        ColumnImpl ci = (ColumnImpl)cl;
        AtomicInteger next = register.get(ci);
        if (next == null) {
            next = new AtomicInteger((Integer)ci.getAutoNumberGenerator().getLast());
            register.put((Column)ci, next);
        }
        if (newVal > next.get()) {
            next.set(newVal);
        }
    }

    static {
        DBReference.addOnReloadRefListener(new OnReloadReferenceListener(){

            @Override
            public void onReload() {
                AutoNumberManager.clear();
            }
        });
    }
}

