/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.views;

import com.dbeaver.db.mongodb.MongoDBMessages;
import com.dbeaver.db.mongodb.MongoUIActivator;
import com.dbeaver.db.mongodb.MongoUtils;
import com.dbeaver.db.mongodb.views.MongoConnectionPageBase;
import com.mongodb.MongoCredential;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class MongoDBConnectionPage
extends MongoConnectionPageBase {
    private static final ImageDescriptor logoImage = MongoUIActivator.getImageDescriptor("icons/mongodb_logo.png");
    private Combo mechanismCombo;
    private Text userNameText;
    private Text userSourceText;

    @Override
    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        super.createControl(composite);
    }

    @Override
    protected void createAuthPanel(Composite settingsGroup) {
        Group authGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)MongoDBMessages.connection_page_group_credentials, (int)4, (int)768, (int)-1);
        this.mechanismCombo = UIUtils.createLabelCombo((Composite)authGroup, (String)MongoDBMessages.connection_page_label_combo_mechanism, (int)12);
        this.mechanismCombo.add("NONE");
        this.mechanismCombo.add(MongoCredential.SCRAM_SHA_1_MECHANISM);
        this.mechanismCombo.add(MongoCredential.SCRAM_SHA_256_MECHANISM);
        this.mechanismCombo.add(MongoCredential.MONGODB_CR_MECHANISM);
        this.mechanismCombo.add(MongoCredential.PLAIN_MECHANISM);
        this.mechanismCombo.add(MongoCredential.GSSAPI_MECHANISM);
        this.mechanismCombo.add(MongoCredential.MONGODB_X509_MECHANISM);
        this.mechanismCombo.setLayoutData((Object)new GridData(32));
        this.mechanismCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBConnectionPage.this.enableAuthFields();
            }
        });
        UIUtils.createEmptyLabel((Composite)authGroup, (int)2, (int)1);
        this.userNameText = UIUtils.createLabelText((Composite)authGroup, (String)MongoDBMessages.connection_page_label_text_user, (String)"", (int)2048);
        this.userSourceText = UIUtils.createLabelText((Composite)authGroup, (String)MongoDBMessages.connection_page_label_text_source, (String)"", (int)2048);
        this.userSourceText.setToolTipText(MongoDBMessages.connection_page_tool_tip_text_user_source_database);
        this.createPasswordText((Composite)authGroup, MongoDBMessages.connection_page_label_text_password);
        this.createPasswordControls((Composite)authGroup, 2);
    }

    private void enableAuthFields() {
        boolean authEnabled = this.mechanismCombo.getSelectionIndex() > 0;
        this.userNameText.setEnabled(authEnabled);
        this.userSourceText.setEnabled(authEnabled);
        this.passwordText.setEnabled(authEnabled);
    }

    @Override
    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.mechanismCombo != null) {
            String mechanism = connectionInfo.getProviderProperty("@dbeaver-mongo-cred-mechanism@");
            if (mechanism == null) {
                mechanism = "NONE";
            }
            this.mechanismCombo.setText(mechanism);
        }
        String auth = connectionInfo.getProviderProperty("@dbeaver-auth@0");
        String authSource = connectionInfo.getProviderProperty("@dbeaver-auth-source@");
        if (auth != null) {
            String[] authTokens = MongoUtils.extractAuthInfo((String)auth);
            this.userNameText.setText(authTokens[0]);
            this.userSourceText.setText(authTokens[1]);
            this.passwordText.setText(authTokens[2]);
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            this.userNameText.setText(connectionInfo.getUserName());
        }
        if (authSource != null) {
            this.userSourceText.setText(authSource);
        } else {
            this.userSourceText.setText("admin");
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
            this.passwordText.setText(connectionInfo.getUserPassword());
        }
        this.enableAuthFields();
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setProviderProperty("@dbeaver-mongo-cred-mechanism@", this.mechanismCombo.getText());
        connectionInfo.setUserName(this.userNameText.getText().trim());
        connectionInfo.setProviderProperty("@dbeaver-auth-source@", this.userSourceText.getText());
        connectionInfo.setUserPassword(this.passwordText.getText());
        super.saveSettings(dataSource);
    }
}

