/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.model;

import com.dbeaver.db.redis.RedisConstants;
import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisExecutionContext;
import com.dbeaver.db.redis.model.RedisDataSourceInfo;
import com.dbeaver.db.redis.model.RedisDatabase;
import com.dbeaver.db.redis.model.RedisSQLDialect;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractSimpleDataSource;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterHostAndPortMap;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.commands.BasicCommands;

public class RedisDataSource
extends AbstractSimpleDataSource<RedisExecutionContext>
implements DBPRefreshableObject,
DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(RedisDataSource.class);
    private static final int CLUSTER_MAX_ATTEMPTS = 5;
    @Nullable
    private final JedisCluster jedisCluster;
    @Nullable
    private final JedisPool jedisPool;
    private final boolean useCluster;
    private List<RedisDatabase> databases;
    private RedisDataSourceInfo info;
    private TPRuleBasedScanner commandRuleManager;
    private Map<String, Method[]> commandMethods = new HashMap<String, Method[]>();
    private RedisSQLDialect dialect;
    private DBWHandlerConfiguration tunnelConfig;
    private Map<String, DBPConnectionConfiguration> nodeTunnelConfigs = new HashMap<String, DBPConnectionConfiguration>();
    private List<DBWTunnel> nodeTunnels = new ArrayList<DBWTunnel>();

    public RedisDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBCException {
        super(container);
        String userPassword;
        DBPConnectionConfiguration connectionInfo = container.getActualConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        String hostPort = connectionInfo.getHostPort();
        int connectTimeout = CommonUtils.toInt((Object)connectionInfo.getProviderProperty("@dbeaver-redis.timeout.connect"), (int)10000);
        int socketTimeout = CommonUtils.toInt((Object)connectionInfo.getProviderProperty("@dbeaver-redis.timeout.socket"), (int)100000);
        String userName = connectionInfo.getUserName();
        if (CommonUtils.isEmpty((String)userName)) {
            userName = null;
        }
        if (CommonUtils.isEmpty((String)(userPassword = connectionInfo.getUserPassword()))) {
            userPassword = null;
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        boolean useSSL = false;
        SSLSocketFactory sslFactory = null;
        SSLParameters sslParameters = null;
        HostnameVerifier hostVerifier = null;
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("redis_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            useSSL = true;
            boolean skipHostValidation = sslConfig.getBooleanProperty("@dbeaver-redis.ssl.skipHostValidation");
            if (skipHostValidation) {
                hostVerifier = (s, sslSession) -> true;
            }
            try {
                SSLHandlerTrustStoreImpl.initializeTrustStore((DBRProgressMonitor)monitor, (DBPDataSource)this, (DBWHandlerConfiguration)sslConfig);
                sslFactory = SSLHandlerTrustStoreImpl.createTrustStoreSslSocketFactory((DBPDataSource)this, (DBWHandlerConfiguration)sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error initializing SSL trust store", (Throwable)e);
            }
            sslParameters = new SSLParameters();
        }
        this.useCluster = CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("redis.use.cluster"));
        if (this.useCluster) {
            if (this.getContainer().getActualConnectionConfiguration().getHandler("redis_ssl") != null) {
                for (DBWHandlerConfiguration handler : this.getContainer().getActualConnectionConfiguration().getHandlers()) {
                    if (!handler.isEnabled() || handler.getType() != DBWHandlerType.TUNNEL) continue;
                    this.tunnelConfig = handler;
                    break;
                }
            }
            this.jedisPool = null;
            HostAndPort clusterEndpoint = new HostAndPort(hostName, Integer.parseInt(hostPort));
            this.jedisCluster = new JedisCluster(clusterEndpoint, connectTimeout, socketTimeout, 5, userName, userPassword, Platform.getProduct().getId(), (GenericObjectPoolConfig)poolConfig, useSSL, sslFactory, sslParameters, hostVerifier, this.createHostPortMapper());
        } else {
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, hostName, Integer.parseInt(hostPort), connectTimeout, socketTimeout, userName, userPassword, 0, Platform.getProduct().getId(), useSSL, sslFactory, sslParameters, hostVerifier);
            this.jedisCluster = null;
        }
        this.initClientMethods();
        this.dialect = new RedisSQLDialect(this);
        this.executionContext = new RedisExecutionContext(this, "Main Redis Connection", null);
        ((RedisExecutionContext)this.executionContext).connect(monitor);
        SQLSyntaxManager commandSyntaxManager = new SQLSyntaxManager();
        commandSyntaxManager.init((DBPDataSource)this);
        SQLRuleManager ruleManager = new SQLRuleManager(commandSyntaxManager);
        ruleManager.loadRules((DBPDataSource)this, false);
        this.commandRuleManager = new TPRuleBasedScanner();
        this.commandRuleManager.setRules(ruleManager.getAllRules());
    }

    private JedisClusterHostAndPortMap createHostPortMapper() {
        if (this.tunnelConfig == null) {
            return RedisConstants.NULL_HOST_AND_PORT_MAP;
        }
        DBWHandlerConfiguration sshTunnelConfig = this.tunnelConfig;
        return (host, port) -> {
            String nodeId = String.valueOf(host) + ":" + port;
            DBPConnectionConfiguration tunnelConnectionConfig = this.nodeTunnelConfigs.get(host);
            if (tunnelConnectionConfig == null) {
                try {
                    DBWTunnel tunnelHandler = (DBWTunnel)sshTunnelConfig.createHandler(DBWTunnel.class);
                    this.nodeTunnels.add(tunnelHandler);
                    DBExecUtils.startContextInitiation((DBPDataSourceContainer)this.getContainer());
                    try {
                        tunnelConnectionConfig = tunnelHandler.initializeHandler((DBRProgressMonitor)new VoidProgressMonitor(), DBWorkbench.getPlatform(), sshTunnelConfig, this.getContainer().getActualConnectionConfiguration());
                        this.nodeTunnelConfigs.put(nodeId, tunnelConnectionConfig);
                    }
                    finally {
                        DBExecUtils.finishContextInitiation((DBPDataSourceContainer)this.getContainer());
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Can't initialize tunnel for cluster node [" + nodeId + "]"), (Throwable)e);
                }
            }
            if (tunnelConnectionConfig == null) {
                return null;
            }
            return new HostAndPort(tunnelConnectionConfig.getHostName(), Integer.parseInt(tunnelConnectionConfig.getHostPort()));
        };
    }

    public Map<String, Method[]> getCommandMethods() {
        return this.commandMethods;
    }

    public Method[] getCommandMethods(String command) {
        return this.commandMethods.get(command);
    }

    private void initClientMethods() {
        Method[] jedisMethods;
        Class clientClass = this.useCluster ? JedisCluster.class : Jedis.class;
        Method[] methodArray = jedisMethods = clientClass.getMethods();
        int n = jedisMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !method.isAnnotationPresent(Deprecated.class) && method.getReturnType() != byte[].class) {
                boolean hasBadParams = false;
                Class<?>[] classArray = method.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> paramType = classArray[n4];
                    if (paramType.isArray() && paramType.getComponentType() != String.class) {
                        hasBadParams = true;
                        break;
                    }
                    ++n4;
                }
                if (!hasBadParams) {
                    String commandName = method.getName().toLowerCase(Locale.ENGLISH);
                    Object[] methods = this.commandMethods.get(commandName);
                    methods = methods == null ? new Method[]{method} : (Method[])ArrayUtils.add(Method.class, (Object[])methods, (Object)method);
                    this.commandMethods.put(commandName, (Method[])methods);
                }
            }
            ++n2;
        }
    }

    public boolean isCommand(String command) {
        return this.commandMethods.containsKey(command);
    }

    public Object acquireClient() {
        if (this.jedisPool != null) {
            SSLHandlerTrustStoreImpl.setGlobalTrustStore((DBPDataSource)this.getDataSource());
            return this.jedisPool.getResource();
        }
        return this.jedisCluster;
    }

    public boolean isUseCluster() {
        return this.useCluster;
    }

    @Nullable
    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    @NotNull
    public <T> T acquireCommands(@NotNull Class<T> cmdClass) {
        if (this.jedisPool != null) {
            SSLHandlerTrustStoreImpl.setGlobalTrustStore((DBPDataSource)this.getDataSource());
            Jedis jedis = this.jedisPool.getResource();
            try {
                return cmdClass.cast(jedis);
            }
            catch (ClassCastException classCastException) {
                jedis.close();
                throw new IllegalArgumentException("Can't cast Jedis to command interface " + cmdClass.getName());
            }
        }
        if (this.jedisCluster != null) {
            try {
                return cmdClass.cast(this.jedisCluster);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Can't cast JedisCluster to command interface " + cmdClass.getName());
            }
        }
        throw new IllegalStateException("Not connected to Redis");
    }

    public <T> void releaseCommands(T cmd) {
        if (cmd instanceof Jedis) {
            ((Jedis)cmd).close();
        }
    }

    public RedisSQLDialect getSQLDialect() {
        return this.dialect;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new RedisDataSourceInfo(this);
        try {
            this.readDatabases();
        }
        catch (Exception e) {
            throw new DBException("Error initializing Redis connection", (Throwable)e);
        }
    }

    private void readDatabases() {
        this.databases = new ArrayList<RedisDatabase>();
        if (this.isUseCluster()) {
            RedisDatabase clusterDatabase = new RedisDatabase(this, "cluster", -1L);
            this.databases.add(clusterDatabase);
            ((RedisExecutionContext)this.executionContext).setDefaultDatabase(0);
        } else {
            BasicCommands commands = this.acquireCommands(BasicCommands.class);
            try {
                String keySpaceInfo = commands.info("keyspace");
                if (this.databases.isEmpty()) {
                    Map<String, Object> dbMap = RedisUtils.parseInfo(keySpaceInfo);
                    for (Map.Entry<String, Object> db : dbMap.entrySet()) {
                        String keys;
                        int divPos;
                        long keyNumber = -1L;
                        Optional<String> keysParam = Arrays.stream(CommonUtils.toString((Object)db.getValue()).split(",")).filter(s -> s.startsWith("keys=")).findFirst();
                        if (keysParam.isPresent() && (divPos = (keys = keysParam.get()).indexOf("=")) != -1) {
                            keyNumber = CommonUtils.toLong((Object)keys.substring(divPos + 1));
                        }
                        RedisDatabase database = new RedisDatabase(this, db.getKey(), keyNumber);
                        this.databases.add(database);
                    }
                }
                if (((RedisExecutionContext)this.executionContext).getDefaultDatabase() == null) {
                    ((RedisExecutionContext)this.executionContext).setDefaultDatabase(commands.getDB());
                }
            }
            finally {
                this.releaseCommands(commands);
            }
        }
    }

    @NotNull
    public RedisExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        RedisExecutionContext context = new RedisExecutionContext(this, purpose, initFrom instanceof RedisExecutionContext ? ((RedisExecutionContext)initFrom).getDefaultDatabase() : ((RedisExecutionContext)this.executionContext).getDefaultDatabase());
        context.connect(monitor);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        RedisDataSource redisDataSource = this;
        synchronized (redisDataSource) {
            for (DBWTunnel tunnel : this.nodeTunnels) {
                try {
                    tunnel.closeTunnel(monitor);
                }
                catch (Exception e) {
                    log.error((Object)"Error closing node tunnel", (Throwable)e);
                }
            }
            this.nodeTunnels.clear();
            if (this.jedisPool != null) {
                this.jedisPool.close();
            }
            if (this.jedisCluster != null) {
                this.jedisCluster.close();
            }
        }
    }

    @Association
    public List<RedisDatabase> getDatabases() {
        return this.databases;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) {
        return this.databases;
    }

    public RedisDatabase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) {
        return (RedisDatabase)DBUtils.findObject(this.databases, (String)childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return RedisDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) {
    }

    public String getKeyDivider() {
        String delimiter = this.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-redis.key.divider");
        if (!CommonUtils.isEmpty((String)delimiter)) {
            return delimiter;
        }
        return ":";
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.readDatabases();
        return this;
    }

    public synchronized String[] parseCommand(String query) {
        Document document = new Document(query);
        this.commandRuleManager.setRange((IDocument)document, 0, query.length());
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder part = new StringBuilder();
        while (true) {
            TPToken token;
            if ((token = this.commandRuleManager.nextToken()).isEOF() || token.isWhitespace()) {
                if (part.length() > 0) {
                    parts.add(part.toString());
                    part.setLength(0);
                }
                if (!token.isEOF()) continue;
                break;
            }
            try {
                String tokenText = document.get(this.commandRuleManager.getTokenOffset(), this.commandRuleManager.getTokenLength());
                part.append(tokenText);
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
            }
        }
        return parts.toArray(new String[0]);
    }

    public boolean isStatisticsCollected() {
        return true;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
    }
}

