/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.informix.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.informix.InformixUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class InformixMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(InformixMetaModel.class);

    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        return InformixUtils.getViewSource(monitor, (GenericTableBase)sourceObject);
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        return InformixUtils.getProcedureSource(monitor, sourceObject);
    }

    public String getTableDDL(DBRProgressMonitor monitor, GenericTableBase sourceObject, Map<String, Object> options) throws DBException {
        String tableDDL = super.getTableDDL(monitor, sourceObject, options);
        return String.valueOf(tableDDL) + InformixUtils.getTriggerDDL(monitor, sourceObject);
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    /*
     * Loose catch block
     */
    public List<? extends GenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        assert (table != null);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
                ArrayList<GenericTrigger> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block33: {
                    String query = "SELECT T1.trigname \nFROM informix.systriggers AS T1, informix.systables AS T2 \nWHERE T2.tabid = T1.tabid AND T2.tabname = ?";
                    throwable2 = null;
                    Object var9_13 = null;
                    dbStat = session.prepareStatement(query);
                    dbStat.setString(1, table.getName());
                    ArrayList<GenericTrigger> result = new ArrayList<GenericTrigger>();
                    Throwable throwable3 = null;
                    Object var13_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            if (name == null) continue;
                            name = name.trim();
                            GenericTrigger trigger = new GenericTrigger(container, table, name, null);
                            result.add(trigger);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block33;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public boolean supportsTableDDLSplit(GenericTableBase sourceObject) {
        return false;
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        GenericTableBase table = trigger.getTable();
        assert (table != null);
        return InformixUtils.getTriggerDDL(monitor, trigger);
    }

    public boolean hasFunctionSupport() {
        return false;
    }
}

