/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class MySQLGeometryValueHandler
extends GISGeometryValueHandler {
    public static final MySQLGeometryValueHandler INSTANCE = new MySQLGeometryValueHandler();

    public MySQLGeometryValueHandler() {
        super(true);
    }

    protected Geometry convertGeometryFromBinaryFormat(DBCSession session, byte[] object) throws DBCException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(object);){
                int srid = 0;
                srid |= is.read();
                srid |= is.read() << 8;
                srid |= is.read() << 16;
                Geometry geometry = new WKBReader().read((InStream)new InputStreamInStream((InputStream)is));
                geometry.setSRID(srid |= is.read() << 24);
                return geometry;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException("Error reading geometry from binary data", (Throwable)e);
        }
    }

    protected byte[] convertGeometryToBinaryFormat(DBCSession session, Geometry geometry) throws DBCException {
        int srid = geometry.getSRID();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                os.write((byte)srid);
                os.write((byte)(srid >> 8));
                os.write((byte)(srid >> 16));
                os.write((byte)(srid >> 24));
                WKBWriter writer = new WKBWriter(2, 2, false);
                writer.write(geometry, (OutStream)new OutputStreamOutStream((OutputStream)os));
                return os.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBCException("Error writing geometry to binary data", (Throwable)e);
        }
    }
}

