/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.util.Collection;
import java.util.TimeZone;
import ru.yandex.clickhouse.ClickHouseUtil;
import ru.yandex.clickhouse.util.ClickHouseValueFormatter;

public class ClickHouseArrayUtil {
    private ClickHouseArrayUtil() {
    }

    public static String arrayToString(Object object, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Object must be array");
        }
        if (object.getClass().getComponentType().isPrimitive()) {
            return ClickHouseArrayUtil.primitiveArrayToString(object);
        }
        return ClickHouseArrayUtil.toString((Object[])object, dateTimeZone, dateTimeTimeZone);
    }

    public static String toString(Object[] values, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
        if (values.length > 0 && values[0] != null && (values[0].getClass().isArray() || values[0] instanceof Collection)) {
            ArrayBuilder builder = new ArrayBuilder(false, dateTimeZone, dateTimeTimeZone);
            for (Object value : values) {
                if (value instanceof Collection) {
                    Object[] objects = ((Collection)value).toArray();
                    builder.append(ClickHouseArrayUtil.toString(objects, dateTimeZone, dateTimeTimeZone));
                    continue;
                }
                builder.append(ClickHouseArrayUtil.arrayToString(value, dateTimeZone, dateTimeTimeZone));
            }
            return builder.build();
        }
        ArrayBuilder builder = new ArrayBuilder(ClickHouseArrayUtil.needQuote(values), dateTimeZone, dateTimeTimeZone);
        for (Object value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    public static String toString(Collection<?> collection, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
        return ClickHouseArrayUtil.toString(collection.toArray(), dateTimeZone, dateTimeTimeZone);
    }

    @Deprecated
    static String toString(Collection<?> collection) {
        TimeZone tz = TimeZone.getDefault();
        return ClickHouseArrayUtil.toString(collection, tz, tz);
    }

    @Deprecated
    static String toString(Object[] values) {
        TimeZone tz = TimeZone.getDefault();
        return ClickHouseArrayUtil.toString(values, tz, tz);
    }

    @Deprecated
    static String arrayToString(Object object) {
        TimeZone tz = TimeZone.getDefault();
        return ClickHouseArrayUtil.arrayToString(object, tz, tz);
    }

    private static String primitiveArrayToString(Object array) {
        if (array instanceof int[]) {
            return ClickHouseArrayUtil.toString((int[])array);
        }
        if (array instanceof long[]) {
            return ClickHouseArrayUtil.toString((long[])array);
        }
        if (array instanceof float[]) {
            return ClickHouseArrayUtil.toString((float[])array);
        }
        if (array instanceof double[]) {
            return ClickHouseArrayUtil.toString((double[])array);
        }
        if (array instanceof char[]) {
            return ClickHouseArrayUtil.toString((char[])array);
        }
        if (array instanceof byte[]) {
            return ClickHouseArrayUtil.toString((byte[])array);
        }
        if (array instanceof short[]) {
            return ClickHouseArrayUtil.toString((short[])array);
        }
        throw new IllegalArgumentException("Wrong primitive type: " + array.getClass().getComponentType());
    }

    private static String toString(int[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (int value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    private static String toString(long[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (long value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    private static String toString(float[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (float value : values) {
            builder.append(Float.valueOf(value));
        }
        return builder.build();
    }

    private static String toString(double[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (double value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    private static String toString(byte[] values) {
        return "'" + ClickHouseValueFormatter.formatBytes(values) + "'";
    }

    private static String toString(short[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (short value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    private static String toString(char[] values) {
        ArrayBuilder builder = new ArrayBuilder(true);
        for (char value : values) {
            builder.append(Character.valueOf(value));
        }
        return builder.build();
    }

    private static boolean needQuote(Object[] objects) {
        Object o = null;
        for (Object u : objects) {
            if (u == null) continue;
            o = u;
            break;
        }
        return objects.length == 0 || ClickHouseValueFormatter.needsQuoting(o);
    }

    private static class ArrayBuilder {
        private final StringBuilder builder;
        private final boolean quote;
        private final TimeZone dateTimeZone;
        private final TimeZone dateTimeTimeZone;
        private int size = 0;
        private boolean built = false;

        private ArrayBuilder(boolean quote) {
            this(quote, TimeZone.getDefault(), TimeZone.getDefault());
        }

        private ArrayBuilder(boolean quote, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
            this.quote = quote;
            this.builder = new StringBuilder("[");
            this.dateTimeZone = dateTimeZone;
            this.dateTimeTimeZone = dateTimeTimeZone;
        }

        private ArrayBuilder append(Object value) {
            if (this.built) {
                throw new IllegalStateException("Already built");
            }
            if (this.size > 0) {
                this.builder.append(',');
            }
            if (value != null) {
                if (this.quote) {
                    this.builder.append('\'');
                }
                if (value instanceof String) {
                    this.builder.append(this.quote ? ClickHouseUtil.escape((String)value) : value);
                } else {
                    this.builder.append(ClickHouseValueFormatter.formatObject(value, this.dateTimeZone, this.dateTimeTimeZone));
                }
                if (this.quote) {
                    this.builder.append('\'');
                }
            } else {
                this.builder.append("NULL");
            }
            ++this.size;
            return this;
        }

        private String build() {
            if (!this.built) {
                this.builder.append(']');
                this.built = true;
            }
            return this.builder.toString();
        }
    }
}

