/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

import com.sybase.jdbc4.utils.CacheChunk;
import com.sybase.jdbc4.utils.CacheStream;
import com.sybase.jdbc4.utils.Cacheable;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class CacheManager {
    public static final boolean DEBUG = false;
    public static final boolean ASSERT = false;
    public static final int INFINITE_CACHING = -1;
    public static final int NO_CACHING = 0;
    public static final int DEFAULT_CHUNK_SIZE = 0;
    public static final String IO_CACHE_EXHAUSED = "IO_CACHE_EXHAUSED";
    public static final String IO_NOT_RESETABLE = "IO_NOT_RESETABLE";
    public static final String IO_CLOSED = "IO_CLOSED";
    public static final String IO_NOT_OPEN = "IO_NOT_OPEN";
    private static ResourceBundle _messages;
    protected Vector _colleagues;
    protected InputStream _is;
    protected int _maxCacheSize = -1;
    protected int _currentCacheSize = 0;
    protected int _chunkSize = 0;
    protected int _cacheTimeout = 0;
    protected boolean _reReadable = false;
    protected boolean _setable = true;
    protected boolean _abortOnCacheOverflow = false;
    protected Cacheable _current = null;
    protected CacheChunk _free = null;
    private boolean _resettingChunkSize = false;

    public CacheManager(InputStream inputStream) {
        this._is = inputStream;
        this._colleagues = new Vector();
    }

    public synchronized void setCacheSize(int n) {
        this._maxCacheSize = n;
    }

    public synchronized void setChunkSize(int n) {
        this._chunkSize = n;
        CacheChunk cacheChunk = this._free;
        this._free = null;
        this._resettingChunkSize = true;
        this.putChunks(cacheChunk);
        this._resettingChunkSize = false;
    }

    public synchronized void setCacheTimeout(int n) {
        this._cacheTimeout = n;
    }

    public synchronized void setReReadable(boolean bl) {
        this._reReadable = bl;
    }

    public synchronized void setSetable(boolean bl) {
        this._setable = bl;
    }

    public synchronized void setAbortOnCacheOverflow(boolean bl) {
        this._abortOnCacheOverflow = bl;
    }

    public synchronized void register(Cacheable cacheable) {
        cacheable.setManager(this);
        if (!this._colleagues.contains(cacheable)) {
            this._colleagues.addElement(cacheable);
        }
    }

    public void open(Cacheable cacheable) throws IOException {
        if (this._setable) {
            InputStream inputStream = this._is;
            if (this._reReadable) {
                inputStream = new CacheStream(this, inputStream, this._cacheTimeout);
            }
            cacheable.resetInputStream(inputStream);
        }
        this.beginReading(cacheable);
    }

    public synchronized void clear() throws IOException {
        if (this._colleagues != null) {
            for (int i = 0; i < this._colleagues.size(); ++i) {
                Cacheable cacheable = (Cacheable)this._colleagues.elementAt(i);
                cacheable.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginReading(Cacheable cacheable) throws IOException {
        while (true) {
            Cacheable cacheable2;
            Object object = this;
            synchronized (object) {
                if (this._current == null || this._current == cacheable) {
                    cacheable.open(this._reReadable);
                    this._current = cacheable;
                    return;
                }
                cacheable2 = this._current;
            }
            object = cacheable2;
            synchronized (object) {
                if (cacheable2 != this._current) {
                    continue;
                }
                int n = cacheable2.getState();
                if (n == 1 && this._setable) {
                    cacheable2.resetInputStream(new CacheStream(this, this._is, this._cacheTimeout));
                }
                if (n != 0) {
                    cacheable2.cache();
                }
            }
        }
    }

    public synchronized void doneReading() {
        this._current = null;
    }

    public synchronized void dead(Cacheable cacheable) {
        if (this._current == cacheable) {
            this._current = null;
        }
        this._colleagues.removeElement(cacheable);
    }

    public synchronized void allDead() {
        this._current = null;
        this._colleagues.removeAllElements();
    }

    protected synchronized CacheChunk getChunk(int n, int n2) throws IOException {
        CacheChunk cacheChunk;
        int n3;
        int n4 = n3 = n < this._chunkSize ? this._chunkSize : n;
        if (this._maxCacheSize >= 0 && this._maxCacheSize - this._currentCacheSize < n3) {
            if (this._abortOnCacheOverflow) {
                CacheManager.raiseIOException(IO_CACHE_EXHAUSED);
            } else {
                long l = System.currentTimeMillis();
                boolean bl = n2 == 0;
                while (true) {
                    try {
                        this.wait(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._maxCacheSize - this._currentCacheSize >= n3) break;
                    long l2 = System.currentTimeMillis();
                    if (!bl) {
                        n2 -= (int)(l2 - l);
                        l = l2;
                    }
                    if (n2 >= 0) continue;
                    CacheManager.raiseIOException(IO_CACHE_EXHAUSED);
                }
            }
        }
        if (n3 == this._chunkSize && this._free != null) {
            cacheChunk = this._free;
            this._free = this._free._next;
            cacheChunk._length = 0;
            cacheChunk._next = null;
        } else {
            byte[] byArray = new byte[n3];
            cacheChunk = new CacheChunk(byArray);
        }
        this._currentCacheSize += n3;
        return cacheChunk;
    }

    protected synchronized void putChunks(CacheChunk cacheChunk) {
        CacheChunk cacheChunk2 = null;
        CacheChunk cacheChunk3 = cacheChunk;
        while (cacheChunk3 != null) {
            cacheChunk2 = cacheChunk3._next;
            if (!this._resettingChunkSize) {
                this._currentCacheSize -= cacheChunk3._buf.length;
                this.notifyAll();
            }
            if (cacheChunk3._buf.length == this._chunkSize) {
                cacheChunk3._next = this._free;
                this._free = cacheChunk3;
            } else {
                cacheChunk3._next = null;
            }
            cacheChunk3 = cacheChunk2;
        }
    }

    protected static void raiseIOException(String string) throws IOException {
        if (string != null) {
            String string2;
            try {
                string2 = _messages.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = "Internal error, missing message for: " + string + " exception: " + missingResourceException.toString();
            }
            catch (ClassCastException classCastException) {
                string2 = "Internal error, missing message for: " + string + " exception: " + classCastException.toString();
            }
            throw new IOException(string2);
        }
    }

    static {
        if (ResourceBundle.getBundle("com.sybase.jdbc4.utils.resource.Messages") != null) {
            try {
                _messages = ResourceBundle.getBundle("com.sybase.jdbc4.utils.resource.Messages");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }
}

