/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.security.asn1;

import com.sybase.jdbc4.security.asn1.ASN1Object;
import com.sybase.jdbc4.security.asn1.ASN1OctetStringParser;
import com.sybase.jdbc4.security.asn1.ASN1Sequence;
import com.sybase.jdbc4.security.asn1.ASN1TaggedObject;
import com.sybase.jdbc4.security.asn1.BERConstructedOctetString;
import com.sybase.jdbc4.security.asn1.DEREncodable;
import com.sybase.jdbc4.security.asn1.DERObject;
import com.sybase.jdbc4.security.asn1.DEROutputStream;
import com.sybase.jdbc4.security.util.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ASN1OctetString
extends ASN1Object
implements ASN1OctetStringParser {
    byte[] string;

    public static ASN1OctetString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ASN1OctetString.getInstance(aSN1TaggedObject.getObject());
    }

    public static ASN1OctetString getInstance(Object object) {
        if (object == null || object instanceof ASN1OctetString) {
            return (ASN1OctetString)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        if (object instanceof ASN1Sequence) {
            Vector vector = new Vector();
            Enumeration enumeration = ((ASN1Sequence)object).getObjects();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            return new BERConstructedOctetString(vector);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public ASN1OctetString(byte[] byArray) {
        this.string = byArray;
    }

    public ASN1OctetString(DEREncodable dEREncodable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dEREncodable);
            dEROutputStream.close();
            this.string = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    @Override
    public InputStream getOctetStream() {
        return new ByteArrayInputStream(this.string);
    }

    public ASN1OctetStringParser parser() {
        return this;
    }

    public byte[] getOctets() {
        return this.string;
    }

    @Override
    public int hashCode() {
        byte[] byArray = this.getOctets();
        int n = 0;
        for (int i = 0; i != byArray.length; ++i) {
            n ^= (byArray[i] & 0xFF) << i % 4;
        }
        return n;
    }

    @Override
    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof ASN1OctetString)) {
            return false;
        }
        ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
        byte[] byArray = aSN1OctetString.string;
        byte[] byArray2 = this.string;
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return "#" + new String(Hex.encode(this.string));
    }
}

