/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LimiterInputStream;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybCursorResultSet;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybScrollCursorResultSet;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybCallableStatement
extends SybPreparedStatement
implements com.sybase.jdbcx.SybCallableStatement {
    private static final Logger LOG = Logger.getLogger(SybCallableStatement.class.getName());
    private static volatile long _logIdCounter = 0L;
    private AtomicLong _apiCounter = new AtomicLong(0L);
    protected boolean _hasOutParam = false;

    SybCallableStatement(String string, ProtocolContext protocolContext, String string2) throws SQLException {
        super(string, protocolContext, string2, 2);
        this._logId = string + "_Cs" + _logIdCounter++;
        this._sqlStr = string2;
        if (this._hasReturn) {
            this._paramMgr.doSetParam(1, -998, new Integer(0), 0);
            this._paramMgr.doRegisterParam(1, 4);
            this._returnHasBeenRegistered = false;
        }
    }

    SybCallableStatement(String string, ProtocolContext protocolContext, SybCallableStatement sybCallableStatement) throws SQLException {
        super(string, protocolContext, sybCallableStatement);
        this._logId = string + "_Cs" + _logIdCounter++;
        this._allowsOutputParms = sybCallableStatement._allowsOutputParms;
        this._rpcName = sybCallableStatement._rpcName;
        this._sendAsRpc = sybCallableStatement._sendAsRpc;
        this._hasReturn = sybCallableStatement._hasReturn;
        if (this._hasReturn) {
            this._paramMgr.doSetParam(1, -998, new Integer(0), 0);
            this._paramMgr.doRegisterParam(1, 4);
            this._returnHasBeenRegistered = false;
        }
    }

    @Override
    protected void setDoEscapes() {
        this._doEscapes = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        SybResultSet sybResultSet;
        block10: {
            long l;
            boolean bl;
            SybResultSet sybResultSet2;
            block6: {
                SybResultSet sybResultSet3;
                block9: {
                    block7: {
                        SybResultSet sybResultSet4;
                        block8: {
                            sybResultSet2 = null;
                            bl = LogUtil.isLoggingEnabled(LOG);
                            l = bl ? this._apiCounter.incrementAndGet() : 0L;
                            try {
                                if (bl) {
                                    LogUtil.logBegin(LOG, this._logId, l);
                                }
                                this.clearParams();
                                if (!this._sendAsRpc) break block6;
                                this.checkStatementAndTransaction(true);
                                if (!this.sendRpc(this._rpcName, this._paramMgr)) break block7;
                                sybResultSet4 = sybResultSet2 = (SybResultSet)this.queryLoop();
                                if (!bl) break block8;
                                LogUtil.logEnd(LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "executeQuery", null, null, l);
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    LogUtil.logEnd(LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "executeQuery", null, null, l);
                                }
                                throw throwable;
                            }
                        }
                        return sybResultSet4;
                    }
                    sybResultSet3 = sybResultSet2 = this._currentRS;
                    if (!bl) break block9;
                    LogUtil.logEnd(LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "executeQuery", null, null, l);
                }
                return sybResultSet3;
            }
            sybResultSet = sybResultSet2 = (SybResultSet)super.executeQuery(this._query, this._paramMgr);
            if (!bl) break block10;
            LogUtil.logEnd(LOG, "ResultSet", sybResultSet2 != null ? sybResultSet2._logId : "_", this._logId, "executeQuery", null, null, l);
        }
        return sybResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.clearParams();
            int n = -1;
            if (this._sendAsRpc) {
                this.checkStatementAndTransaction(true);
                if (this._cursor != null) {
                    ErrorMessage.raiseError("JZ0S3");
                }
                if (this.sendRpc(this._rpcName, this._paramMgr)) {
                    n = this.updateLoop();
                }
            } else {
                this.generateQuerySetByName();
                n = super.executeUpdate(this._query, this._paramMgr);
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "executeUpdate", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.clearParams();
            if (this._sendAsRpc) {
                this.checkStatementAndTransaction(true);
                if (this.sendRpc(this._rpcName, this._paramMgr)) {
                    boolean bl2 = this.executeLoop();
                    return bl2;
                }
                boolean bl3 = this._currentRS != null;
                return bl3;
            }
            this.generateQuerySetByName();
            boolean bl4 = super.execute(this._query, this._paramMgr);
            return bl4;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "execute", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._sendBatchParamsImmediate && (this._hasReturn || this._hasOutParam)) {
                ErrorMessage.raiseError("JZ0BP");
            }
            if (this._batchCmdsCount < 1) {
                this._query = this.handleCallBody(this._query);
            }
            this.generateQuerySetByName();
            super.addBatch();
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "addBatch", null, null, l);
            }
        }
    }

    private void generateQuerySetByName() {
        if (this._paramMgr._paramSetType == 1 && this._batchCmdsCount == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            for (int i = 0; i < this._query.length(); ++i) {
                if (this._query.charAt(i) == '?' && this._paramMgr._params.length > n && this._paramMgr._params[n]._paramMarkerOffset == i) {
                    int n2 = stringBuffer.lastIndexOf(",");
                    int n3 = stringBuffer.lastIndexOf("@");
                    if (n3 > n2) {
                        stringBuffer.delete(n3, stringBuffer.length());
                    }
                    stringBuffer.append(this._paramMgr._params[n]._name + "=");
                    this._paramMgr._params[n]._paramMarkerOffset = stringBuffer.length();
                    ++n;
                }
                stringBuffer.append(this._query.charAt(i));
            }
            this._query = stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._hasReturn || this._hasOutParam) {
                ErrorMessage.raiseError("JZ0BP");
            }
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "executeBatch", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkStatementAndTransaction(false);
            try {
                this._paramMgr.clearParams(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.cancel();
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "cancel", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkOutParamRegistration(n);
            this._paramMgr.registerParam(n, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{n, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{n, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this._paramMgr.registerParam(string, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{string, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{string, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkOutParamRegistration(n);
            this._paramMgr.registerParam(n, n2, n3);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{n, n2, n3}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{n, n2, n3}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this._paramMgr.registerParam(string, n, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{string, n, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{string, n, n2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this._paramMgr.registerParam(n, n2, string);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{n, n2, string}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{n, n2, string}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this._paramMgr.registerParam(string, n, string2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{string, n, string2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "registerOutParameter", null, new Object[]{string, n, string2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            boolean bl2 = this._paramMgr.wasNull();
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "wasNull", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n) throws SQLException {
        String string;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                string = this._paramMgr.getOutValueAt(n).getString();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getString", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getString", null, new Object[]{n}, l);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String string) throws SQLException {
        String string2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                string2 = this._paramMgr.getOutValueAt(string).getString();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getString", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getString", null, new Object[]{string}, l);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setString(String string, String string2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setParam(12, string, string2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setString", null, new Object[]{string, string2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setString", null, new Object[]{string, string2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n) throws SQLException {
        boolean bl;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bl = this._paramMgr.getOutValueAt(n).getBoolean();
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBoolean", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBoolean", null, new Object[]{n}, l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String string) throws SQLException {
        boolean bl;
        block4: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bl = this._paramMgr.getOutValueAt(string).getBoolean();
                if (!bl2) break block4;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBoolean", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBoolean", null, new Object[]{string}, l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        boolean bl2 = LogUtil.isLoggingEnabled(LOG);
        long l = bl2 ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl2) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setParam(-7, string, bl);
            if (!bl2) return;
        }
        catch (Throwable throwable) {
            if (!bl2) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "allTablesAreSelectable", null, new Object[]{string, bl}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "allTablesAreSelectable", null, new Object[]{string, bl}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n) throws SQLException {
        byte by;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                by = this._paramMgr.getOutValueAt(n).getByte();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getByte", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getByte", null, new Object[]{n}, l);
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String string) throws SQLException {
        byte by;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                by = this._paramMgr.getOutValueAt(string).getByte();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getByte", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getByte", null, new Object[]{string}, l);
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setByte(String string, byte by) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            Integer n;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if ((n = new Integer(by)) < 0) {
                this.setParam(5, string, n);
            } else {
                this.setParam(-6, string, n);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setByte", null, new Object[]{string, by}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setByte", null, new Object[]{string, by}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n) throws SQLException {
        short s;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                s = this._paramMgr.getOutValueAt(n).getShort();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getShort", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getShort", null, new Object[]{n}, l);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String string) throws SQLException {
        short s;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                s = this._paramMgr.getOutValueAt(string).getShort();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getShort", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getShort", null, new Object[]{string}, l);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setShort(String string, short s) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            Integer n = new Integer(s);
            this.setParam(5, string, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setShort", null, new Object[]{string, s}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setShort", null, new Object[]{string, s}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n) throws SQLException {
        int n2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                n2 = this._paramMgr.getOutValueAt(n).getInt();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getInt", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getInt", null, new Object[]{n}, l);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String string) throws SQLException {
        int n;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                n = this._paramMgr.getOutValueAt(string).getInt();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getInt", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getInt", null, new Object[]{string}, l);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInt(String string, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            Integer n2 = new Integer(n);
            this.setParam(4, string, n2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setInt", null, new Object[]{string, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setInt", null, new Object[]{string, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n) throws SQLException {
        long l;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                l = this._paramMgr.getOutValueAt(n).getLong();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getLong", null, new Object[]{n}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getLong", null, new Object[]{n}, l2);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String string) throws SQLException {
        long l;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                l = this._paramMgr.getOutValueAt(string).getLong();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getLong", null, new Object[]{string}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getLong", null, new Object[]{string}, l2);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setLong(String string, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            Long l3 = new Long(l);
            this.setParam(-5, string, l3);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setLong", null, new Object[]{string, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setLong", null, new Object[]{string, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n) throws SQLException {
        float f;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                f = this._paramMgr.getOutValueAt(n).getFloat();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getFloat", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getFloat", null, new Object[]{n}, l);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String string) throws SQLException {
        float f;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                f = this._paramMgr.getOutValueAt(string).getFloat();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getFloat", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getFloat", null, new Object[]{string}, l);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFloat(String string, float f) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            Float f2 = new Float(f);
            this.setParam(7, string, f2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setFloat", null, new Object[]{string, Float.valueOf(f)}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setFloat", null, new Object[]{string, Float.valueOf(f)}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n) throws SQLException {
        double d;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                d = this._paramMgr.getOutValueAt(n).getDouble();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDouble", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDouble", null, new Object[]{n}, l);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String string) throws SQLException {
        double d;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                d = this._paramMgr.getOutValueAt(string).getDouble();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDouble", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDouble", null, new Object[]{string}, l);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDouble(String string, double d) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            Double d2 = new Double(d);
            this.setParam(8, string, d2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setDouble", null, new Object[]{string, d}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setDouble", null, new Object[]{string, d}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bigDecimal = this._paramMgr.getOutValueAt(n).getBigDecimal(n2);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", null, new Object[]{n, n2}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", null, new Object[]{n, n2}, l);
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bigDecimal = this.getBigDecimal(n, -1);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", null, new Object[]{n}, l);
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        BigDecimal bigDecimal;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                bigDecimal = this._paramMgr.getOutValueAt(string).getBigDecimal(-1);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBigDecimal", null, new Object[]{string}, l);
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (bigDecimal == null) {
                this.setNull(string, 2);
            } else {
                this.setParam(2, string, (Object)bigDecimal, bigDecimal.scale());
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBigDecimal", null, new Object[]{string, bigDecimal}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBigDecimal", null, new Object[]{string, bigDecimal}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                byArray = this._paramMgr.getOutValueAt(n).getBytes();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", null, new Object[]{n}, l);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String string) throws SQLException {
        byte[] byArray;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                byArray = this._paramMgr.getOutValueAt(string).getBytes();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", null, new Object[]{string}, l);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            int n = 0;
            if (byArray != null) {
                n = byArray.length;
            }
            if (n > 255) {
                this.setParam(-4, string, byArray);
            } else {
                this.setParam(-3, string, byArray);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", null, new Object[]{string, byArray}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", null, new Object[]{string, byArray}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n) throws SQLException {
        Date date;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                date = Convert.objectToDate(this._paramMgr.getOutValueAt(n).getDateObject(91, null), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDate", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDate", null, new Object[]{n}, l);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String string) throws SQLException {
        Date date;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                date = Convert.objectToDate(this._paramMgr.getOutValueAt(string).getDateObject(91, null), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDate", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDate", null, new Object[]{string}, l);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDate(String string, Date date) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (date == null) {
                this.setParam(91, string, date);
            } else {
                this.setParam(91, string, new DateObject((Object)date, 91));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setDate", null, new Object[]{string, date}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setDate", null, new Object[]{string, date}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            Time time = Convert.objectToTime(this._paramMgr.getOutValueAt(n).getDateObject(92, null), null);
            return time;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "allTablesAreSelectable", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string) throws SQLException {
        Time time;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                time = Convert.objectToTime(this._paramMgr.getOutValueAt(string).getDateObject(92, null), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTime", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTime", null, new Object[]{string}, l);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTime(String string, Time time) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (time == null) {
                this.setParam(92, string, time);
            } else {
                this.setParam(92, string, new DateObject((Object)time, 92));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setTime", null, new Object[]{string, time}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setTime", null, new Object[]{string, time}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                timestamp = Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n).getDateObject(93, null), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", null, new Object[]{n}, l);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        Timestamp timestamp;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                timestamp = Convert.objectToTimestamp(this._paramMgr.getOutValueAt(string).getDateObject(93, null), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", null, new Object[]{string}, l);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (timestamp == null) {
                this.setParam(93, string, timestamp);
            } else {
                this.setParam(93, string, new DateObject((Object)timestamp, 93));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setTimestamp", null, new Object[]{string, timestamp}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setTimestamp", null, new Object[]{string, timestamp}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n) throws SQLException {
        Object object;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                object = this._paramMgr.getOutObjectAt(n);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getObject", null, new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getObject", null, new Object[]{n}, l);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String string) throws SQLException {
        Object object;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                object = this._paramMgr.getOutObjectAt(string);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getObject", null, new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getObject", null, new Object[]{string}, l);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(String string, Object object) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (object == null) {
                ErrorMessage.raiseError("JZ0SE");
            }
            if (object instanceof Short) {
                this.setShort(string, (short)((Short)object));
            } else if (object instanceof Byte) {
                this.setByte(string, (byte)((Byte)object));
            } else if (object instanceof String) {
                this.setString(string, (String)object);
            } else if (object instanceof BigDecimal) {
                this.setBigDecimal(string, (BigDecimal)object);
            } else if (object instanceof Boolean) {
                this.setParam(-7, string, object);
            } else if (object instanceof Integer) {
                this.setParam(4, string, object);
            } else if (object instanceof Long) {
                this.setParam(-5, string, object);
            } else if (object instanceof Float) {
                this.setParam(7, string, object);
            } else if (object instanceof Double) {
                this.setParam(8, string, object);
            } else if (object instanceof byte[]) {
                this.setBytes(string, (byte[])object);
            } else if (object instanceof Date) {
                this.setDate(string, (Date)object);
            } else if (object instanceof Time) {
                this.setTime(string, (Time)object);
            } else if (object instanceof Timestamp) {
                this.setTimestamp(string, (Timestamp)object);
            } else if (object instanceof Serializable) {
                this.setParam(2000, string, object);
            } else {
                ErrorMessage.raiseError("JZ0SE");
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setObject", null, new Object[]{string, object}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setObject", null, new Object[]{string, object}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setObject(string, object, n, 0);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setObject", null, new Object[]{string, object, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setObject", null, new Object[]{string, object, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (object == null) {
                this.setParam(n, string, null, n2);
            }
            switch (n) {
                case -7: {
                    this.setParam(n, string, (Object)Convert.objectToBoolean(object), n2);
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    this.setParam(n, string, (Object)Convert.objectToInt(object), n2);
                    break;
                }
                case -5: {
                    this.setParam(n, string, (Object)Convert.objectToLong(object), n2);
                    break;
                }
                case 1: 
                case 12: {
                    this.setString(string, Convert.objectToString(object));
                    break;
                }
                case -15: 
                case -9: {
                    this.setNString(string, Convert.objectToString(object));
                    break;
                }
                case -1: {
                    this.setParam(-1, string, Convert.objectToString(object));
                    break;
                }
                case 2: 
                case 3: {
                    if (n2 < 0) {
                        ErrorMessage.raiseError("JZ00I");
                    }
                    this.setParam(n, string, (Object)Convert.objectToBigDecimal(object), n2);
                    break;
                }
                case 7: {
                    this.setParam(n, string, (Object)Convert.objectToFloat(object), n2);
                    break;
                }
                case 6: 
                case 8: {
                    this.setParam(n, string, (Object)Convert.objectToDouble(object), n2);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.setBytes(string, Convert.objectToBytes(object));
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    this.setParam(n, string, (Object)Convert.objectToDateObject(object, n, null, null), n2);
                    break;
                }
                case 1111: 
                case 2000: {
                    if (object instanceof Serializable || object == null) {
                        this.setParam(2000, string, object);
                        break;
                    }
                }
                default: {
                    ErrorMessage.raiseError("JZ0SE");
                }
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setObject", null, new Object[]{string, object, n, n2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setObject", null, new Object[]{string, object, n, n2}, l);
    }

    public boolean sendRpc(String string, ParamManager paramManager) throws SQLException {
        try {
            if (this._rsConcur == -9) {
                this._rsConcur = 1007;
            }
            if (this._rsConcur == 1008) {
                this.checkCursor(false, 1008);
            }
            if (this._cursor != null) {
                ProtocolResultSet protocolResultSet = this._cursor.open(string, paramManager, true);
                protocolResultSet.setType(this._rsType);
                this._currentRS = this._cursor.scrollingAtServer() ? new SybScrollCursorResultSet(this._logId, this, protocolResultSet) : new SybCursorResultSet(this._logId, this, protocolResultSet);
                this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
                this._state = IConstants.CONNECTION_STATE.BUSY;
                return false;
            }
            this._protocol.rpc(this._context, string, paramManager);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return true;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        Debug.notSupported(this, "getBlob(String)");
        return null;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        Debug.notSupported(this, "getClob(String)");
        return null;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                date = Convert.objectToDate(this._paramMgr.getOutValueAt(n).getDateObject(91, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "int, Calendar", new Object[]{n, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "int, Calendar", new Object[]{n, calendar}, l);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        Date date;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                date = Convert.objectToDate(this._paramMgr.getOutValueAt(string).getDateObject(91, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "String, Calendar", new Object[]{string, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getDate", "String, Calendar", new Object[]{string, calendar}, l);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (date == null) {
                this.setParam(91, string, date);
            } else {
                this.setParam(91, string, new DateObject(date, calendar, 91));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setDate", "String, java.sql.Date, Calendar", new Object[]{string, date, calendar}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setDate", "String, java.sql.Date, Calendar", new Object[]{string, date, calendar}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                time = Convert.objectToTime(this._paramMgr.getOutValueAt(n).getDateObject(92, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "int, Calendar", new Object[]{n, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "int, Calendar", new Object[]{n, calendar}, l);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        Time time;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                time = Convert.objectToTime(this._paramMgr.getOutValueAt(string).getDateObject(92, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "String, Calendar", new Object[]{string, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTime", "String, Calendar", new Object[]{string, calendar}, l);
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (time == null) {
                this.setParam(92, string, time);
            } else {
                this.setParam(92, string, new DateObject(time, calendar, 92));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setTime", "String, java.sql.Time, Calendar", new Object[]{string, time, calendar}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setTime", "String, java.sql.Time, Calendar", new Object[]{string, time, calendar}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                timestamp = Convert.objectToTimestamp(this._paramMgr.getOutValueAt(n).getDateObject(93, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "int, Calendar", new Object[]{n, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "int, Calendar", new Object[]{n, calendar}, l);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                timestamp = Convert.objectToTimestamp(this._paramMgr.getOutValueAt(string).getDateObject(93, calendar), null);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "String, Calendar", new Object[]{string, calendar}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getTimestamp", "String, Calendar", new Object[]{string, calendar}, l);
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (timestamp == null) {
                this.setParam(93, string, timestamp);
            } else {
                this.setParam(93, string, new DateObject(timestamp, calendar, 93));
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setTimestamp", "String, java.sql.Timestamp, Calendar", new Object[]{string, timestamp, calendar}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setTimestamp", "String, java.sql.Timestamp, Calendar", new Object[]{string, timestamp, calendar}, l);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        Debug.notSupported(this, "getURL(int)");
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        Debug.notSupported(this, "getURL(String)");
        return null;
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        Debug.notSupported(this, "setURL(String, URL)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (inputStream == null) {
                this.setNull(string, -1);
            } else {
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n), "ISO8859_1");
                    String string2 = this._paramMgr.drainReader(inputStreamReader, n);
                    if (string2 != null) {
                        this.setParam(12, string, (Object)string2, 0);
                    } else {
                        this.setParam(-1, string, (Object)inputStreamReader, n);
                    }
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "String, InputStream, int", new Object[]{string, inputStream, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "String, InputStream, int", new Object[]{string, inputStream, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            byte[] byArray;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if ((byArray = this._paramMgr.drainStreams(inputStream, n)) != null) {
                this.setBytes(string, byArray);
            } else {
                this.setParam(-4, string, (Object)inputStream, n);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "String, InputStream, int", new Object[]{string, inputStream, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "String, InputStream, int", new Object[]{string, inputStream, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            String string2;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if ((string2 = this._paramMgr.drainReader(reader, n)) != null) {
                this.setParam(12, string, (Object)string2, 0);
            } else {
                this.setParam(-1, string, (Object)reader, n);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "String, Reader, int", new Object[]{string, reader, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "String, Reader, int", new Object[]{string, reader, n}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNull(String string, int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setParam(n, string, null);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNull", "String, int", new Object[]{string, n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNull", "String, int", new Object[]{string, n}, l);
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        Debug.notImplemented(this, "setNull(String, int, String)");
    }

    public void clearParams() throws SQLException {
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    @Override
    protected void handleParam(ParamManager paramManager) throws SQLException {
        if (this._batchCmds == null) {
            this._paramMgr.getParameter();
        } else {
            paramManager.getParameter();
        }
    }

    private void checkOutParamRegistration(int n) throws SQLException {
        if (!this._allowsOutputParms) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(n));
        }
    }

    @Override
    public void setParameterName(int n, String string) {
        Param[] paramArray = this._paramMgr.getParams();
        if (paramArray.length >= n && n > 0) {
            paramArray[n - 1]._name = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._type != 1) {
                ParameterMetaData parameterMetaData = super.getParameterMetaData();
                return parameterMetaData;
            }
            if (this._dbmda == null) {
                this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
            }
            if (this._dbmda.getDatabaseProductName().indexOf("Anywhere") != -1) {
                ParameterMetaData parameterMetaData = null;
                return parameterMetaData;
            }
            SybCallableStatement sybCallableStatement = new SybCallableStatement(this._logId, this._context, "{call sp_jdbc_getprocedurecolumns (@sp_name=?, @parammetadata=1, @paramcolids=?, @paramnames=?)}");
            if (this._paramMgr.getParamSetType() == 1) {
                this._paramNames = this._paramMgr.getColumnNames();
                this._paramColids = this._hasReturn ? "0" : null;
            }
            sybCallableStatement.setString(1, this._rpcName);
            sybCallableStatement.setString(2, this._paramColids);
            sybCallableStatement.setString(3, this._paramNames);
            ResultSet resultSet = sybCallableStatement.executeQuery();
            this._paramMgr.setParamMd(resultSet);
            SybCallableStatement sybCallableStatement2 = this;
            return sybCallableStatement2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, "ParameterMetaData", this._logId, this._logId, "getParameterMetaData", null, null, l);
            }
        }
    }

    private void setParam(int n, String string, Object object) throws SQLException {
        this.setParam(n, string, object, 0);
    }

    private void setParam(int n, String string, Object object, int n2) throws SQLException {
        this._paramMgr.setParam(string, n, object, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        Reader reader;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                reader = this._paramMgr.getOutValueAt(n).getCharacterStream();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "int", new Object[]{n}, l);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        Reader reader;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                reader = this._paramMgr.getOutValueAt(string).getCharacterStream();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "String", new Object[]{string}, l);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        Reader reader;
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            reader = this._paramMgr.getOutValueAt(n).getCharacterStream();
        }
        catch (Throwable throwable) {
            LogUtil.logEnd(LOG, null, null, this._logId, "getNCharacterStream", "int", new Object[]{n}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "getNCharacterStream", "int", new Object[]{n}, l);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        Reader reader;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                reader = this._paramMgr.getOutValueAt(string).getCharacterStream();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getNCharacterStream", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getNCharacterStream", "String", new Object[]{string}, l);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n) throws SQLException {
        String string;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                string = this._paramMgr.getOutValueAt(n).getString();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getNString", "int", new Object[]{n}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getNString", "int", new Object[]{n}, l);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(String string) throws SQLException {
        String string2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCounter.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                string2 = this._paramMgr.getOutValueAt(string).getString();
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getNString", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getNString", "String", new Object[]{string}, l);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNString(String string, String string2) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setParam(-9, string, string2);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNString", "String, String", new Object[]{string, string2}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNString", "String, String", new Object[]{string, string2}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setParam(-16, string, (Object)reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNCharacterStream", "String, Reader", new Object[]{string, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNCharacterStream", "String, Reader", new Object[]{string, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            int n = this.checkLongLength(l);
            this.setParam(-16, string, (Object)reader, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setNCharacterStream", "String, Reader, long", new Object[]{string, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setNCharacterStream", "String, Reader, long", new Object[]{string, reader, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setAsciiStream(string, inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "String, InputStream", new Object[]{string, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "String, InputStream", new Object[]{string, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            if (inputStream == null) {
                this.setNull(string, -1);
            } else {
                int n = this.checkLongLength(l);
                this.setAsciiStream(string, inputStream, n);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setBinaryStream(string, inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "String, InputStream", new Object[]{string, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "String, InputStream", new Object[]{string, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            int n = this.checkLongLength(l);
            this.setBinaryStream(string, inputStream, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBinaryStream", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setCharacterStream(string, reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "String, Reader", new Object[]{string, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "String, Reader", new Object[]{string, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            int n = this.checkLongLength(l);
            this.setCharacterStream(string, reader, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "String, Reader, long", new Object[]{string, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "String, Reader, long", new Object[]{string, reader, l}, l2);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        Debug.notImplemented(this, "public RowId getRowId(int arg0)");
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        Debug.notImplemented(this, "public RowId getRowId(String arg0)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        Debug.notImplemented(this, "public SQLXML getSQLXML(int arg0)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        Debug.notImplemented(this, "public SQLXML getSQLXML(String arg0)");
        return null;
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        Debug.notImplemented(this, "public void setBlob(String arg0, Blob arg1)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setParam(-4, string, (Object)inputStream, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "String, InputStream", new Object[]{string, inputStream}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "String, InputStream", new Object[]{string, inputStream}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            if (l < -1L) {
                ErrorMessage.raiseError("JZ039");
            }
            int n = this.checkLongLength(l);
            this.setParam(-4, string, (Object)inputStream, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setBlob", "String, InputStream, long", new Object[]{string, inputStream, l}, l2);
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        Debug.notImplemented(this, "public void setClob(String arg0, Clob arg1)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.setParam(-1, string, (Object)reader, -1);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "String, Reader", new Object[]{string, reader}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "String, Reader", new Object[]{string, reader}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCounter.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            if (l < -1L) {
                ErrorMessage.raiseError("JZ039");
            }
            int n = this.checkLongLength(l);
            this.setParam(-1, string, (Object)reader, n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "String, Reader, long", new Object[]{string, reader, l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setClob", "String, Reader, long", new Object[]{string, reader, l}, l2);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, NClob)");
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, Reader)");
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "setNClob(String, Reader, long)");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        Debug.notImplemented(this, "public void setRowId(String arg0, RowId arg1)");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        Debug.notImplemented(this, "public void setSQLXML(String arg0, SQLXML arg1)");
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        Debug.notImplemented(this, "public Object getObject(int arg0, Map<String, Class<?>> arg1)");
        return null;
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        Debug.notImplemented(this, "public Object getObject(String arg0, Map<String, Class<?>> arg1)");
        return null;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(int)");
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(String)");
        return null;
    }
}

