/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class ClientRetry
extends ClientBase {
    public void setUp() throws Exception {
        this.maxCnxns = 1;
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientRetry() throws IOException, InterruptedException, TimeoutException {
        ClientBase.CountdownWatcher cdw1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher cdw2 = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.hostPort, 10000, cdw1);
        try {
            cdw1.waitForConnected(CONNECTION_TIMEOUT);
            ZooKeeper zk2 = new ZooKeeper(this.hostPort, 10000, cdw2);
            try {
                ZooKeeper.States s1 = zk.getState();
                ZooKeeper.States s2 = zk2.getState();
                Assert.assertSame((Object)((Object)s1), (Object)((Object)ZooKeeper.States.CONNECTED));
                Assert.assertSame((Object)((Object)s2), (Object)((Object)ZooKeeper.States.CONNECTING));
                cdw1.reset();
                cdw1.waitForDisconnected(CONNECTION_TIMEOUT);
                cdw2.waitForConnected(CONNECTION_TIMEOUT);
                Assert.assertSame((Object)((Object)zk2.getState()), (Object)((Object)ZooKeeper.States.CONNECTED));
            }
            finally {
                zk2.close();
            }
        }
        finally {
            zk.close();
        }
    }
}

