/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.ganglia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.apache.hadoop.metrics.spi.Util;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class GangliaContext
extends AbstractMetricsContext {
    private static final String PERIOD_PROPERTY = "period";
    private static final String SERVERS_PROPERTY = "servers";
    private static final String UNITS_PROPERTY = "units";
    private static final String SLOPE_PROPERTY = "slope";
    private static final String TMAX_PROPERTY = "tmax";
    private static final String DMAX_PROPERTY = "dmax";
    private static final String MULTICAST_PROPERTY = "multicast";
    private static final String MULTICAST_TTL_PROPERTY = "multicast.ttl";
    private static final String DEFAULT_UNITS = "";
    private static final String DEFAULT_SLOPE = "both";
    private static final int DEFAULT_TMAX = 60;
    private static final int DEFAULT_DMAX = 0;
    private static final int DEFAULT_PORT = 8649;
    private static final int BUFFER_SIZE = 1500;
    private static final int DEFAULT_MULTICAST_TTL = 1;
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final Map<Class, String> typeTable = new HashMap<Class, String>(5);
    protected byte[] buffer = new byte[1500];
    protected int offset;
    protected List<? extends SocketAddress> metricsServers;
    private Map<String, String> unitsTable;
    private Map<String, String> slopeTable;
    private Map<String, String> tmaxTable;
    private Map<String, String> dmaxTable;
    private boolean multicastEnabled;
    private int multicastTtl;
    protected DatagramSocket datagramSocket;

    @InterfaceAudience.Private
    public GangliaContext() {
    }

    @Override
    @InterfaceAudience.Private
    public void init(String contextName, ContextFactory factory) {
        super.init(contextName, factory);
        this.parseAndSetPeriod(PERIOD_PROPERTY);
        this.metricsServers = Util.parse(this.getAttribute(SERVERS_PROPERTY), 8649);
        this.unitsTable = this.getAttributeTable(UNITS_PROPERTY);
        this.slopeTable = this.getAttributeTable(SLOPE_PROPERTY);
        this.tmaxTable = this.getAttributeTable(TMAX_PROPERTY);
        this.dmaxTable = this.getAttributeTable(DMAX_PROPERTY);
        this.multicastEnabled = Boolean.parseBoolean(this.getAttribute(MULTICAST_PROPERTY));
        String multicastTtlValue = this.getAttribute(MULTICAST_TTL_PROPERTY);
        if (this.multicastEnabled) {
            this.multicastTtl = multicastTtlValue == null ? 1 : Integer.parseInt(multicastTtlValue);
        }
        try {
            if (this.multicastEnabled) {
                this.LOG.info("Enabling multicast for Ganglia with TTL " + this.multicastTtl);
                this.datagramSocket = new MulticastSocket();
                ((MulticastSocket)this.datagramSocket).setTimeToLive(this.multicastTtl);
            } else {
                this.datagramSocket = new DatagramSocket();
            }
        }
        catch (IOException e) {
            this.LOG.error(e);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.datagramSocket != null) {
            this.datagramSocket.close();
        }
    }

    @Override
    @InterfaceAudience.Private
    public void emitRecord(String contextName, String recordName, OutputRecord outRec) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(contextName);
        sb.append('.');
        if (contextName.equals("jvm") && outRec.getTag("processName") != null) {
            sb.append(outRec.getTag("processName"));
            sb.append('.');
        }
        sb.append(recordName);
        sb.append('.');
        int sbBaseLen = sb.length();
        for (String metricName : outRec.getMetricNames()) {
            Number metric = outRec.getMetric(metricName);
            String type = typeTable.get(metric.getClass());
            if (type != null) {
                sb.append(metricName);
                this.emitMetric(sb.toString(), type, metric.toString());
                sb.setLength(sbBaseLen);
                continue;
            }
            this.LOG.warn("Unknown metrics type: " + metric.getClass());
        }
    }

    protected void emitMetric(String name, String type, String value) throws IOException {
        String units = this.getUnits(name);
        int slope = this.getSlope(name);
        int tmax = this.getTmax(name);
        int dmax = this.getDmax(name);
        this.offset = 0;
        this.xdr_int(0);
        this.xdr_string(type);
        this.xdr_string(name);
        this.xdr_string(value);
        this.xdr_string(units);
        this.xdr_int(slope);
        this.xdr_int(tmax);
        this.xdr_int(dmax);
        for (SocketAddress socketAddress : this.metricsServers) {
            DatagramPacket packet = new DatagramPacket(this.buffer, this.offset, socketAddress);
            this.datagramSocket.send(packet);
        }
    }

    protected String getUnits(String metricName) {
        String result = this.unitsTable.get(metricName);
        if (result == null) {
            result = DEFAULT_UNITS;
        }
        return result;
    }

    protected int getSlope(String metricName) {
        String slopeString = this.slopeTable.get(metricName);
        if (slopeString == null) {
            slopeString = DEFAULT_SLOPE;
        }
        return "zero".equals(slopeString) ? 0 : 3;
    }

    protected int getTmax(String metricName) {
        if (this.tmaxTable == null) {
            return 60;
        }
        String tmaxString = this.tmaxTable.get(metricName);
        if (tmaxString == null) {
            return 60;
        }
        return Integer.parseInt(tmaxString);
    }

    protected int getDmax(String metricName) {
        String dmaxString = this.dmaxTable.get(metricName);
        if (dmaxString == null) {
            return 0;
        }
        return Integer.parseInt(dmaxString);
    }

    protected void xdr_string(String s) {
        byte[] bytes = s.getBytes(Charsets.UTF_8);
        int len = bytes.length;
        this.xdr_int(len);
        System.arraycopy(bytes, 0, this.buffer, this.offset, len);
        this.offset += len;
        this.pad();
    }

    private void pad() {
        int newOffset = (this.offset + 3) / 4 * 4;
        while (this.offset < newOffset) {
            this.buffer[this.offset++] = 0;
        }
    }

    protected void xdr_int(int i) {
        this.buffer[this.offset++] = (byte)(i >> 24 & 0xFF);
        this.buffer[this.offset++] = (byte)(i >> 16 & 0xFF);
        this.buffer[this.offset++] = (byte)(i >> 8 & 0xFF);
        this.buffer[this.offset++] = (byte)(i & 0xFF);
    }

    static {
        typeTable.put(String.class, "string");
        typeTable.put(Byte.class, "int8");
        typeTable.put(Short.class, "int16");
        typeTable.put(Integer.class, "int32");
        typeTable.put(Long.class, "float");
        typeTable.put(Float.class, "float");
    }
}

