/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.hadoop.hive.common.metrics.MetricsMBean;
import org.apache.hadoop.hive.common.metrics.MetricsMBeanImpl;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.conf.HiveConf;

public class LegacyMetrics
implements Metrics {
    private static final MetricsMBean metrics = new MetricsMBeanImpl();
    private static final ObjectName oname;
    private static final ThreadLocal<HashMap<String, LegacyMetricsScope>> threadLocalScopes;

    private LegacyMetrics() {
    }

    public LegacyMetrics(HiveConf conf) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        mbs.registerMBean(metrics, oname);
    }

    @Override
    public Long incrementCounter(String name) throws IOException {
        return this.incrementCounter(name, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrementCounter(String name, long increment) throws IOException {
        Long value;
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            if (!metrics.hasKey(name)) {
                value = increment;
                this.set(name, value);
            } else {
                value = (Long)this.get(name) + increment;
                this.set(name, value);
            }
        }
        return value;
    }

    @Override
    public Long decrementCounter(String name) throws IOException {
        return this.decrementCounter(name, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrementCounter(String name, long decrement) throws IOException {
        Long value;
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            if (!metrics.hasKey(name)) {
                value = decrement;
                this.set(name, -value.longValue());
            } else {
                value = (Long)this.get(name) - decrement;
                this.set(name, value);
            }
        }
        return value;
    }

    @Override
    public void addGauge(String name, MetricsVariable variable) {
    }

    public void set(String name, Object value) throws IOException {
        metrics.put(name, value);
    }

    public Object get(String name) throws IOException {
        return metrics.get(name);
    }

    @Override
    public void startStoredScope(String name) throws IOException {
        if (threadLocalScopes.get().containsKey(name)) {
            threadLocalScopes.get().get(name).open();
        } else {
            threadLocalScopes.get().put(name, new LegacyMetricsScope(name, this));
        }
    }

    public MetricsScope getStoredScope(String name) throws IOException {
        if (threadLocalScopes.get().containsKey(name)) {
            return threadLocalScopes.get().get(name);
        }
        throw new IOException("No metrics scope named " + name);
    }

    @Override
    public void endStoredScope(String name) throws IOException {
        if (threadLocalScopes.get().containsKey(name)) {
            threadLocalScopes.get().get(name).close();
        }
    }

    @Override
    public MetricsScope createScope(String name) throws IOException {
        return new LegacyMetricsScope(name, this);
    }

    @Override
    public void endScope(MetricsScope scope) throws IOException {
        ((LegacyMetricsScope)scope).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(oname)) {
                mbs.unregisterMBean(oname);
            }
            metrics.clear();
            threadLocalScopes.remove();
        }
    }

    static {
        try {
            oname = new ObjectName("org.apache.hadoop.hive.common.metrics:type=MetricsMBean");
        }
        catch (MalformedObjectNameException mone) {
            throw new RuntimeException(mone);
        }
        threadLocalScopes = new ThreadLocal<HashMap<String, LegacyMetricsScope>>(){

            @Override
            protected HashMap<String, LegacyMetricsScope> initialValue() {
                return new HashMap<String, LegacyMetricsScope>();
            }
        };
    }

    public static class LegacyMetricsScope
    implements MetricsScope {
        final LegacyMetrics metrics;
        final String name;
        final String numCounter;
        final String timeCounter;
        final String avgTimeCounter;
        private boolean isOpen = false;
        private Long startTime = null;

        private LegacyMetricsScope(String name, LegacyMetrics metrics) throws IOException {
            this.metrics = metrics;
            this.name = name;
            this.numCounter = name + ".n";
            this.timeCounter = name + ".t";
            this.avgTimeCounter = name + ".avg_t";
            this.open();
        }

        public Long getNumCounter() throws IOException {
            return (Long)this.metrics.get(this.numCounter);
        }

        public Long getTimeCounter() throws IOException {
            return (Long)this.metrics.get(this.timeCounter);
        }

        public void open() throws IOException {
            if (this.isOpen) {
                throw new IOException("Scope named " + this.name + " is not closed, cannot be opened.");
            }
            this.isOpen = true;
            this.startTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.isOpen) {
                Long endTime = System.currentTimeMillis();
                LegacyMetrics legacyMetrics = this.metrics;
                synchronized (legacyMetrics) {
                    Long num = this.metrics.incrementCounter(this.numCounter);
                    Long time = this.metrics.incrementCounter(this.timeCounter, endTime - this.startTime);
                    if (num != null && time != null) {
                        this.metrics.set(this.avgTimeCounter, time.doubleValue() / num.doubleValue());
                    }
                }
            } else {
                throw new IOException("Scope named " + this.name + " is not open, cannot be closed.");
            }
            this.isOpen = false;
        }

        public void reopen() throws IOException {
            if (this.isOpen) {
                this.close();
            }
            this.open();
        }
    }
}

