/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui;

import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class ERDUIUtils {
    private static final Log log = Log.getLog(ERDUIUtils.class);

    public static void openObjectEditor(@NotNull ERDObject object) {
        if (object.getObject() instanceof DBSObject) {
            UIUtils.runUIJob((String)"Open object editor", monitor -> {
                DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)((DBSObject)object.getObject()), (boolean)true);
                if (node != null) {
                    NavigatorUtils.openNavigatorNode((Object)node, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
                }
            });
        }
    }

    public static String getFullAttributeLabel(EntityDiagram diagram, ERDEntityAttribute attribute, boolean includeType) {
        String comment;
        String attributeLabel = attribute.getName();
        if (includeType && diagram.hasAttributeStyle(ERDViewStyle.TYPES)) {
            attributeLabel = String.valueOf(attributeLabel) + ": " + ((DBSEntityAttribute)attribute.getObject()).getFullTypeName();
        }
        if (includeType && diagram.hasAttributeStyle(ERDViewStyle.NULLABILITY) && ((DBSEntityAttribute)attribute.getObject()).isRequired()) {
            attributeLabel = String.valueOf(attributeLabel) + " NOT NULL";
        }
        if (diagram.hasAttributeStyle(ERDViewStyle.COMMENTS) && !CommonUtils.isEmpty((String)(comment = ((DBSEntityAttribute)attribute.getObject()).getDescription()))) {
            attributeLabel = String.valueOf(attributeLabel) + " - " + comment;
        }
        return attributeLabel;
    }
}

