/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.utils.CommonUtils;

public class DatabaseMappingAttribute
implements DatabaseMappingObject {
    private static final Log log = Log.getLog(DatabaseMappingAttribute.class);
    public static final String TARGET_NAME_SKIP = "[skip]";
    private final DatabaseMappingContainer parent;
    private DBSAttributeBase source;
    private DBSEntityAttribute target;
    private String targetName;
    private String targetType;
    private DatabaseMappingType mappingType;

    DatabaseMappingAttribute(DatabaseMappingContainer parent, DBSAttributeBase source) {
        this.parent = parent;
        this.source = source;
        this.mappingType = DatabaseMappingType.unspecified;
    }

    DatabaseMappingAttribute(DatabaseMappingAttribute attribute, DatabaseMappingContainer parent) {
        this.parent = parent;
        this.source = attribute.source;
        this.target = attribute.target;
        this.targetName = attribute.targetName;
        this.targetType = attribute.targetType;
        this.mappingType = attribute.mappingType;
    }

    public DatabaseMappingContainer getParent() {
        return this.parent;
    }

    @Override
    public DBPImage getIcon() {
        return DBValueFormatting.getObjectImage((DBPObject)this.source);
    }

    public DBSAttributeBase getSource() {
        return this.source;
    }

    public String getSourceType() {
        String typeName = this.source.getTypeName();
        if (this.source.getDataKind() == DBPDataKind.STRING) {
            typeName = String.valueOf(typeName) + "(" + this.source.getMaxLength() + ")";
        }
        return typeName;
    }

    @Override
    public String getTargetName() {
        switch (this.mappingType) {
            case existing: {
                if (this.target != null) {
                    return DBUtils.getObjectFullName((DBPNamedObject)this.target, (DBPEvaluationContext)DBPEvaluationContext.UI);
                }
                return this.targetName;
            }
            case create: {
                return this.targetName;
            }
            case skip: {
                return TARGET_NAME_SKIP;
            }
        }
        return "?";
    }

    @Override
    public DatabaseMappingType getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(DatabaseMappingType mappingType) {
        this.mappingType = mappingType;
        switch (mappingType) {
            case create: {
                this.targetName = this.getSourceLabelOrName(this.getSource());
            }
        }
    }

    public void updateMappingType(DBRProgressMonitor monitor) throws DBException {
        DBSObjectContainer container;
        switch (this.parent.getMappingType()) {
            case existing: {
                this.mappingType = DatabaseMappingType.unspecified;
                if (!(this.parent.getTarget() instanceof DBSEntity)) break;
                if (CommonUtils.isEmpty((String)this.targetName)) {
                    this.targetName = this.source.getName();
                }
                DBSEntity targetEntity = (DBSEntity)this.parent.getTarget();
                List targetAttributes = targetEntity.getAttributes(monitor);
                this.target = (DBSEntityAttribute)DBUtils.findObject((Collection)targetAttributes, (String)DBUtils.getUnQuotedIdentifier((DBPDataSource)targetEntity.getDataSource(), (String)this.targetName), (boolean)true);
                if (this.source instanceof StreamDataImporterColumnInfo && targetAttributes != null) {
                    StreamDataImporterColumnInfo source = (StreamDataImporterColumnInfo)this.source;
                    if (!source.isMappingMetadataPresent()) {
                        List suitableTargetAttributes = targetAttributes.stream().filter(attr -> !DBUtils.isPseudoAttribute((DBSAttributeBase)attr) && !DBUtils.isHiddenObject((Object)attr)).sorted(Comparator.comparing(DBSAttributeBase::getOrdinalPosition)).collect(Collectors.toList());
                        if (source.getOrdinalPosition() < suitableTargetAttributes.size()) {
                            DBSEntityAttribute targetAttribute = (DBSEntityAttribute)suitableTargetAttributes.get(source.getOrdinalPosition());
                            this.targetName = targetAttribute.getName();
                            this.target = (DBSEntityAttribute)DBUtils.findObject((Collection)targetAttributes, (String)DBUtils.getUnQuotedIdentifier((DBPDataSource)targetEntity.getDataSource(), (String)this.targetName), (boolean)true);
                        }
                    }
                    if (this.target != null) {
                        source.setTypeName(this.target.getTypeName());
                        source.setMaxLength(this.target.getMaxLength());
                        source.setDataKind(this.target.getDataKind());
                    }
                }
                if (this.target != null) {
                    this.mappingType = DatabaseMappingType.existing;
                    break;
                }
                this.mappingType = DatabaseMappingType.create;
                break;
            }
            case create: {
                this.mappingType = DatabaseMappingType.create;
                if (!CommonUtils.isEmpty((String)this.targetName)) break;
                this.targetName = this.getSourceLabelOrName(this.source);
                break;
            }
            case skip: {
                this.mappingType = DatabaseMappingType.skip;
                break;
            }
            default: {
                this.mappingType = DatabaseMappingType.unspecified;
            }
        }
        if (this.mappingType == DatabaseMappingType.create && !CommonUtils.isEmpty((String)this.targetName) && (container = this.parent.getSettings().getContainer()) != null) {
            this.targetName = DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)this.targetName);
        }
    }

    private String getSourceLabelOrName(DBSAttributeBase source) {
        DBSObjectContainer container;
        String name = null;
        if (source instanceof DBDAttributeBinding) {
            name = ((DBDAttributeBinding)source).getLabel();
        }
        if (CommonUtils.isEmpty(name)) {
            name = source.getName();
        }
        if ((container = this.parent.getSettings().getContainer()) != null && !DBUtils.isQuotedIdentifier((DBPDataSource)container.getDataSource(), (String)name)) {
            name = DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)name);
        }
        return container == null ? name : DBUtils.getQuotedIdentifier((DBPDataSource)container.getDataSource(), (String)name);
    }

    public DBSEntityAttribute getTarget() {
        return this.target;
    }

    public void setTarget(DBSEntityAttribute target) {
        this.target = target;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetType(DBPDataSource targetDataSource, boolean addModifiers) {
        if (!CommonUtils.isEmpty((String)this.targetType)) {
            return this.targetType;
        }
        return DBStructUtils.mapTargetDataType((DBSObject)targetDataSource, (DBSTypedObject)this.source, (boolean)addModifiers);
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    void saveSettings(Map<String, Object> settings) {
        if (this.targetName != null) {
            settings.put("targetName", this.targetName);
        }
        if (this.targetType != null) {
            settings.put("targetType", this.targetType);
        }
        if (this.mappingType != null) {
            settings.put("mappingType", this.mappingType.name());
        }
    }

    public void loadSettings(Map<String, Object> settings) {
        this.targetName = CommonUtils.toString((Object)settings.get("targetName"));
        this.targetType = CommonUtils.toString((Object)settings.get("targetType"));
        if (settings.get("mappingType") != null) {
            try {
                DBSDataManipulator targetEntity;
                DatabaseMappingType newMappingType = DatabaseMappingType.valueOf((String)settings.get("mappingType"));
                if (!CommonUtils.isEmpty((String)this.targetName) && (targetEntity = this.parent.getTarget()) instanceof DBSEntity) {
                    this.target = ((DBSEntity)targetEntity).getAttribute((DBRProgressMonitor)new VoidProgressMonitor(), DBUtils.getUnQuotedIdentifier((DBPDataSource)((DBSEntity)targetEntity).getDataSource(), (String)this.targetName));
                }
                if (this.target != null && newMappingType == DatabaseMappingType.create) {
                    newMappingType = DatabaseMappingType.existing;
                } else if (this.target == null && newMappingType == DatabaseMappingType.existing) {
                    newMappingType = DatabaseMappingType.create;
                }
                this.mappingType = newMappingType;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public String toString() {
        return this.source.getName();
    }
}

