/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.db.mongodb.model.MGFunction;
import com.dbeaver.db.mongodb.model.MGUser;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class MGDatabase
implements DBSCatalog,
DBPSaveableObject,
DBPNamedObject2,
DBPSystemObject,
DBPRefreshableObject,
DBPObjectStatistics {
    private final MGDataSource dataSource;
    private String dbName;
    private final CollectionCache collectionCache = new CollectionCache();
    private final FunctionCache functionCache = new FunctionCache();
    private final UsersCache userCache = new UsersCache();
    private boolean persisted;
    private DBObject dbStats;

    public MGDatabase(MGDataSource dataSource, String dbName) {
        this.dataSource = dataSource;
        this.dbName = dbName;
        this.persisted = true;
    }

    public CollectionCache getCollectionCache() {
        return this.collectionCache;
    }

    @NotNull
    public MGDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.dbName;
    }

    public void setName(String dbName) {
        this.dbName = dbName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public MGCollection getCollection(DBRProgressMonitor monitor, String name) throws DBException {
        return (MGCollection)this.collectionCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<MGCollection> getCollections(DBRProgressMonitor monitor) throws DBException {
        return this.collectionCache.getAllObjects(monitor, this);
    }

    public Collection<MGCollection> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.collectionCache.getAllObjects(monitor, this);
    }

    public MGCollection getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (MGCollection)this.collectionCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<MGCollection> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return MGCollection.class;
    }

    @Association
    public Collection<MGFunction> getFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.functionCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<MGUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, this);
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.collectionCache.getAllObjects(monitor, this);
    }

    @NotNull
    public synchronized DB getDB(MongoSession session) throws DBCException {
        MongoClient client = session.getExecutionContext().getClient();
        if (client == null) {
            throw new DBCException("Not connected to Mongo");
        }
        return client.getDB(this.dbName);
    }

    @NotNull
    public synchronized MongoDatabase getDatabase(MongoSession session) throws DBCException {
        MongoClient client = session.getExecutionContext().getClient();
        if (client == null) {
            throw new DBCException("Not connected to Mongo");
        }
        return client.getDatabase(this.dbName);
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return this.dbName.equals("admin") || this.dbName.equals("local");
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.collectionCache.clearCache();
        this.functionCache.clearCache();
        this.userCache.clearCache();
        this.dbStats = null;
        return this;
    }

    public boolean hasStatistics() {
        return this.dbStats != null;
    }

    public long getStatObjectSize() {
        if (this.dbStats != null) {
            Object dataSize = this.dbStats.get("dataSize");
            if (dataSize == null) {
                dataSize = this.dbStats.get("storageSize");
            }
            if (dataSize == null) {
                return -1L;
            }
            return CommonUtils.toLong((Object)dataSize);
        }
        return -1L;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    public void readStatistics(DBRProgressMonitor monitor) throws DBException {
        if (this.dbStats != null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (MongoSession session = (MongoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read collections");){
                this.dbStats = this.getDB(session).command("dbStats");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBException("Error reading database statistics", (Throwable)e);
        }
        if (this.dbStats.get("error") != null) {
            throw new DBException("Error reading database statistics: " + this.dbStats.get("error"));
        }
    }

    class CollectionCache
    extends BasicObjectCache<MGDatabase, MGCollection> {
        CollectionCache() {
        }

        @NotNull
        public List<MGCollection> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGDatabase mongoDatabase) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGCollection> tables = new ArrayList<MGCollection>();
                Throwable throwable = null;
                Object var5_6 = null;
                try (MongoSession session = (MongoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)MGDatabase.this, (String)"Read collections");){
                    if (MGDatabase.this.dataSource.isServerVersionAtLeast(4, 0)) {
                        List firstBatch;
                        Document listCollectionsCommand = new Document("listCollections", (Object)"1");
                        listCollectionsCommand.put("nameOnly", (Object)true);
                        listCollectionsCommand.put("authorizedCollections", (Object)true);
                        Document result = MGDatabase.this.getDatabase(session).runCommand((Bson)listCollectionsCommand);
                        if (result.get((Object)"error") != null) {
                            throw new DBException("Error reading collection names: " + result.get((Object)"error"));
                        }
                        Document colNamesCursor = (Document)result.get((Object)"cursor");
                        if (colNamesCursor != null && (firstBatch = colNamesCursor.getList((Object)"firstBatch", Document.class)) != null) {
                            for (Document colDocument : firstBatch) {
                                String colName = (String)colDocument.get((Object)"name");
                                if (colName == null) continue;
                                tables.add(new MGCollection(MGDatabase.this, colName, true));
                            }
                        }
                    } else {
                        for (String colName : MGDatabase.this.getDatabase(session).listCollectionNames()) {
                            tables.add(new MGCollection(MGDatabase.this, colName, true));
                        }
                    }
                    tables.sort(DBUtils.nameComparator());
                    this.setCache(tables);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return this.getCachedObjects();
        }
    }

    class FunctionCache
    extends BasicObjectCache<MGDatabase, MGFunction> {
        FunctionCache() {
        }

        @NotNull
        public List<MGFunction> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGDatabase mongoDatabase) throws DBException {
            if (!this.isFullyCached()) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (MongoSession session = (MongoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)MGDatabase.this, (String)"Read functions");){
                    ArrayList<MGFunction> functions = new ArrayList<MGFunction>();
                    MongoCollection jsCol = MGDatabase.this.getDatabase(session).getCollection("system.js", Document.class);
                    for (Document jsObject : jsCol.find()) {
                        String name = (String)jsObject.get((Object)"_id");
                        Object value = jsObject.get((Object)"value");
                        functions.add(new MGFunction(mongoDatabase, true, name, CommonUtils.toString((Object)value)));
                        if (monitor.isCanceled()) break;
                    }
                    this.setCache(functions);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return this.getCachedObjects();
        }
    }

    class UsersCache
    extends BasicObjectCache<MGDatabase, MGUser> {
        UsersCache() {
        }

        @NotNull
        public List<MGUser> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGDatabase mongoDatabase) throws DBException {
            if (!this.isFullyCached()) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (MongoSession session = (MongoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)MGDatabase.this, (String)"Read users");){
                    ArrayList<MGUser> functions = new ArrayList<MGUser>();
                    MongoDatabase adminDB = MGDatabase.this.getDataSource().getAdminDatabase(session);
                    if (adminDB != null) {
                        MongoCollection usersCol = adminDB.getCollection("system.users", Document.class);
                        BasicDBObject dbCriteria = new BasicDBObject("db", (Object)MGDatabase.this.getName());
                        for (Document jsObject : usersCol.find((Bson)dbCriteria)) {
                            String name = (String)jsObject.get((Object)"user");
                            functions.add(new MGUser(mongoDatabase, name));
                            if (monitor.isCanceled()) break;
                        }
                        this.setCache(functions);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return this.getCachedObjects();
        }
    }
}

