/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.ee.runtime.security.StaticTLSUtils;
import com.mongodb.MongoCredential;
import java.io.File;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;

public class AWSDocumentDBDataSource
extends MGDataSource {
    private static final Log log = Log.getLog(AWSDocumentDBDataSource.class);
    private static final String AWS_RDS_CA_BUNDLE_URL = "https://s3.amazonaws.com/rds-downloads/rds-combined-ca-bundle.pem";
    private static final String AWS_LOCAL_CONFIG_FOLDER = ".aws";

    public AWSDocumentDBDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    @Override
    public boolean supportsDecimal128() {
        return false;
    }

    @Override
    public DBWHandlerConfiguration getCustomSSLConfiguration(DBRProgressMonitor monitor, DBPConnectionConfiguration connectionInfo) {
        NetworkHandlerDescriptor sslHD = NetworkHandlerRegistry.getInstance().getDescriptor("mongo_ssl");
        if (sslHD == null) {
            log.warn((Object)"No Mongo SSL handler descriptor found");
            return null;
        }
        File caCertFile = StaticTLSUtils.getStaticCertFile((DBRProgressMonitor)monitor, AWSDocumentDBDataSource.class, (String)AWS_LOCAL_CONFIG_FOLDER, (String)AWS_RDS_CA_BUNDLE_URL);
        if (caCertFile != null) {
            DBWHandlerConfiguration sslConfig = new DBWHandlerConfiguration((DBWHandlerDescriptor)sslHD, this.getContainer());
            sslConfig.setEnabled(true);
            sslConfig.setProperty("ssl.ca.cert", (Object)caCertFile.getAbsolutePath());
            sslConfig.setProperty("sslInvalidHostNameAllowed", (Object)true);
            sslConfig.setProperty("ssl.self-signed-cert", (Object)true);
            return sslConfig;
        }
        return null;
    }

    @Override
    public String getDefaultAuthMachanism() {
        return MongoCredential.SCRAM_SHA_1_MECHANISM;
    }

    @Override
    public boolean isEvalSupported() {
        return false;
    }

    @Override
    public String getDatabaseType() {
        return "DocumentDB";
    }
}

