/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.exec.js.MongoJSDatabase;
import com.dbeaver.db.mongodb.model.MGDatabase;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.bson.types.ObjectId;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCStatement;

public class MongoJSProcessor {
    private static final String JS_ENGINE_NAME = "nashorn";
    private static final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private final MongoSession session;
    private final MGDatabase database;
    private final ScriptEngine engine;

    public MongoJSProcessor(MongoSession session, MGDatabase database) {
        this.session = session;
        this.database = database;
        this.engine = scriptEngineManager.getEngineByName(JS_ENGINE_NAME);
        SimpleScriptContext context = new SimpleScriptContext();
        context.setAttribute("db", new MongoJSDatabase(this, database), 100);
        context.setAttribute("ObjectId", ObjectId::new, 100);
        this.engine.setContext(context);
    }

    public MongoSession getSession() {
        return this.session;
    }

    public static MongoJSProcessor forStatement(MongoSession session, DBCStatement statement, MGDatabase database) {
        DBCScriptContext scriptContext;
        DBCExecutionSource statementSource = statement.getStatementSource();
        if (statementSource != null && (scriptContext = statementSource.getScriptContext()) != null) {
            MongoJSProcessor processor = (MongoJSProcessor)scriptContext.getData("mongoEngine");
            if (processor == null) {
                processor = new MongoJSProcessor(session, database);
                scriptContext.setData("mongoEngine", (Object)processor);
            }
            return processor;
        }
        return new MongoJSProcessor(session, database);
    }

    public Object eval(String code) throws DBCException {
        try {
            return this.engine.eval(code);
        }
        catch (ScriptException e) {
            throw new DBCException("Evaluation error", (Throwable)e);
        }
    }
}

