/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import com.dbeaver.db.mongodb.exec.js.MongoJSCollection;
import com.dbeaver.db.mongodb.exec.js.MongoJSProcessor;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.meta.RuntimeAction;
import org.jkiss.utils.CommonUtils;

public class MongoJSDatabase
extends AbstractMap<String, Object> {
    private static final Log log = Log.getLog(MongoJSDatabase.class);
    private final MongoJSProcessor processor;
    private final MGDatabase database;

    public MongoJSDatabase(MongoJSProcessor processor, MGDatabase database) {
        this.processor = processor;
        this.database = database;
    }

    public MongoJSProcessor getProcessor() {
        return this.processor;
    }

    public MGDatabase getDatabase() {
        return this.database;
    }

    @Override
    public Object get(Object key) {
        try {
            MGCollection collection = this.database.getCollection(this.processor.getSession().getProgressMonitor(), CommonUtils.toString((Object)key));
            return collection == null ? null : new MongoJSCollection(this, collection);
        }
        catch (DBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        try {
            LinkedHashSet<Map.Entry<String, Object>> res = new LinkedHashSet<Map.Entry<String, Object>>();
            for (MGCollection col : this.database.getCollections(this.processor.getSession().getProgressMonitor())) {
                res.add(new AbstractMap.SimpleEntry<String, MongoJSCollection>(col.getName(), new MongoJSCollection(this, col)));
            }
            return res;
        }
        catch (DBException e) {
            log.debug((Object)e);
            return Collections.emptySet();
        }
    }

    @RuntimeAction
    public Map<String, Object> adminCommand(String command) throws DBCException {
        ClientSession clientSession = this.processor.getSession().getClientSession();
        if (clientSession == null) {
            return this.database.getDataSource().getAdminDB(this.processor.getSession()).command((DBObject)new BasicDBObject(command, (Object)1));
        }
        MongoDatabase adminDatabase = this.database.getDataSource().getAdminDatabase(this.processor.getSession());
        return adminDatabase.runCommand(this.processor.getSession().getClientSession(), (Bson)new Document(command, (Object)1));
    }

    @RuntimeAction
    public Map<String, Object> commandHelp(String command) throws DBCException {
        MongoDatabase adminDatabase = this.database.getDataSource().getAdminDatabase(this.processor.getSession());
        return adminDatabase.runCommand(this.processor.getSession().getClientSession(), (Bson)new Document("commandHelp", (Object)command));
    }

    @RuntimeAction
    public MongoIterable<String> getCollectionNames() throws DBCException {
        MongoDatabase adminDatabase = this.database.getDatabase(this.processor.getSession());
        return adminDatabase.listCollectionNames();
    }

    @RuntimeAction
    public Map<String, Object> currentOp() throws DBCException {
        ClientSession clientSession = this.processor.getSession().getClientSession();
        if (clientSession == null) {
            return this.getAdminDB().command((DBObject)new BasicDBObject("currentOp", (Object)"1"));
        }
        return this.getAdminDatabase().runCommand(clientSession, (Bson)new Document("currentOp", (Object)"1"));
    }

    @RuntimeAction
    public Object eval(String script) throws DBCException {
        DB db = this.database.getDB(this.processor.getSession());
        return db.eval(script, new Object[0]);
    }

    @NotNull
    private MongoDatabase getAdminDatabase() throws DBCException {
        ClientSession clientSession = this.processor.getSession().getClientSession();
        if (clientSession == null) {
            throw new DBCException("Mongo session is not supported");
        }
        return this.getDatabase().getDataSource().getAdminDatabase(this.processor.getSession());
    }

    @NotNull
    private DB getAdminDB() throws DBCException {
        DB adminDatabase = this.getDatabase().getDataSource().getAdminDB(this.processor.getSession());
        return adminDatabase == null ? this.getDatabase().getDB(this.processor.getSession()) : adminDatabase;
    }
}

