/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.MongoUtils;
import com.dbeaver.db.mongodb.exec.MongoBaseStatement;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class MongoInsertStatement
extends MongoBaseStatement {
    private DBSAttributeBase[] valueAttributes;
    private final List<Object[]> rowValues = new ArrayList<Object[]>();
    private int[] batchResult;

    public MongoInsertStatement(MongoSession session, MGCollection mongoCollection, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        super(session, MongoInsertStatement.makeQuery(mongoCollection, updateAttributes, rowValues));
        this.collection = mongoCollection;
        this.valueAttributes = updateAttributes;
    }

    public void addRowValues(Object[] rowValues) {
        this.rowValues.add(rowValues);
    }

    @Override
    public void addToBatch() throws DBCException {
    }

    @Override
    public int[] executeStatementBatch() throws DBCException {
        this.executeStatement();
        return this.batchResult;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            this.batchResult = new int[this.rowValues.size()];
            ArrayList<DBObject> newDocs = new ArrayList<DBObject>();
            for (Object[] row : this.rowValues) {
                BasicDBObject o;
                if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
                    o = (DBObject)MongoUtils.unwrapMongoValue(this.valueAttributes[0], ((DBDDocument)row[0]).getRootNode());
                } else {
                    o = new BasicDBObject();
                    int i = 0;
                    while (i < this.valueAttributes.length) {
                        String attrName = MongoUtils.unquote(this.collection.getAttributeName(this.valueAttributes[i]));
                        attrName = attrName.replace(".", "_");
                        Object attrValue = MongoUtils.unwrapMongoValue(this.valueAttributes[i], row[i]);
                        o.put(attrName, attrValue);
                        ++i;
                    }
                }
                newDocs.add(MongoUtils.normalizeMongoValue(((MongoSession)this.getSession()).getDataSource(), (DBObject)o));
            }
            this.writeResult = this.collection.getCollection((MongoSession)this.getSession()).insert(newDocs);
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
            this.rowValues.clear();
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO  ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" (");
        int i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeName(updateAttributes[i]));
            ++i;
        }
        sql.append(") VALUES (");
        i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeValue(updateAttributes[i], rowValues[i]));
            ++i;
        }
        sql.append(")");
        return sql.toString();
    }
}

