/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.MongoConstants;
import com.dbeaver.db.mongodb.MongoUtils;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import javax.net.ssl.SSLContext;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class MongoExecutionContext
extends AbstractExecutionContext<MGDataSource>
implements DBCExecutionContextDefaults<MGDatabase, DBSSchema>,
DBCTransactionManager {
    private static final Log log = Log.getLog(MongoExecutionContext.class);
    private static final char[] EMPTY_PASSWORD = "".toCharArray();
    private boolean autoCommitState;
    private MongoClient client;
    private ClientSession clientSession;
    private Document buildInfo;
    private String selectedDatabase;

    public MongoExecutionContext(MGDataSource dataSource, String purpose, String selectedDatabase) {
        super((DBPDataSource)dataSource, purpose);
        this.selectedDatabase = selectedDatabase;
    }

    public MongoClient getClient() {
        return this.client;
    }

    @Nullable
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((MGDataSource)this.dataSource).getContainer());
        try {
            try {
                this.autoCommitState = true;
                monitor.subTask("Open cluster session");
                this.reconnect(monitor);
                super.initContextBootstrap(monitor, this.autoCommitState);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((MGDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public MongoSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new MongoSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        this.reconnect(monitor);
        ((MGDataSource)this.dataSource).refreshObject(monitor);
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MongoExecutionContext mongoExecutionContext = this;
        synchronized (mongoExecutionContext) {
            if (this.clientSession != null) {
                this.clientSession.close();
                this.clientSession = null;
            }
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            super.closeContext();
        }
    }

    public void reconnect(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Open " + ((MGDataSource)this.dataSource).getDatabaseType() + " cluster connection", 3);
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        DBPConnectionConfiguration connectionInfo = ((MGDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        String hostPort = connectionInfo.getHostPort();
        String selectedDatabase = ((MGDataSource)this.dataSource).getDefaultDatabase();
        try {
            try {
                String replicaSet;
                String authString;
                monitor.subTask("Setting connection parameters");
                ServerAddress address = new ServerAddress(hostName, Integer.parseInt(hostPort));
                String mechanism = connectionInfo.getProviderProperty("@dbeaver-mongo-cred-mechanism@");
                if (mechanism == null) {
                    mechanism = ((MGDataSource)this.dataSource).getDefaultAuthMachanism();
                }
                MongoCredential credential = null;
                String userName = null;
                String userPassword = null;
                String userDB = connectionInfo.getProviderProperty("@dbeaver-auth-source@");
                if (CommonUtils.isEmpty((String)userDB)) {
                    userDB = connectionInfo.getDatabaseName();
                }
                if ((authString = connectionInfo.getProviderProperty("@dbeaver-auth@0")) != null) {
                    String[] authTokens = MongoUtils.extractAuthInfo(authString);
                    userName = authTokens[0];
                    userDB = authTokens[1];
                    userPassword = authTokens[2];
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
                    userName = connectionInfo.getUserName();
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
                    userPassword = connectionInfo.getUserPassword();
                }
                if (!CommonUtils.isEmpty((String)userName) && !"NONE".equals(mechanism)) {
                    if (mechanism.equals(MongoCredential.PLAIN_MECHANISM)) {
                        credential = MongoCredential.createPlainCredential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.GSSAPI_MECHANISM)) {
                        credential = MongoCredential.createGSSAPICredential((String)userName);
                    } else if (mechanism.equals(MongoCredential.MONGODB_CR_MECHANISM)) {
                        credential = MongoCredential.createMongoCRCredential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.SCRAM_SHA_1_MECHANISM)) {
                        credential = MongoCredential.createScramSha1Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.SCRAM_SHA_256_MECHANISM)) {
                        credential = MongoCredential.createScramSha256Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
                    } else if (mechanism.equals(MongoCredential.MONGODB_X509_MECHANISM)) {
                        credential = MongoCredential.createMongoX509Credential((String)userName);
                    }
                }
                MongoClientOptions.Builder builder = MongoClientOptions.builder();
                if (!((MGDataSource)this.dataSource).getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
                    builder.applicationName(DBUtils.getClientApplicationName((DBPDataSourceContainer)((MGDataSource)this.getDataSource()).getContainer(), (DBCExecutionContext)this, null));
                }
                if (connectionInfo.getProperty("serverSelectTimeout") != null) {
                    builder.serverSelectionTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("serverSelectTimeout")));
                } else {
                    builder.serverSelectionTimeout(5000);
                }
                if (connectionInfo.getProperty("connectTimeout") != null) {
                    builder.connectTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("connectTimeout")));
                }
                if (connectionInfo.getProperty("socketTimeout") != null) {
                    builder.socketTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("socketTimeout")));
                }
                if (connectionInfo.getProperty("socketKeepAlive") != null) {
                    builder.socketKeepAlive(CommonUtils.toBoolean((Object)connectionInfo.getProperty("socketKeepAlive")));
                }
                if (connectionInfo.getProperty("maxConnectionIdleTime") != null) {
                    builder.maxConnectionIdleTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxConnectionIdleTime")));
                }
                if (connectionInfo.getProperty("maxConnectionLifeTime") != null) {
                    builder.maxConnectionLifeTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxConnectionLifeTime")));
                }
                if (connectionInfo.getProperty("maxWaitTime") != null) {
                    builder.maxWaitTime(CommonUtils.toInt((Object)connectionInfo.getProperty("maxWaitTime")));
                }
                if (connectionInfo.getProperty("heartbeatConnectTimeout") != null) {
                    builder.heartbeatConnectTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatConnectTimeout")));
                }
                if (connectionInfo.getProperty("heartbeatSocketTimeout") != null) {
                    builder.heartbeatSocketTimeout(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatSocketTimeout")));
                }
                if (connectionInfo.getProperty("heartbeatFrequency") != null) {
                    builder.heartbeatFrequency(CommonUtils.toInt((Object)connectionInfo.getProperty("heartbeatFrequency")));
                }
                if (!CommonUtils.isEmpty((String)(replicaSet = CommonUtils.toString((Object)connectionInfo.getProviderProperty("replicaSet"), null)))) {
                    builder.requiredReplicaSetName(replicaSet);
                }
                monitor.worked(1);
                DBWHandlerConfiguration sslConfig = connectionInfo.getHandler("mongo_ssl");
                if (sslConfig == null) {
                    sslConfig = ((MGDataSource)this.dataSource).getCustomSSLConfiguration(monitor, connectionInfo);
                }
                if (sslConfig != null && sslConfig.isEnabled()) {
                    monitor.subTask("Initializing SSL");
                    builder.sslEnabled(true);
                    boolean skipHostValidation = sslConfig.getBooleanProperty("sslInvalidHostNameAllowed");
                    if (skipHostValidation) {
                        builder.sslInvalidHostNameAllowed(true);
                    }
                    try {
                        SSLHandlerTrustStoreImpl.initializeTrustStore((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (DBWHandlerConfiguration)sslConfig);
                        SSLContext sslContext = SSLHandlerTrustStoreImpl.createTrustStoreSslContext((DBPDataSource)this.dataSource, (DBWHandlerConfiguration)sslConfig);
                        builder.sslContext(sslContext);
                        log.debug((Object)("Initialized " + sslContext.getProtocol() + " protocol: " + sslContext.getProvider()));
                    }
                    catch (Exception e) {
                        throw new DBCException("Error initializing SSL trust store", (Throwable)e);
                    }
                }
                monitor.worked(1);
                monitor.subTask("Creating client connection");
                MongoClientOptions options = builder.build();
                String url = connectionInfo.getUrl();
                if (MongoUtils.isValidURL(url)) {
                    int userPos = url.indexOf(64);
                    if (userPos == -1) {
                        userPos = url.indexOf("://");
                    }
                    if (userPos != -1 && credential != null) {
                        String userPassPart = credential.getUserName();
                        if (credential.getPassword() != null) {
                            userPassPart = String.valueOf(userPassPart) + ":" + new String(credential.getPassword());
                        }
                        if (url.charAt(userPos) != '@') {
                            userPassPart = String.valueOf(userPassPart) + "@";
                        }
                        url = String.valueOf(url.substring(0, userPos)) + userPassPart + url.substring(userPos);
                    }
                    if (credential != null && credential.getMechanism() != null && !url.contains("authMechanism=")) {
                        url = !url.contains("?") ? String.valueOf(url) + "?" : String.valueOf(url) + "&";
                        url = String.valueOf(url) + "authMechanism=" + credential.getMechanism();
                    }
                    MongoClientURI clientURI = new MongoClientURI(url, builder);
                    this.client = credential == null ? new MongoClient(clientURI) : new MongoClient(clientURI);
                } else {
                    this.client = credential == null ? new MongoClient(address, options) : new MongoClient(address, credential, options);
                }
                monitor.subTask("Connecting to the " + ((MGDataSource)this.dataSource).getDatabaseType() + " server");
                MongoDatabase database = this.client.getDatabase(selectedDatabase);
                this.buildInfo = database.runCommand((Bson)new Document("buildInfo", (Object)1));
                try {
                    this.clientSession = this.client.startSession();
                }
                catch (Exception e) {
                    log.debug((Object)("Sessions are not supported by cluster: " + e.getMessage()));
                }
            }
            catch (Throwable e) {
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
                throw new DBException("Error connecting to " + ((MGDataSource)this.dataSource).getDatabaseType() + " instance [" + hostName + "]", e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public Document getBuildInfo() {
        return this.buildInfo;
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public String getSelectedDatabase() {
        return this.selectedDatabase;
    }

    public MGDatabase getDefaultCatalog() {
        return CommonUtils.isEmpty((String)this.selectedDatabase) ? null : ((MGDataSource)this.getDataSource()).getDatabase(this.selectedDatabase);
    }

    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, MGDatabase catalog, DBSSchema schema) throws DBCException {
        MGDatabase oldSelectedEntity = this.getDefaultCatalog();
        this.selectedDatabase = catalog.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldSelectedEntity, (DBSObject)catalog);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        return true;
    }

    public DBPTransactionIsolation getTransactionIsolation() throws DBCException {
        return MongoConstants.DEFAULT_TXN_ISOLATION;
    }

    public void setTransactionIsolation(@NotNull DBRProgressMonitor monitor, @NotNull DBPTransactionIsolation transactionIsolation) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean isAutoCommit() throws DBCException {
        return this.clientSession == null || !this.clientSession.hasActiveTransaction();
    }

    public void setAutoCommit(@NotNull DBRProgressMonitor monitor, boolean autoCommit) throws DBCException {
        if (this.clientSession == null) {
            throw new DBCFeatureNotSupportedException();
        }
        try {
            if (autoCommit) {
                if (!this.isAutoCommit()) {
                    this.clientSession.abortTransaction();
                }
            } else if (this.isAutoCommit()) {
                this.clientSession.startTransaction();
            }
        }
        finally {
            QMUtils.getDefaultHandler().handleTransactionAutocommit((DBCExecutionContext)this, autoCommit);
        }
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public DBCSavepoint setSavepoint(@NotNull DBRProgressMonitor monitor, String name) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public void releaseSavepoint(@NotNull DBRProgressMonitor monitor, @NotNull DBCSavepoint savepoint) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public void commit(@NotNull DBCSession session) throws DBCException {
        if (this.clientSession == null) {
            throw new DBCFeatureNotSupportedException();
        }
        this.clientSession.commitTransaction();
    }

    public void rollback(@NotNull DBCSession session, @Nullable DBCSavepoint savepoint) throws DBCException {
        if (this.clientSession == null) {
            throw new DBCFeatureNotSupportedException();
        }
        this.clientSession.abortTransaction();
    }

    public boolean isSupportsTransactions() {
        return this.clientSession != null;
    }
}

