/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.MongoUtils;
import com.dbeaver.db.mongodb.exec.MongoBaseStatement;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.update.Update;
import org.bson.BSONObject;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.utils.CommonUtils;

public class MongoCustomStatement
extends MongoBaseStatement {
    private SQLQueryType queryType = SQLQueryType.UNKNOWN;
    private DBObject expression;
    private DBObject values;
    private DBObject sorted;
    private List<DBObject> pipeline;
    private boolean count = false;
    private Statement ddlStatement;
    private String collectionName;
    private MGDataSource dataSource;

    public MongoCustomStatement(MongoSession session, String query) {
        super(session, query);
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            this.makeQueryFromString(this.getQueryString());
            if (this.queryType == SQLQueryType.DDL) {
                boolean bl = this.processDDL();
                return bl;
            }
            if (this.collection == null) {
                throw new DBCException("Can't evaluate Mongo collection from query");
            }
            DBCollection dbCollection = this.collection.getCollection((MongoSession)this.getSession());
            switch (this.queryType) {
                case SELECT: {
                    if (CommonUtils.isEmpty(this.pipeline)) {
                        if (this.count) {
                            this.setExecutionResult(dbCollection.count(this.expression));
                            break;
                        }
                        DBCursor cursor = dbCollection.find(this.expression, this.values);
                        if (this.sorted != null) {
                            cursor = cursor.sort(this.sorted);
                        }
                        this.setExecutionResult(cursor);
                        break;
                    }
                    AggregationOptions options = AggregationOptions.builder().build();
                    Cursor cursor = dbCollection.aggregate(this.pipeline, options);
                    this.resultList = new ArrayList();
                    while (cursor.hasNext()) {
                        this.resultList.add((DBObject)cursor.next());
                    }
                    break;
                }
                case UPDATE: {
                    this.setExecutionResult(dbCollection.update(this.expression, this.values, false, true));
                    break;
                }
                case INSERT: {
                    this.setExecutionResult(dbCollection.insert(new DBObject[]{this.values}));
                    break;
                }
                case DELETE: {
                    this.setExecutionResult(dbCollection.remove(this.expression));
                    break;
                }
                default: {
                    throw new DBCException("Query type '" + this.queryType + "' not supported");
                }
            }
            boolean bl = this.hasResultSet();
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    private boolean processDDL() throws DBException {
        MongoDatabase db = ((MongoSession)this.getSession()).getExecutionContext().getDefaultCatalog().getDatabase((MongoSession)this.getSession());
        if (this.ddlStatement instanceof CreateTable) {
            CreateCollectionOptions colOptions = new CreateCollectionOptions();
            db.createCollection(this.collectionName, colOptions);
        } else if (this.ddlStatement instanceof Drop) {
            MongoCollection collection = db.getCollection(this.collectionName);
            collection.drop();
        } else {
            boolean cfr_ignored_0 = this.ddlStatement instanceof Alter;
        }
        return false;
    }

    private void makeQueryFromString(String queryString) throws JSQLParserException, DBException {
        Statement statement = CCJSqlParserUtil.parse((String)queryString);
        if (statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            this.parseSelect(select);
            this.queryType = SQLQueryType.SELECT;
        } else if (statement instanceof Update) {
            this.parseUpdate((Update)statement);
            this.queryType = SQLQueryType.UPDATE;
        } else if (statement instanceof Delete) {
            this.parseDelete((Delete)statement);
            this.queryType = SQLQueryType.DELETE;
        } else if (statement instanceof CreateTable) {
            this.parseCreateTable((CreateTable)statement);
            this.queryType = SQLQueryType.DDL;
        } else if (statement instanceof Drop) {
            this.parseDropTable((Drop)statement);
            this.queryType = SQLQueryType.DDL;
        } else if (statement instanceof Alter) {
            this.parseAlterTable((Alter)statement);
            this.queryType = SQLQueryType.DDL;
        } else {
            throw new DBCException("Statement " + statement.getClass() + " not supported");
        }
    }

    private void parseCreateTable(CreateTable statement) {
        this.ddlStatement = statement;
        this.collectionName = statement.getTable().getName();
    }

    private void parseDropTable(Drop statement) {
        this.ddlStatement = statement;
        this.collectionName = statement.getName().getName();
    }

    private void parseAlterTable(Alter statement) {
        this.ddlStatement = statement;
        this.collectionName = statement.getTable().getName();
    }

    private void parseSelect(PlainSelect select) throws DBException {
        Limit sLimit;
        DBSDataContainer dataContainer;
        DBCExecutionSource statementSource;
        if (!(select.getFromItem() instanceof Table)) {
            throw new DBCException("FROM keyword missing");
        }
        if (this.dataSource == null && (statementSource = this.getStatementSource()) != null && (dataContainer = statementSource.getDataContainer()) != null) {
            this.dataSource = (MGDataSource)dataContainer.getDataSource();
        }
        Table sourceTable = (Table)select.getFromItem();
        this.collection = this.getCollectionFromTable(sourceTable);
        boolean aggregate = select.getGroupBy() != null || select.getJoins() != null;
        boolean selectAll = false;
        for (SelectItem item : CommonUtils.safeList((List)select.getSelectItems())) {
            Expression expr;
            if (item instanceof AllColumns || item instanceof AllTableColumns) {
                selectAll = true;
                break;
            }
            if (!(item instanceof SelectExpressionItem) || !((expr = ((SelectExpressionItem)item).getExpression()) instanceof Function)) continue;
            Function function = (Function)expr;
            if (function.getName().equalsIgnoreCase("count")) {
                if (function.getParameters() != null) {
                    throw new DBCException("count(*) doesn't accept arguments");
                }
                this.count = true;
                continue;
            }
            if (function.getParameters() == null || function.getParameters().getExpressions().size() != 1) {
                throw new DBCException("Accumulator functions only accept one argument");
            }
            if (!(function.getParameters().getExpressions().get(0) instanceof Column)) {
                throw new DBCException("First argument of an accumulator function must be column name");
            }
            aggregate = true;
        }
        if (aggregate) {
            List orderBy;
            Expression having;
            GroupByElement groupBy;
            Object project;
            this.pipeline = new ArrayList<DBObject>();
            List joins = select.getJoins();
            if (!CommonUtils.isEmpty((Collection)joins)) {
                if (this.dataSource != null && !this.dataSource.isServerVersionAtLeast(3, 2)) {
                    throw new DBCException("Server version must be at least 3.2 to use JOINs");
                }
                if (sourceTable.getAlias() == null) {
                    throw new DBCException("Source table must have alias: " + sourceTable);
                }
                String sourceAlias = sourceTable.getAlias().getName();
                project = new BasicDBObject();
                project.put("_id", (Object)0);
                project.put(sourceAlias, (Object)"$$ROOT");
                this.pipeline.add((DBObject)new BasicDBObject("$project", project));
                for (Join join : joins) {
                    BinaryExpression expr = (BinaryExpression)join.getOnExpression();
                    if (expr == null) {
                        throw new DBCException("JOINs must have ON clause");
                    }
                    FromItem rightItem = join.getRightItem();
                    if (rightItem.getAlias() == null) {
                        throw new DBCException("Target table must have alias: " + rightItem);
                    }
                    String targetAlias = rightItem.getAlias().getName();
                    Column onLeftColumn = (Column)expr.getLeftExpression();
                    Column onRightColumn = (Column)expr.getRightExpression();
                    if (onRightColumn.getTable() != null && !onRightColumn.getTable().getName().equals(rightItem.getAlias().getName())) {
                        throw new DBCException("Right table of ON clause must be equal to the table of JOIN clause: " + rightItem);
                    }
                    if (join.isLeft() || join.isInner()) {
                        String localFieldPath = onLeftColumn.getTable() == null ? sourceAlias : onLeftColumn.getTable().getName();
                        String localField = onLeftColumn.getColumnName();
                        BasicDBObject lookup = new BasicDBObject();
                        lookup.put("from", (Object)MongoUtils.unquote(((Table)rightItem).getFullyQualifiedName()));
                        lookup.put("localField", (Object)(String.valueOf(localFieldPath) + '.' + localField));
                        lookup.put("foreignField", (Object)onRightColumn.getColumnName());
                        lookup.put("as", (Object)targetAlias);
                        this.pipeline.add((DBObject)new BasicDBObject("$lookup", (Object)lookup));
                        if (join.isInner()) {
                            BasicDBObject match = new BasicDBObject();
                            match.put(targetAlias, (Object)new BasicDBObject("$ne", (Object)new BasicDBList()));
                            this.pipeline.add((DBObject)new BasicDBObject("$match", (Object)match));
                        }
                    } else {
                        throw new DBCException("Unsupported JOIN type: " + join.getASTNode().jjtGetFirstToken());
                    }
                    BasicDBObject unwind = new BasicDBObject();
                    unwind.put("path", (Object)(String.valueOf('$') + targetAlias));
                    unwind.put("preserveNullAndEmptyArrays", (Object)true);
                    this.pipeline.add((DBObject)new BasicDBObject("$unwind", (Object)unwind));
                }
            }
            BasicDBObject group = new BasicDBObject();
            project = new BasicDBObject();
            Expression where = select.getWhere();
            if (where != null) {
                this.pipeline.add((DBObject)new BasicDBObject("$match", (Object)MongoUtils.convertExpressionToObject(where)));
            }
            if ((groupBy = select.getGroupBy()) != null) {
                BasicDBObject groupId = new BasicDBObject();
                project.put("_id", (Object)0);
                for (SelectItem item : CommonUtils.safeList((List)select.getSelectItems())) {
                    Function function;
                    if (!(item instanceof SelectExpressionItem)) continue;
                    SelectExpressionItem exprItem = (SelectExpressionItem)item;
                    Expression expr = exprItem.getExpression();
                    if (expr instanceof Column) {
                        Column column = (Column)expr;
                        String columnAlias = MongoUtils.unquote(exprItem.getAlias() == null ? column.getFullyQualifiedName() : exprItem.getAlias().getName());
                        groupId.put(columnAlias, (Object)("$" + MongoUtils.unquote(column.getFullyQualifiedName())));
                        project.put(columnAlias, (Object)("$_id." + columnAlias));
                        boolean contains = false;
                        for (Expression groupItem : groupBy.getGroupByExpressions()) {
                            Column groupColumn;
                            if (!(groupItem instanceof Column) || !MongoUtils.unquote((groupColumn = (Column)groupItem).getFullyQualifiedName()).equals(columnAlias)) continue;
                            contains = true;
                            break;
                        }
                        if (contains) continue;
                        throw new DBCException("Column '" + columnAlias + "' must either be part of GROUP BY or be an accumulator");
                    }
                    if (!(expr instanceof Function) || (function = (Function)expr).getName().equalsIgnoreCase("count")) continue;
                    String functionName = MongoUtils.unquote(function.getName());
                    String functionAlias = exprItem.getAlias() == null ? functionName : MongoUtils.unquote(exprItem.getAlias().getName());
                    Column column = (Column)function.getParameters().getExpressions().get(0);
                    group.put(functionAlias, (Object)new BasicDBObject("$" + functionName.toLowerCase(), (Object)("$" + MongoUtils.unquote(column.getFullyQualifiedName()))));
                    project.put(functionAlias, (Object)("$" + functionAlias));
                }
                group.put("_id", (Object)groupId);
                this.pipeline.add((DBObject)new BasicDBObject("$group", (Object)group));
                this.pipeline.add((DBObject)new BasicDBObject("$project", project));
            }
            if (this.count) {
                group.put("count", (Object)new BasicDBObject("$sum", (Object)1));
                project.put("count", (Object)"$count");
            }
            if ((having = select.getHaving()) != null) {
                this.pipeline.add((DBObject)new BasicDBObject("$match", (Object)MongoUtils.convertExpressionToObject(having)));
            }
            if (!CommonUtils.isEmpty((Collection)(orderBy = select.getOrderByElements()))) {
                BasicDBObject sorted = new BasicDBObject();
                for (OrderByElement item : orderBy) {
                    Expression expr = item.getExpression();
                    if (expr instanceof Column) {
                        Column column = (Column)expr;
                        sorted.put(MongoUtils.unquote(column.getFullyQualifiedName()), (Object)(item.isAsc() ? 1 : -1));
                        continue;
                    }
                    throw new DBCException("Unsupported ORDER BY item: " + item);
                }
                this.pipeline.add((DBObject)new BasicDBObject("$sort", (Object)sorted));
            }
        } else {
            List orderBy;
            this.expression = new BasicDBObject();
            this.values = new BasicDBObject();
            Expression where = select.getWhere();
            if (where != null) {
                this.expression.putAll((BSONObject)MongoUtils.convertExpressionToObject(where));
            }
            if (!selectAll) {
                for (SelectItem item : CommonUtils.safeList((List)select.getSelectItems())) {
                    Expression expr;
                    if (!(item instanceof SelectExpressionItem) || !((expr = ((SelectExpressionItem)item).getExpression()) instanceof Column)) continue;
                    Column column = (Column)expr;
                    this.values.put(MongoUtils.unquote(column.getFullyQualifiedName()), (Object)1);
                }
            }
            if (!CommonUtils.isEmpty((Collection)(orderBy = select.getOrderByElements()))) {
                this.sorted = new BasicDBObject();
                for (OrderByElement item : orderBy) {
                    Expression expr = item.getExpression();
                    if (expr instanceof Column) {
                        Column column = (Column)expr;
                        this.sorted.put(MongoUtils.unquote(column.getFullyQualifiedName()), (Object)(item.isAsc() ? 1 : -1));
                        continue;
                    }
                    throw new DBCException("Unsupported ORDER BY item: " + item);
                }
            }
        }
        if ((sLimit = select.getLimit()) != null) {
            try {
                if (sLimit.getOffset() != null) {
                    this.offset = Long.parseLong(sLimit.getOffset().toString());
                }
                if (sLimit.getRowCount() != null) {
                    this.limit = Long.parseLong(sLimit.getRowCount().toString());
                }
            }
            catch (NumberFormatException e) {
                throw new DBCException("Bad LIMIT clause", (Throwable)e);
            }
        }
    }

    private void parseUpdate(Update update) throws DBException {
        if (update.getTable() == null) {
            throw new DBCException("Can update only one table");
        }
        if (!CommonUtils.isEmpty((Collection)update.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        if (update.getSelect() != null) {
            throw new DBCException("SELECT in UPDATE not supported");
        }
        this.collection = this.getCollectionFromTable(update.getTable());
        List columns = update.getColumns();
        List valueExpressions = update.getExpressions();
        if (CommonUtils.isEmpty((Collection)columns) || CommonUtils.isEmpty((Collection)valueExpressions)) {
            throw new DBCException("Empty columns/values");
        }
        if (columns.size() != valueExpressions.size()) {
            throw new DBCException("Column set doesn't match value set");
        }
        this.values = new BasicDBObject();
        int i = 0;
        while (i < columns.size()) {
            Column item = (Column)columns.get(i);
            Object value = MongoUtils.convertValueExpressionToObject((Expression)valueExpressions.get(i));
            this.values.put("$set", (Object)new BasicDBObject(MongoUtils.unquote(item.getFullyQualifiedName()), value));
            ++i;
        }
        Expression where = update.getWhere();
        if (where != null) {
            this.expression = MongoUtils.convertExpressionToObject(where);
        }
    }

    private void parseDelete(Delete delete) throws DBException {
        if (delete.getTable() == null) {
            throw new DBCException("Can delete only from single table");
        }
        if (!CommonUtils.isEmpty((Collection)delete.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        this.collection = this.getCollectionFromTable(delete.getTable());
        this.expression = new BasicDBObject();
        this.values = new BasicDBObject();
        Expression where = delete.getWhere();
        if (where != null) {
            this.expression = MongoUtils.convertExpressionToObject(where);
        }
    }

    private MGCollection getCollectionFromTable(Table sourceTable) throws DBException {
        MGDatabase database;
        Database dbObject = sourceTable.getDatabase();
        String schemaName = sourceTable.getSchemaName();
        if (schemaName == null) {
            schemaName = ((MongoSession)this.getSession()).getExecutionContext().getSelectedDatabase();
        }
        schemaName = DBUtils.getUnQuotedIdentifier((String)schemaName, (String[][])SQLConstants.DOUBLE_QUOTE_STRINGS);
        String colName = sourceTable.getName();
        if (colName == null) {
            throw new DBCException("Collection not specified in SELECT statement");
        }
        colName = DBUtils.getUnQuotedIdentifier((String)colName, (String[][])SQLConstants.DOUBLE_QUOTE_STRINGS);
        if (dbObject != null && !CommonUtils.isEmpty((String)dbObject.getDatabaseName())) {
            colName = String.valueOf(schemaName) + "." + colName;
            schemaName = dbObject.getDatabaseName();
        }
        if ((database = ((MongoSession)this.getSession()).getDataSource().getDatabase(schemaName)) == null) {
            throw new DBCException("Database '" + schemaName + "' not found");
        }
        MGCollection col = database.getChild(((MongoSession)this.getSession()).getProgressMonitor(), colName);
        if (col == null) {
            throw new DBCException("Collection '" + colName + "' not found in database '" + database.getName() + "'");
        }
        return col;
    }
}

