/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb;

import com.dbeaver.db.mongodb.data.MongoDocument;
import com.dbeaver.db.mongodb.data.MongoListValue;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import org.bson.BsonRegularExpression;
import org.bson.Document;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.PasswordEncrypter;
import org.jkiss.dbeaver.runtime.encode.SimpleStringEncrypter;
import org.jkiss.utils.CommonUtils;

public class MongoUtils {
    private static final Log log = Log.getLog(MongoUtils.class);
    private static PasswordEncrypter ENCRYPTER = new SimpleStringEncrypter();
    public static final String OPER_NE = "$ne";
    public static final String OPER_GT = "$gt";
    public static final String OPER_GTE = "$gte";
    public static final String OPER_LT = "$lt";
    public static final String OPER_LTE = "$lte";
    public static final String OPER_REGEX = "$regex";
    public static final String OPER_IN = "$in";
    public static final String OPER_NOT = "$not";
    public static final String OPER_EXISTS = "$exists";

    @Nullable
    public static DBObject makeQueryFromFilter(@NotNull MGDataSource dataSource, @Nullable DBDDataFilter filter) throws DBCException {
        if (filter == null || !filter.hasConditions()) {
            return null;
        }
        StringBuilder condString = new StringBuilder();
        SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (StringBuilder)condString, (boolean)true);
        try {
            Expression expr = CCJSqlParserUtil.parseCondExpression((String)condString.toString());
            return MongoUtils.convertExpressionToObject(expr);
        }
        catch (JSQLParserException e) {
            throw new DBCException("Bad filter conditions", (Throwable)e);
        }
    }

    @NotNull
    public static String makeSQLQuery(@NotNull MGCollection collection, @Nullable DBDDataFilter filter) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML));
        if (filter != null && filter.hasConditions()) {
            sql.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (StringBuilder)sql, (boolean)true);
        }
        if (filter != null && filter.hasOrdering()) {
            sql.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)filter, (DBPDataSource)collection.getDataSource(), null, (StringBuilder)sql);
        }
        return sql.toString();
    }

    public static int resolveValueType(Object value) {
        if (value instanceof CharSequence) {
            return 3;
        }
        if (value instanceof Number) {
            return 4;
        }
        if (value instanceof Boolean) {
            return 7;
        }
        if (value instanceof Date) {
            return 8;
        }
        if (value instanceof byte[]) {
            return 9;
        }
        if (value instanceof Collection) {
            return 10;
        }
        if (value instanceof MongoDocument) {
            return 2;
        }
        return 11;
    }

    public static Object wrapMongoValue(MGDataSource dataSource, Object value, Object parent) {
        if (value instanceof List) {
            return MongoUtils.wrapMongoList(dataSource, (List)value, parent);
        }
        if (value instanceof Map) {
            return MongoUtils.wrapMongoMap(dataSource, (Map)value, parent);
        }
        if (value instanceof ObjectId) {
            return value.toString();
        }
        return value;
    }

    public static MongoListValue wrapMongoList(MGDataSource dataSource, List<Object> dbList, Object parent) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : dbList) {
            list.add(MongoUtils.wrapMongoValue(dataSource, item, parent));
        }
        return new MongoListValue(dataSource, list);
    }

    @NotNull
    public static DBMapValue<MGDataSource> wrapMongoMap(MGDataSource dataSource, Map<String, Object> value, Object parent) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        DBMapValue mapValue = new DBMapValue((DBPDataSource)dataSource, parent, map);
        for (String name : value.keySet()) {
            Object mValue = value.get(name);
            map.put(name, MongoUtils.wrapMongoValue(dataSource, mValue, mapValue));
        }
        return mapValue;
    }

    public static Object unwrapMongoValue(@Nullable DBSAttributeBase attribute, Object value) {
        return MongoUtils.unwrapMongoValue(attribute == null ? null : attribute.getName(), value);
    }

    public static Object unwrapMongoValue(@Nullable String name, Object value) {
        if (value instanceof MongoDocument) {
            return MongoUtils.unwrapMongoMap((DBMapValue<MGDataSource>)((MongoDocument)((Object)value)).getRootNode());
        }
        if (value instanceof DBMapValue) {
            return MongoUtils.unwrapMongoMap((DBMapValue<MGDataSource>)((DBMapValue)value));
        }
        if (value instanceof Map) {
            return MongoUtils.unwrapPlainMap((Map)value);
        }
        if (value instanceof MongoListValue) {
            return MongoUtils.unwrapMongoList((MongoListValue)((Object)value));
        }
        if (value instanceof String && name != null && name.equals("_id")) {
            ObjectId objectId;
            if (ObjectId.isValid((String)((String)value)) && (objectId = new ObjectId((String)value)).getTimestamp() > 0) {
                return objectId;
            }
            return value;
        }
        return value;
    }

    private static BasicDBObject unwrapMongoMap(DBMapValue<MGDataSource> value) {
        return MongoUtils.unwrapPlainMap(value.getRawValue());
    }

    private static BasicDBObject unwrapPlainMap(Map<String, Object> value) {
        BasicDBObject dbObject = new BasicDBObject();
        if (value != null) {
            for (Map.Entry<String, Object> me : value.entrySet()) {
                dbObject.append(me.getKey(), MongoUtils.unwrapMongoValue(me.getKey(), me.getValue()));
            }
        }
        return dbObject;
    }

    private static BasicDBList unwrapMongoList(MongoListValue value) {
        BasicDBList dbList = new BasicDBList();
        if (value.getRawValue() != null) {
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                dbList.add(MongoUtils.unwrapMongoValue(null, item));
            }
        }
        return dbList;
    }

    public static Object convertValueExpressionToObject(Expression expression) throws DBCException {
        if (expression instanceof StringValue) {
            return ((StringValue)expression).getValue();
        }
        if (expression instanceof LongValue) {
            return ((LongValue)expression).getValue();
        }
        if (expression instanceof DoubleValue) {
            return ((DoubleValue)expression).getValue();
        }
        if (expression instanceof DateValue) {
            return ((DateValue)expression).getValue();
        }
        if (expression instanceof TimestampValue) {
            return ((TimestampValue)expression).getValue();
        }
        return expression.toString();
    }

    public static DBObject convertExpressionToObject(Expression expression) throws DBCException {
        BasicDBObject object = new BasicDBObject();
        MongoUtils.parseExpression(object, expression);
        return object;
    }

    private static void parseExpression(BasicDBObject owner, Expression expr) throws DBCException {
        if (expr instanceof AndExpression) {
            MongoUtils.parseExpression(owner, ((AndExpression)expr).getLeftExpression());
            MongoUtils.parseExpression(owner, ((AndExpression)expr).getRightExpression());
        } else if (expr instanceof InExpression) {
            Expression leftExpression = ((InExpression)expr).getLeftExpression();
            if (!(leftExpression instanceof Column)) {
                throw new DBCException("IN conditions mast have column on the left side");
            }
            if (!(((InExpression)expr).getRightItemsList() instanceof ExpressionList)) {
                throw new DBCException("IN conditions mast have expression list on the right side");
            }
            ExpressionList itemsList = (ExpressionList)((InExpression)expr).getRightItemsList();
            Column column = (Column)leftExpression;
            String fieldName = MongoUtils.unquote(column.getFullyQualifiedName());
            ArrayList<Object> values = new ArrayList<Object>();
            for (Expression exp : itemsList.getExpressions()) {
                Object fieldValue = MongoUtils.parseValueExpression(exp);
                values.add(fieldValue);
            }
            MongoUtils.makeObjectCondition(owner, fieldName, values, OPER_IN);
        } else {
            if (expr instanceof OrExpression) {
                throw new DBCException("OR conditions not supported: " + expr);
            }
            if (expr instanceof BinaryExpression) {
                MongoUtils.parseBinaryExpression(owner, (BinaryExpression)expr);
            } else if (expr instanceof Parenthesis) {
                MongoUtils.parseExpression(owner, ((Parenthesis)expr).getExpression());
            } else {
                throw new DBCException("Unsupported expression: " + expr);
            }
        }
    }

    private static void parseBinaryExpression(BasicDBObject owner, BinaryExpression expr) throws DBCException {
        String operator;
        Expression left = expr.getLeftExpression();
        if (!(left instanceof Column)) {
            throw new DBCException("Unsupported left operand: " + left);
        }
        Column column = (Column)left;
        String fieldName = MongoUtils.unquote(column.getFullyQualifiedName());
        Object fieldValue = MongoUtils.parseValueExpression(expr.getRightExpression());
        if (expr instanceof EqualsTo) {
            operator = null;
        } else if (expr instanceof NotEqualsTo) {
            operator = OPER_NE;
        } else if (expr instanceof GreaterThan) {
            operator = OPER_GT;
        } else if (expr instanceof GreaterThanEquals) {
            operator = OPER_GTE;
        } else if (expr instanceof MinorThan) {
            operator = OPER_LT;
        } else if (expr instanceof MinorThanEquals) {
            operator = OPER_LTE;
        } else if (expr instanceof LikeExpression) {
            LikeExpression like = (LikeExpression)expr;
            operator = like.isNot() ? OPER_NOT : OPER_REGEX;
            fieldValue = MongoUtils.makeRegexFromLike((String)fieldValue, like.isCaseInsensitive() ? "i" : null);
        } else {
            throw new DBCException("Unsupported operation: " + expr.getStringExpression());
        }
        MongoUtils.makeObjectCondition(owner, fieldName, fieldValue, operator);
    }

    private static void makeObjectCondition(BasicDBObject owner, String fieldName, Object fieldValue, String operator) {
        Object value;
        if (fieldName.equals("_id") && fieldValue instanceof String) {
            try {
                fieldValue = new ObjectId((String)fieldValue);
            }
            catch (Exception exception) {}
        }
        if (operator == null) {
            value = fieldValue;
        } else if (fieldValue instanceof List) {
            BasicDBList dbList = new BasicDBList();
            dbList.addAll((Collection)((List)fieldValue));
            value = new BasicDBObject(operator, (Object)dbList);
        } else {
            value = new BasicDBObject(operator, fieldValue);
            if (operator.equals(OPER_NE) || operator.equals(OPER_NOT)) {
                ((DBObject)value).put(OPER_EXISTS, (Object)true);
            }
        }
        owner.put((Object)fieldName, value);
    }

    private static Object parseValueExpression(Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = MongoUtils.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + expr);
        }
        if (expr instanceof Function) {
            String funcName = ((Function)expr).getName();
            ExpressionList parameters = ((Function)expr).getParameters();
            if ("ObjectId".equalsIgnoreCase(funcName)) {
                if (parameters == null || parameters.getExpressions().size() != 1) {
                    throw new DBCException("ObjectId must have 1 parameter");
                }
                return new ObjectId(CommonUtils.toString((Object)MongoUtils.parseValueExpression((Expression)parameters.getExpressions().get(0))));
            }
            if ("ISODate".equalsIgnoreCase(funcName)) {
                if (parameters == null || parameters.getExpressions().size() != 1) {
                    throw new DBCException("ISODate must have 1 parameter");
                }
                return JSONUtils.parseDate((Object)MongoUtils.parseValueExpression((Expression)parameters.getExpressions().get(0)));
            }
            throw new DBCException("Unsupported function: " + funcName);
        }
        if (expr instanceof SignedExpression) {
            Object value = MongoUtils.parseValueExpression(((SignedExpression)expr).getExpression());
            char sign = ((SignedExpression)expr).getSign();
            if (value instanceof Long) {
                if (sign == '-') {
                    return -((Long)value).longValue();
                }
                if (sign == '+') {
                    return value;
                }
            } else if (value instanceof Double) {
                if (sign == '-') {
                    return -((Double)value).doubleValue();
                }
                if (sign == '+') {
                    return value;
                }
            }
        }
        throw new DBCException("Unsupported value: " + expr);
    }

    private static BsonRegularExpression makeRegexFromLike(String clause, String options) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int length = clause.length();
        while (index < length) {
            char ch = clause.charAt(index);
            if (ch == '%') {
                if (index > 0 && index < length - 1) {
                    sb.append(".*");
                }
            } else {
                if (index == 0) {
                    sb.append('^');
                }
                sb.append(ch == '_' ? (char)'.' : (char)ch);
                if (index == length - 1) {
                    sb.append('$');
                }
            }
            ++index;
        }
        return new BsonRegularExpression(sb.toString(), options);
    }

    public static String unquote(String name) {
        CharSequence[] attrNameParts = SQLUtils.splitFullIdentifier((String)name, (String)".", (String[][])SQLConstants.DOUBLE_QUOTE_STRINGS, (boolean)false);
        return String.join((CharSequence)".", attrNameParts);
    }

    public static String toJSON(Map<String, Object> object, boolean preview) {
        return object == null ? "[NULL]" : object.toString();
    }

    public static String saveAuthInfo(String userName, String userDB, String userPassword) {
        if (CommonUtils.isEmpty((String)userName)) {
            return null;
        }
        try {
            return String.valueOf(userName) + "|" + userDB + "|" + ENCRYPTER.encrypt(userPassword);
        }
        catch (EncryptionException encryptionException) {
            return String.valueOf(userName) + "|" + userDB + "|" + userPassword;
        }
    }

    public static String[] extractAuthInfo(String tokens) {
        String[] authTokens = tokens.split("\\|");
        try {
            return new String[]{authTokens[0], authTokens[1], ENCRYPTER.decrypt(authTokens[2])};
        }
        catch (EncryptionException encryptionException) {
            return new String[]{authTokens[0], authTokens[1], authTokens[2]};
        }
    }

    public static String saveSeedInfo(String host, String port) {
        return String.valueOf(host) + "|" + port;
    }

    public static String[] extractSeedInfo(String tokens) {
        String[] authTokens = tokens.split("\\|");
        return new String[]{authTokens[0], authTokens[1]};
    }

    @NotNull
    public static DBObject cloneObject(Object object) {
        if (object instanceof BasicDBObject) {
            return (BasicDBObject)((BasicDBObject)object).copy();
        }
        if (object instanceof BasicDBList) {
            return (BasicDBList)((BasicDBList)object).copy();
        }
        if (object instanceof DBObject) {
            return (DBObject)object;
        }
        throw new IllegalArgumentException("Can't copy object [" + object + "]");
    }

    @Nullable
    public static String[] getHostnamesFromURL(@NotNull String url) {
        int optsPos;
        if (!MongoUtils.isValidURL(url)) {
            return null;
        }
        String hostnames = url.substring(url.indexOf("://") + 3);
        int userPos = hostnames.indexOf(64);
        if (userPos != -1) {
            hostnames = hostnames.substring(userPos + 1);
        }
        if ((optsPos = hostnames.indexOf(47)) != -1) {
            hostnames = hostnames.substring(0, optsPos);
        }
        return CommonUtils.split((String)hostnames, (String)",");
    }

    public static boolean isValidURL(String url) {
        return !CommonUtils.isEmpty((String)url) && !url.startsWith("mongo://");
    }

    public static List<? extends Document> createList(List<Map<String, Object>> documents) {
        ArrayList<Document> result = new ArrayList<Document>();
        for (Map<String, Object> item : documents) {
            result.add(new Document(item));
        }
        return result;
    }

    public static List<DBObject> createDBList(List<Map<String, Object>> documents) {
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        for (Map<String, Object> item : documents) {
            result.add((DBObject)new BasicDBObject(item));
        }
        return result;
    }

    public static DBObject normalizeMongoValue(MGDataSource dataSource, DBObject o) {
        if (o instanceof Map) {
            MongoUtils.normalizeDocument(dataSource, (Map)o);
        } else if (o instanceof List) {
            MongoUtils.normalizeDocument(dataSource, (List)o);
        }
        return o;
    }

    public static void normalizeDocument(MGDataSource dataSource, Map<String, Object> o) {
        for (Map.Entry<String, Object> entry : o.entrySet()) {
            if (!(entry.getValue() instanceof Decimal128) || dataSource.supportsDecimal128()) continue;
            entry.setValue(((Decimal128)entry.getValue()).doubleValue());
        }
    }

    public static void normalizeDocument(MGDataSource dataSource, List<Object> o) {
        for (Object item : o) {
            if (!(item instanceof DBObject)) continue;
            MongoUtils.normalizeMongoValue(dataSource, (DBObject)item);
        }
    }
}

